/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.util.FloatMatrix;

public class Cluster {
    public static final int GENE_CLUSTER = 0;
    public static final int EXPERIMENT_CLUSTER = 1;
    private Color clusterColor;
    private int[] indices;
    private int[] experimentIndices;
    private String source;
    private String clusterID;
    private String clusterLabel;
    private String algorithmName;
    private String clusterDescription;
    private int algorithmIndex;
    private int serialNumber;
    private DefaultMutableTreeNode node;
    private Experiment experiment;
    private Object userObject;
    private boolean isShowColor;
    private int exptID = 0;

    public Cluster(int[] indices, String source, String clusterLabel, String algorithmName, String clusterID, String clusterDescription, Integer index, Integer serialNumber, Color clusterColor, Integer exptID) {
        this.indices = indices;
        this.source = source;
        this.clusterLabel = clusterLabel;
        this.clusterID = clusterID;
        this.algorithmName = algorithmName;
        this.algorithmIndex = index;
        this.clusterColor = clusterColor;
        this.clusterDescription = clusterDescription;
        this.serialNumber = serialNumber;
        this.exptID = exptID;
        this.isShowColor = true;
    }

    public Cluster(int[] indices, String source, String clusterLabel, String algorithmName, String clusterID, String clusterDescription, int index, int serialNumber, Color clusterColor, Experiment experiment) {
        this.indices = indices;
        this.source = source;
        this.clusterLabel = clusterLabel;
        this.clusterID = clusterID;
        this.algorithmName = algorithmName;
        this.algorithmIndex = index;
        this.clusterColor = clusterColor;
        this.clusterDescription = clusterDescription;
        this.serialNumber = serialNumber;
        this.experiment = experiment;
        this.isShowColor = true;
        this.experimentIndices = this.getIndicesMappedToExperiment();
    }

    public Cluster(FloatMatrix fm, String source, String clusterLabel, String algorithmName, String clusterID, String clusterDescription, Integer index, Integer serialNumber, Color clusterColor, DefaultMutableTreeNode node, Experiment experiment) {
        this(Cluster.getIndices(fm), source, clusterLabel, algorithmName, clusterID, clusterDescription, (int)index, (int)serialNumber, clusterColor, (DefaultMutableTreeNode)null, experiment);
    }

    public Cluster(int[] indices, String source, String clusterLabel, String algorithmName, String clusterID, String clusterDescription, Integer index, Integer serialNumber, Color clusterColor, DefaultMutableTreeNode node, Experiment experiment) {
        this(indices, source, clusterLabel, algorithmName, clusterID, clusterDescription, (int)index, (int)serialNumber, clusterColor, (DefaultMutableTreeNode)null, experiment);
    }

    public Cluster(int[] indices, String source, String clusterLabel, String algorithmName, String clusterID, String clusterDescription, int index, int serialNumber, Color clusterColor, DefaultMutableTreeNode node, Experiment experiment) {
        this.indices = indices;
        this.source = source;
        this.clusterLabel = clusterLabel;
        this.clusterID = clusterID;
        this.algorithmName = algorithmName;
        this.algorithmIndex = index;
        this.clusterColor = clusterColor;
        this.clusterDescription = clusterDescription;
        this.serialNumber = serialNumber;
        if (node != null) {
            this.node = node;
            this.userObject = node.getUserObject();
        }
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.isShowColor = true;
        this.experimentIndices = this.getIndicesMappedToExperiment();
    }

    public Color getClusterColor() {
        if (this.isShowColor) {
            return this.clusterColor;
        }
        return null;
    }

    public void enableShowColor(boolean show) {
        this.isShowColor = show;
    }

    public boolean showColor() {
        return this.isShowColor;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public int[] getExperimentIndices() {
        return this.experimentIndices;
    }

    public String getSource() {
        return this.source;
    }

    public String getClusterLabel() {
        return this.clusterLabel;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public String getClusterDescription() {
        return this.clusterDescription;
    }

    public int getAlgorithmIndex() {
        return this.algorithmIndex;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getSize() {
        return this.indices.length;
    }

    public DefaultMutableTreeNode getNode() {
        return this.node;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setClusterColor(Color color) {
        this.clusterColor = color;
    }

    public void setClusterLabel(String clusterLabel) {
        this.clusterLabel = clusterLabel;
    }

    public void setClusterDescription(String clusterDescription) {
        this.clusterDescription = clusterDescription;
    }

    public void setNode(DefaultMutableTreeNode myNode) {
        this.node = myNode;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
        this.exptID = experiment.getId();
        this.experimentIndices = this.getIndicesMappedToExperiment();
    }

    public int getExptID() {
        return this.exptID;
    }

    public boolean isMember(int index) {
        for (int i = 0; i < this.indices.length; ++i) {
            if (index != this.indices[i]) continue;
            return true;
        }
        return false;
    }

    public boolean removeMember(int memberIndex) {
        if (!this.isMember(memberIndex)) {
            return false;
        }
        int[] newIndices = new int[this.indices.length - 1];
        int cnt = 0;
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.indices[i] == memberIndex) continue;
            newIndices[cnt] = this.indices[i];
            ++cnt;
        }
        return true;
    }

    public HashSet getHashSet() {
        HashSet<Integer> set = new HashSet<Integer>(this.indices.length);
        for (int i = 0; i < this.indices.length; ++i) {
            set.add(new Integer(this.indices[i]));
        }
        return set;
    }

    public boolean doIndicesMatch(int[] indices) {
        if (indices.length != this.indices.length) {
            return false;
        }
        HashSet clusterSet = this.getHashSet();
        HashSet testSet = this.makeHashSet(indices);
        return clusterSet.containsAll(testSet);
    }

    private HashSet makeHashSet(int[] indices) {
        HashSet<Integer> set = new HashSet<Integer>(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            set.add(new Integer(indices[i]));
        }
        return set;
    }

    private int[] getIndicesMappedToExperiment() {
        int[] expIndices = new int[this.indices.length];
        int[] map = this.experiment.getRowMappingArrayCopy();
        boolean cnt = false;
        for (int i = 0; i < expIndices.length; ++i) {
            int currIndex = this.indices[i];
            for (int j = 0; j < map.length; ++j) {
                if (map[j] != currIndex) continue;
                expIndices[i] = j;
            }
        }
        return expIndices;
    }

    public static PersistenceDelegate getPersistenceDelegate() {
        return new ClusterPersistenceDelegate();
    }

    public static int[] getIndices(FloatMatrix fm) {
        int[] temp = new int[fm.m];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = (int)fm.A[i][0];
        }
        return temp;
    }

    private static class ClusterPersistenceDelegate
    extends PersistenceDelegate {
        private ClusterPersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object o, Encoder encoder) {
            Cluster oldInstance = (Cluster)o;
            float[] findices = new float[oldInstance.indices.length];
            for (int i = 0; i < oldInstance.indices.length; ++i) {
                findices[i] = oldInstance.indices[i];
            }
            FloatMatrix fm = new FloatMatrix(findices, findices.length);
            return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{fm, oldInstance.source, oldInstance.clusterLabel, oldInstance.algorithmName, oldInstance.clusterID, oldInstance.clusterDescription, new Integer(oldInstance.algorithmIndex), new Integer(oldInstance.serialNumber), oldInstance.clusterColor, oldInstance.node, oldInstance.experiment});
        }

        public void initialize(Class type, Object oldInstance, Object newInstance, Encoder encoder) {
        }
    }
}

