/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.util.StringSplitter;

public class GroupExperimentsPanel
extends JPanel {
    public static final int GROUP_A = 1;
    public static final int GROUP_B = 2;
    public static final int NEITHER_GROUP = 3;
    GroupExperimentsPanel gPanel = this;
    Vector exptNames;
    JLabel[] expLabels;
    JRadioButton[] groupARadioButtons;
    JRadioButton[] groupBRadioButtons;
    JRadioButton[] neitherGroupRadioButtons;

    public GroupExperimentsPanel(Vector exptNames) {
        this.exptNames = exptNames;
        this.setBorder(new TitledBorder(new EtchedBorder(1), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.setBackground(Color.white);
        JPanel panel1 = new JPanel();
        this.expLabels = new JLabel[exptNames.size()];
        this.groupARadioButtons = new JRadioButton[exptNames.size()];
        this.groupBRadioButtons = new JRadioButton[exptNames.size()];
        this.neitherGroupRadioButtons = new JRadioButton[exptNames.size()];
        ButtonGroup[] chooseGroup = new ButtonGroup[]{new ButtonGroup(), new ButtonGroup()};
        GridBagLayout gridbag = new GridBagLayout();
        GridBagLayout gridbag2 = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(gridbag2);
        panel1.setLayout(gridbag);
        for (int i = 0; i < exptNames.size(); ++i) {
            String s1 = (String)exptNames.get(i);
            this.expLabels[i] = new JLabel(s1);
            this.expLabels[i].setForeground(Color.black);
            this.groupARadioButtons[i] = new JRadioButton("Group A", false);
            this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
            this.buildConstraints(constraints, 0, i, 1, 1, 25, 100);
            gridbag.setConstraints(this.expLabels[i], constraints);
            panel1.add(this.expLabels[i]);
            this.buildConstraints(constraints, 1, i, 1, 1, 25, 100);
            gridbag.setConstraints(this.groupARadioButtons[i], constraints);
            panel1.add(this.groupARadioButtons[i]);
            this.buildConstraints(constraints, 2, i, 1, 1, 25, 100);
            gridbag.setConstraints(this.groupBRadioButtons[i], constraints);
            panel1.add(this.groupBRadioButtons[i]);
            chooseGroup[0].add(this.groupARadioButtons[i]);
            chooseGroup[1].add(this.groupBRadioButtons[i]);
        }
        if (exptNames.size() > 0) {
            this.groupARadioButtons[0].setSelected(true);
        }
        if (exptNames.size() > 1) {
            this.groupBRadioButtons[1].setSelected(true);
        }
        JScrollPane scroll = new JScrollPane(panel1);
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
        constraints.fill = 1;
        gridbag2.setConstraints(scroll, constraints);
        this.add(scroll);
        JPanel panel2 = new JPanel();
        panel2.setBackground(Color.white);
        GridBagLayout gridbag3 = new GridBagLayout();
        panel2.setLayout(gridbag3);
        JButton saveButton = new JButton(" Save grouping ");
        saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
        saveButton.setFocusPainted(false);
        saveButton.setPreferredSize(new Dimension(100, 30));
        JButton loadButton = new JButton(" Load grouping ");
        loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
        loadButton.setFocusPainted(false);
        loadButton.setPreferredSize(new Dimension(100, 30));
        JButton resetButton = new JButton(" Reset ");
        resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.gray, new Color(185, 185, 185), Color.darkGray, Color.darkGray));
        resetButton.setFocusPainted(false);
        resetButton.setPreferredSize(new Dimension(55, 30));
        final int finNum = exptNames.size();
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (int i = 0; i < finNum; ++i) {
                    GroupExperimentsPanel.this.groupARadioButtons[i].setSelected(true);
                }
            }
        });
        final JFileChooser fc = new JFileChooser(TMEV.getDataPath());
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int returnVal = fc.showSaveDialog(GroupExperimentsPanel.this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    try {
                        PrintWriter out = new PrintWriter(new FileOutputStream(file));
                        int[] groupAssgn = GroupExperimentsPanel.this.getGroupAssignments();
                        for (int i = 0; i < groupAssgn.length; ++i) {
                            out.print(groupAssgn[i]);
                            if (i >= groupAssgn.length - 1) continue;
                            out.print("\t");
                        }
                        out.println();
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        });
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                block10: {
                    int returnVal = fc.showOpenDialog(GroupExperimentsPanel.this);
                    if (returnVal == 0) {
                        try {
                            FileReader file = new FileReader(fc.getSelectedFile());
                            BufferedReader buff = new BufferedReader(file);
                            String line = buff.readLine();
                            StringSplitter st = new StringSplitter('\t');
                            st.init(line);
                            Vector<Integer> groupsVector = new Vector<Integer>();
                            while (st.hasMoreTokens()) {
                                String current = st.nextToken();
                                groupsVector.add(new Integer(current));
                            }
                            buff.close();
                            int[] groupAssgn = GroupExperimentsPanel.this.getGroupAssignments();
                            if (groupsVector.size() != groupAssgn.length) {
                                JOptionPane.showMessageDialog(GroupExperimentsPanel.this.gPanel, "Incompatible file!", "Error", 2);
                                break block10;
                            }
                            for (int i = 0; i < groupsVector.size(); ++i) {
                                int currentExpt = (Integer)groupsVector.get(i);
                                if (currentExpt == 1) {
                                    GroupExperimentsPanel.this.groupARadioButtons[i].setSelected(true);
                                    continue;
                                }
                                if (currentExpt == 2) {
                                    GroupExperimentsPanel.this.groupBRadioButtons[i].setSelected(true);
                                    continue;
                                }
                                if (currentExpt == 3) {
                                    GroupExperimentsPanel.this.neitherGroupRadioButtons[i].setSelected(true);
                                    continue;
                                }
                                for (int j = 0; j < finNum; ++j) {
                                    GroupExperimentsPanel.this.groupARadioButtons[j].setSelected(true);
                                }
                                JOptionPane.showMessageDialog(GroupExperimentsPanel.this.gPanel, "Incompatible file!", "Error", 2);
                                break;
                            }
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(GroupExperimentsPanel.this.gPanel, "Incompatible file!", "Error", 2);
                        }
                    }
                }
            }
        });
        constraints.anchor = 10;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.buildConstraints(constraints, 0, 0, 1, 1, 33, 100);
        gridbag3.setConstraints(saveButton, constraints);
        panel2.add(saveButton);
        this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
        gridbag3.setConstraints(loadButton, constraints);
        panel2.add(loadButton);
        this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
        gridbag3.setConstraints(resetButton, constraints);
        panel2.add(resetButton);
        this.buildConstraints(constraints, 0, 2, 1, 1, 0, 5);
        constraints.anchor = 10;
        gridbag2.setConstraints(panel2, constraints);
    }

    public void reset() {
        int finNum = this.exptNames.size();
        for (int i = 0; i < finNum; ++i) {
            this.groupARadioButtons[i].setSelected(true);
        }
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public int[] getGroupAssignments() {
        int[] groupAssignments = new int[]{-1, -1};
        for (int i = 0; i < this.exptNames.size(); ++i) {
            if (this.gPanel.groupARadioButtons[i].isSelected()) {
                groupAssignments[0] = i;
            }
            if (!this.gPanel.groupBRadioButtons[i].isSelected()) continue;
            groupAssignments[1] = i;
        }
        return groupAssignments;
    }
}

