/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil;

import edu.stanford.ejalbert.BrowserLauncher;
import java.io.IOException;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;

public class GenomeBrowserLauncher {
    private static final int ENSEMBLE = 1;
    private static final int UCSC = 2;
    private static final int NCBI = 3;

    public static void launchEnsembl(ICGHDataRegion dataRegion, int species) {
        String chromosome = GenomeBrowserLauncher.getChromosomeName(dataRegion.getChromosomeIndex() + 1, species);
        String sp = GenomeBrowserLauncher.getSpeciesName(1, species);
        int start = dataRegion.getStart();
        int stop = dataRegion.getStop();
        String url = "http://www.ensembl.org/" + sp + "/contigview?chr=" + chromosome + "&vc_start=" + start + "&vc_end" + stop + "&x=15&y=8";
        try {
            BrowserLauncher.openURL((String)url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void launchGoldenPath(ICGHDataRegion dataRegion, int species) {
        String chromosome = GenomeBrowserLauncher.getChromosomeName(dataRegion.getChromosomeIndex() + 1, species);
        String sp = GenomeBrowserLauncher.getSpeciesName(2, species);
        int start = dataRegion.getStart();
        int stop = dataRegion.getStop();
        String url = "http://genome.ucsc.edu/cgi-bin/hgTracks?db=" + sp + "&position=chr" + chromosome + ":" + start + "-" + stop;
        try {
            BrowserLauncher.openURL((String)url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void launchNCBIMapViewer(ICGHDataRegion dataRegion, int species) {
        String chromosome = GenomeBrowserLauncher.getChromosomeName(dataRegion.getChromosomeIndex() + 1, species);
        String sp = GenomeBrowserLauncher.getSpeciesName(3, species);
        int start = dataRegion.getStart();
        int stop = dataRegion.getStop();
        String url = "http://www.ncbi.nlm.nih.gov/mapview/maps.cgi?org=" + sp + "&chr=" + chromosome + "&BEG=" + start + "&END=" + stop;
        try {
            BrowserLauncher.openURL((String)url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void launchNCBIMapViewer(ICGHDataRegion[] dataRegions, int species) {
        String chromosome = GenomeBrowserLauncher.getChromosomeName(dataRegions[0].getChromosomeIndex() + 1, species);
        String sp = GenomeBrowserLauncher.getSpeciesName(3, species);
        int start = dataRegions[0].getStart();
        int stop = dataRegions[dataRegions.length - 1].getStop();
        String url = "http://www.ncbi.nlm.nih.gov/mapview/maps.cgi?org=" + sp + "&chr=" + chromosome + "&BEG=" + start + "&END=" + stop;
        try {
            BrowserLauncher.openURL((String)url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static String getChromosomeName(int chr, int species) {
        String chromosome = chr + "";
        if ("20".equals(chromosome) && species == 1) {
            chromosome = "X";
        } else if ("21".equals(chromosome) && species == 1) {
            chromosome = "Y";
        } else if ("23".equals(chromosome) && species == 0) {
            chromosome = "X";
        } else if ("24".equals(chromosome) && species == 0) {
            chromosome = "Y";
        }
        return chromosome;
    }

    private static String getSpeciesName(int browserSource, int sp) {
        String species = "";
        block0 : switch (sp) {
            case 0: {
                switch (browserSource) {
                    case 1: {
                        species = "Homo_sapiens";
                        break;
                    }
                    case 2: {
                        species = "hg17";
                        break;
                    }
                    case 3: {
                        species = "human";
                    }
                }
                break;
            }
            case 1: {
                switch (browserSource) {
                    case 1: {
                        species = "Mus_musculus";
                        break block0;
                    }
                    case 2: {
                        species = "mm6";
                        break block0;
                    }
                    case 3: {
                        species = "mouse";
                    }
                }
            }
        }
        return species;
    }
}

