/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDialogs;

import com.borland.jbcl.layout.VerticalFlowLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.ChARM;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.PValue;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer.GraphViewPanel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDialogs.ExampleFileFilter;

public class ExportResultsDialog
extends JDialog {
    public static final int EXPORT_IMAGE = 0;
    public static final int EXPORT_FLAT_FILE = 1;
    public static final int CANCELLED = -1;
    public static final int OK_VERIFIED = 1;
    JPanel contentPane = new JPanel();
    JRadioButton jRadioButton1 = new JRadioButton();
    JRadioButton jRadioButton2 = new JRadioButton();
    JButton jButton1 = new JButton();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    private String filename;
    private int exportType;
    private int exitStatus;
    private Component parent;
    private ChARM displayStateManager;
    JButton jButton3 = new JButton();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JTextField jTextField1 = new JTextField();
    JTextField jTextField2 = new JTextField();
    JButton jButton4 = new JButton();
    JLabel jLabel1 = new JLabel();
    JComboBox jComboBox1 = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    TitledBorder titledBorder1;
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    TitledBorder titledBorder2;
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    VerticalFlowLayout verticalFlowLayout2 = new VerticalFlowLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    FlowLayout flowLayout3 = new FlowLayout();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    FlowLayout flowLayout5 = new FlowLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public ExportResultsDialog(Component parent, ChARM dispState) throws HeadlessException {
        this.parent = parent;
        this.displayStateManager = dispState;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "Output options");
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), "P-value cutoffs");
        this.setSize(new Dimension(343, 404));
        this.setTitle("Export Results");
        this.setModal(false);
        this.setResizable(false);
        this.contentPane.setPreferredSize(new Dimension(100, 200));
        this.jRadioButton1.setText("Export current display to image");
        this.jRadioButton1.setActionCommand("IMAGE");
        this.jRadioButton2.setText("Export results to text file");
        this.jRadioButton2.setActionCommand("FLATFILE");
        this.jTextField1.setMinimumSize(new Dimension(80, 21));
        this.jTextField1.setPreferredSize(new Dimension(50, 21));
        this.jTextField2.setPreferredSize(new Dimension(50, 21));
        this.verticalFlowLayout2.setAlignment(1);
        this.jPanel3.setLayout(this.flowLayout1);
        this.jPanel4.setLayout(this.flowLayout2);
        this.jPanel5.setLayout(this.flowLayout3);
        this.flowLayout2.setAlignment(0);
        this.flowLayout3.setAlignment(0);
        this.flowLayout1.setAlignment(0);
        this.jButton4.setMaximumSize(new Dimension(150, 25));
        this.jButton4.setMinimumSize(new Dimension(115, 25));
        this.jButton4.setPreferredSize(new Dimension(130, 20));
        this.jPanel6.setLayout(this.flowLayout5);
        this.buttonGroup1.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
        this.buttonGroup1.setSelected(this.jRadioButton1.getModel(), true);
        this.jPanel1.setLayout((LayoutManager)this.verticalFlowLayout1);
        this.jPanel1.setBorder(this.titledBorder1);
        this.jPanel2.setBorder(this.titledBorder2);
        this.jPanel2.setLayout((LayoutManager)this.verticalFlowLayout2);
        this.jLabel1.setText("Filter type:");
        this.jLabel2.setText("Sign p-value cutoff:");
        this.jLabel3.setText("Mean  p-value cutoff:");
        PValue currPvalCutoff = this.displayStateManager.getPvalueCutoff();
        this.jTextField1.setText(currPvalCutoff.getSignPvalue() + "");
        this.jTextField2.setText(currPvalCutoff.getMeanPvalue() + "");
        String[] cutoff_types = new String[]{"Sign AND Mean Tests", "Sign OR Mean Tests", "Sign Test", "Mean Test"};
        this.jComboBox1 = new JComboBox<String>(cutoff_types);
        this.jComboBox1.setSelectedIndex(this.displayStateManager.getPValueTestType());
        this.jComboBox1.setToolTipText("Select the p-value cutoffs that exported predictions must meet");
        this.jComboBox1.addActionListener(new CutoffSelectionListener());
        this.jButton4.setText("Update display");
        this.jButton4.addActionListener(new CutoffListener());
        this.jButton1.setText("Next >");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String choice = ExportResultsDialog.this.buttonGroup1.getSelection().getActionCommand();
                if (choice.equals("IMAGE")) {
                    ExportResultsDialog.this.exportType = 0;
                } else if (choice.equals("FLATFILE")) {
                    ExportResultsDialog.this.exportType = 1;
                }
                if (ExportResultsDialog.this.getExportType() == 0) {
                    JFileChooser fileDialog = new JFileChooser(TMEV.getDataPath());
                    String[] imageWriters = ImageIO.getWriterFormatNames();
                    HashMap<String, String> typeHash = new HashMap<String, String>();
                    for (int i = 0; i < imageWriters.length; ++i) {
                        if (typeHash.containsKey(imageWriters[i].toUpperCase())) continue;
                        ExampleFileFilter filter = new ExampleFileFilter();
                        filter.addExtension(imageWriters[i].toUpperCase());
                        filter.setDescription(imageWriters[i].toUpperCase());
                        fileDialog.addChoosableFileFilter(filter);
                        typeHash.put(imageWriters[i].toUpperCase(), new String("1"));
                    }
                    int returnVal = fileDialog.showSaveDialog(ExportResultsDialog.this);
                    if (returnVal == 0) {
                        String file = fileDialog.getSelectedFile().getAbsolutePath();
                        ExportResultsDialog.this.filename = file;
                        String currExt = fileDialog.getFileFilter().getDescription();
                        currExt = currExt.substring(0, currExt.indexOf(32));
                        int printStatus = ExportResultsDialog.this.displayStateManager.getGraphPanel().printToFile(ExportResultsDialog.this.filename + "." + currExt, currExt);
                        if (printStatus < 0) {
                            JOptionPane.showMessageDialog(null, "Error writing to file!  Please try again.", "File Output Error", 0);
                        }
                        ExportResultsDialog.this.exitStatus = 1;
                    }
                    ExportResultsDialog.this.closeDialog();
                } else {
                    JFileChooser fileDialog = new JFileChooser(TMEV.getDataPath());
                    int returnVal = fileDialog.showSaveDialog(ExportResultsDialog.this);
                    if (returnVal == 0) {
                        String file = fileDialog.getSelectedFile().getAbsolutePath();
                        ExportResultsDialog.this.filename = file;
                        int printStatus = ExportResultsDialog.this.displayStateManager.printVisiblePredictionWindows(ExportResultsDialog.this.filename + ".txt");
                        if (printStatus < 0) {
                            JOptionPane.showMessageDialog(null, "Error writing to file!  Please try again.", "File Output Error", 0);
                        }
                        ExportResultsDialog.this.exitStatus = 1;
                    }
                    ExportResultsDialog.this.closeDialog();
                }
            }
        });
        this.jButton3.setText("Cancel");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportResultsDialog.this.exitStatus = -1;
                ExportResultsDialog.this.closeDialog();
            }
        });
        this.contentPane.setLayout(this.gridBagLayout1);
        this.jPanel1.add((Component)this.jRadioButton1, null);
        this.jPanel1.add((Component)this.jRadioButton2, null);
        this.contentPane.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 32, 0, 34), 0, 11));
        this.contentPane.add((Component)this.jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(23, 32, 11, 33), 0, 12));
        this.contentPane.add((Component)this.jPanel7, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 66, 8, 67), 0, 0));
        this.jPanel3.add((Component)this.jLabel1, null);
        this.jPanel3.add((Component)this.jComboBox1, null);
        this.jPanel2.add((Component)this.jPanel3, null);
        this.jPanel2.add((Component)this.jPanel4, null);
        this.jPanel2.add((Component)this.jPanel5, null);
        this.jPanel4.add((Component)this.jLabel2, null);
        this.jPanel4.add((Component)this.jTextField1, null);
        this.jPanel2.add((Component)this.jPanel6, null);
        this.jPanel6.add((Component)this.jButton4, null);
        this.jPanel5.add((Component)this.jLabel3, null);
        this.jPanel5.add((Component)this.jTextField2, null);
        this.jPanel7.add((Component)this.jButton1, null);
        this.jPanel7.add((Component)this.jButton3, null);
        this.getContentPane().add((Component)this.contentPane, "Center");
    }

    public String getFilename() {
        return this.filename;
    }

    private boolean verifyValidReturnState() {
        boolean valid = true;
        if (this.filename == null || this.filename.length() == 0) {
            valid = false;
        }
        return valid;
    }

    private void closeDialog() {
        this.hide();
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public int getExportType() {
        return this.exportType;
    }

    private class CutoffListener
    implements ActionListener {
        private CutoffListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Double signCutoff = Double.valueOf(ExportResultsDialog.this.jTextField1.getText());
                Double meanCutoff = Double.valueOf(ExportResultsDialog.this.jTextField2.getText());
                PValue filterPval = new PValue(meanCutoff, signCutoff);
                ExportResultsDialog.this.jComboBox1.validate();
                int index = ExportResultsDialog.this.jComboBox1.getSelectedIndex();
                int testType = 0;
                switch (index) {
                    case 0: {
                        testType = 0;
                        break;
                    }
                    case 1: {
                        testType = 1;
                        break;
                    }
                    case 2: {
                        testType = 2;
                        break;
                    }
                    case 3: {
                        testType = 3;
                    }
                }
                ExportResultsDialog.this.displayStateManager.setPValueCutoff(filterPval);
                ExportResultsDialog.this.displayStateManager.setPValueTestType(testType);
                GraphViewPanel graphPanel = ExportResultsDialog.this.displayStateManager.getGraphPanel();
                graphPanel.initializePredictionNodes(ExportResultsDialog.this.displayStateManager.getSelectedExperiments());
                graphPanel.updateGraph();
            }
            catch (NumberFormatException exc) {
                JOptionPane.showMessageDialog(ExportResultsDialog.this, "Please enter P-values between 0 and 1.", "Error", 0);
            }
        }
    }

    private class CutoffSelectionListener
    implements ActionListener {
        private CutoffSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = ExportResultsDialog.this.jComboBox1.getSelectedIndex();
            if (index == 2) {
                ExportResultsDialog.this.jTextField1.setEnabled(true);
                ExportResultsDialog.this.jTextField2.setEnabled(false);
            } else if (index == 3) {
                ExportResultsDialog.this.jTextField2.setEnabled(true);
                ExportResultsDialog.this.jTextField1.setEnabled(false);
            } else {
                ExportResultsDialog.this.jTextField1.setEnabled(true);
                ExportResultsDialog.this.jTextField2.setEnabled(true);
            }
        }
    }
}

