/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.SegmentInfo;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cluster.gui.IData;

public class StatComponent
extends JLabel {
    public static final Color BACKGROUND = Color.LIGHT_GRAY;
    public static final int WIDTH = 30;
    public static final int HEIGHT = 50;
    public static final int LINE_HEIGHT = 25;
    SegmentInfo[] segInfos;
    CGHClone[] genes;
    int chromosome;
    String instructions;
    String experiment;
    boolean windowset;
    boolean geneset;
    IData data;

    public StatComponent(IData data) {
        this.setPreferredSize(new Dimension(30, 50));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        this.setBackground(BACKGROUND);
        this.geneset = false;
        this.windowset = false;
        this.data = data;
    }

    public void setWindows(SegmentInfo[] segs, int chromo, String exp) {
        this.segInfos = segs;
        this.experiment = exp;
        this.chromosome = chromo;
        this.geneset = false;
        this.windowset = true;
        this.setPreferredSize(new Dimension(this.getWidth(), Math.max(25 * this.segInfos.length * 11, 50)));
        this.revalidate();
        this.repaint();
    }

    public void clearDisplay() {
        this.segInfos = null;
        this.genes = null;
        System.gc();
        this.geneset = false;
        this.windowset = false;
        this.setPreferredSize(new Dimension(30, 50));
        this.revalidate();
        this.repaint();
    }

    public void setGenes(CGHClone[] input_genes, String exp) {
        this.genes = input_genes;
        this.geneset = true;
        this.windowset = false;
        this.experiment = exp;
        this.setPreferredSize(new Dimension(this.getWidth(), Math.max(25 * this.genes.length * 6, 50)));
        this.revalidate();
        this.repaint();
    }

    public boolean containsWindows() {
        return this.segInfos != null;
    }

    public void writeWindowToFile(String file) {
        if (this.segInfos != null) {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(file, true));
                out.newLine();
                out.newLine();
                out.write("Experiment\tChromosome\tFirst gene start bp\tLast gene end bp\tStart Gene ID\tEnd Gene ID\tSign positive p-value\tSign negative p-value\tMean p-value");
                out.newLine();
                for (int i = 0; i < this.segInfos.length; ++i) {
                    out.write(this.experiment + "\t" + this.chromosome + "\t" + this.data.getCloneAt(this.segInfos[i].getStart(), this.chromosome) + "\t" + this.data.getCloneAt(this.segInfos[i].getEnd(), this.chromosome) + "\t" + this.segInfos[i].getStatistic("Sign pos") + "\t" + this.segInfos[i].getStatistic("Sign neg") + "\t" + this.segInfos[i].getStatistic("Mean"));
                    out.newLine();
                }
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (!this.windowset && this.geneset) {
            this.paintGeneInfo(g, width, height);
        }
    }

    public void paintGeneInfo(Graphics g, int width, int height) {
        g.setFont(new Font("myfont", 0, 12));
        for (int i = 0; i < this.genes.length; ++i) {
            g.setColor(Color.BLACK);
            if (i % 2 == 0) {
                g.setColor(Color.BLUE);
            }
            int curr_line = 25 * i * 5 + 25 + 10;
            g.drawString("Gene: " + this.genes[i].getName(), 5, curr_line);
            g.drawString("Chromosome: " + this.genes[i].getChromosome(), 5, curr_line + 25);
            g.drawString("Value: " + this.genes[i].getRatio(), 5, curr_line + 50);
        }
    }

    public void paintOpeningDisp(Graphics g, int width, int height) {
        g.drawString("Select a prediction bar to view test results", 5, height / 10);
    }

    public void paintWindowStats(Graphics g, int width, int height) {
        g.setFont(new Font("myfont", 0, 12));
        for (int i = 0; i < this.segInfos.length; ++i) {
            int offset = i * 10 * 25;
            SegmentInfo segInfo = this.segInfos[i];
            CGHClone startgene = this.data.getCloneAt(this.segInfos[i].getStart(), this.chromosome);
            CGHClone endgene = this.data.getCloneAt(this.segInfos[i].getEnd(), this.chromosome);
            if (startgene == null || endgene == null) continue;
            g.setColor(Color.BLUE);
            g.drawString("Prediction Statistics", width / 4, 25 + offset);
            int indentSize = 15;
            g.drawString("Start/End gene IDs: [" + startgene.getName() + " , " + endgene.getName() + "]", 5, 50 + offset);
            g.drawString("Significance test results:", 5, 75 + offset);
            g.drawString("Mean p-value = " + segInfo.getStatistic("Mean"), 5 + indentSize, 100 + offset);
            g.drawString("Sign test p-values: ", 5 + indentSize, 125 + offset - 5);
            g.drawString("Negative = " + segInfo.getStatistic("Sign neg") + "     ", 15 + indentSize, 150 + offset - 2);
            g.drawString("Positive = " + segInfo.getStatistic("Sign pos") + "     ", 15 + indentSize, 175 + offset);
        }
    }
}

