/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;

public class PredictionGraphNode
extends PNode {
    private static final Color SELECTED_DOWN_COLOR = Color.YELLOW;
    private static final Color SELECTED_UP_COLOR = Color.MAGENTA;
    private static final Color DOWN_COLOR = Color.GREEN;
    private static final Color UP_COLOR = Color.RED;
    private static final int PREDICTION_RECT_HEIGHT = 10;
    private boolean isSelected = false;
    private boolean isChanged = false;
    private double startx;
    private double endx;
    private double sign;
    private int type;
    private PPath predRect;
    private double lastDx;
    private double lastDy;

    public PredictionGraphNode(double startx, double endx, double sign, int type) {
        this.startx = startx;
        this.endx = endx;
        this.sign = sign;
        this.type = type;
        this.lastDx = 0.0;
        this.lastDy = 0.0;
        this.predRect = new PPath();
        this.addChild((PNode)this.predRect);
        this.isChanged = true;
        this.render();
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean change) {
        this.isChanged = change;
    }

    public void render() {
        Color geneColor = null;
        if (this.isChanged) {
            this.removeChild((PNode)this.predRect);
            this.predRect = new PPath();
            if (this.type == 1) {
                this.predRect.setPathTo((Shape)new RoundRectangle2D.Double(this.startx, 0.0, this.endx - this.startx, 10.0, 10.0, 10.0));
            } else if (this.type == 0) {
                this.predRect.setPathTo((Shape)new RoundRectangle2D.Double(this.startx, 0.0, this.endx - this.startx, 10.0, 0.0, 0.0));
            }
            geneColor = this.isSelected() ? (this.sign < 0.0 ? SELECTED_DOWN_COLOR : SELECTED_UP_COLOR) : (this.sign < 0.0 ? DOWN_COLOR : UP_COLOR);
            this.predRect.setPaint((Paint)geneColor);
            this.addChild((PNode)this.predRect);
            this.isChanged = false;
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean select) {
        this.isSelected = select;
    }

    public void setStartX(double val) {
        this.startx = val;
    }

    public void setEndX(double val) {
        this.endx = val;
    }

    public double getStartX() {
        return this.startx;
    }

    public double getEndX() {
        return this.endx;
    }

    public void translate(double dx, double dy) {
        super.translate(dx, dy);
        this.lastDx = dx;
        this.lastDy = dy;
    }

    public void reverseLastTranslation() {
        this.translate(-this.lastDx, -this.lastDy);
    }
}

