/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PLine;
import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.Expression;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.ChARM;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.ChromDataGraphNode;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.ChromPredictionsGraphNode;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.IChromGraphNode;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.ResultContainer;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.SegmentInfo;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer.GeneGraphNode;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHViewer;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class GraphViewPanel
extends PCanvas
implements ICGHViewer {
    public static final int HEIGHT = 3200;
    public static final int WIDTH = 1200;
    public static int END_SPACE = 100;
    public static float TEXT_HEIGHT = 0.0f;
    public static float MAX_GENE_VALUE = 1.25f;
    public static float AXIS_SCALE = 1.0f;
    public static final int EXP_HEIGHT = 150;
    public static final int EXP_WIDTH = 1000;
    public static final int CHROM_SPACING = 20;
    public static final int EXP_PRED_SPACING = 10;
    public static final int PREDICTION_COMP_HEIGHT = 30;
    public static final int PREDICTION_HEIGHT = 10;
    public static final int TEXT_SIZE = 20;
    public static final int VISIBLE_HEIGHT = 1500;
    public static Color TEXT_COLOR = Color.WHITE;
    public static Color BACKGROUND_COLOR = Color.BLACK;
    public static Color SELECTIONRECT_COLOR = Color.YELLOW;
    public static Color ZOOMRECT_COLOR = Color.WHITE;
    private ChARM displayStateManager;
    private HashMap chromNodeHash;
    private ArrayList textNodes;
    private ArrayList textNodeEnds;
    private Color currBackgroundColor = Color.BLACK;
    private PScrollPane parentScrollPane;
    private MouseSelectionEventHandler mouseSelectionEventHandler;
    private MouseZoomEventHandler mouseZoomEventHandler;
    private PBounds initialBounds = null;
    private float initialScale = 0.0f;
    private IChromGraphNode currChromGraphSelection = null;
    private ArrayList currSelectedIndices = null;
    private final PText tooltipNode = new PText();
    private ArrayList currCircledGenes = new ArrayList();
    private ChromDataGraphNode currCircledChromNode;
    IFramework framework;
    IData data;
    public static final int GRAPH_WIDTH = 800;
    public static final int GRAPH_HEIGHT = 3200;
    public static final int LEFT_COMP_HEIGHT = 350;
    public static final int BUTTON_HEIGHT = 50;
    public static final Color GRAPH_BACKGROUND = Color.BLACK;
    public static final Color STAT_BACKGROUND = Color.WHITE;

    public GraphViewPanel(IFramework framework) {
        this.framework = framework;
        this.data = framework.getData();
        this.chromNodeHash = new HashMap();
        this.textNodes = new ArrayList();
        this.textNodeEnds = new ArrayList();
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setPreferredSize(new Dimension(800, 3200));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBackground(GRAPH_BACKGROUND);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.parentScrollPane = new PScrollPane((Component)((Object)this));
        this.setParent(this.parentScrollPane);
        this.parentScrollPane.setKeyActionsDisabled(true);
        this.tooltipNode.setPickable(false);
        this.getCamera().addChild((PNode)this.tooltipNode);
        this.removeInputEventListener((PInputEventListener)this.getZoomEventHandler());
        this.removeInputEventListener((PInputEventListener)this.getPanEventHandler());
        this.mouseSelectionEventHandler = new MouseSelectionEventHandler();
        this.addInputEventListener((PInputEventListener)this.mouseSelectionEventHandler);
        this.mouseZoomEventHandler = new MouseZoomEventHandler();
        this.addInputEventListener((PInputEventListener)this.mouseZoomEventHandler);
        this.initializeGraph();
    }

    public GraphViewPanel(ChARM disp, PScrollPane parentPane) {
        System.out.println("In GraphViewPanel Constructor");
        this.displayStateManager = disp;
        this.data = disp.getData();
        if (this.data == null) {
            System.out.println("In Const. GraphViewPanel()- data is null");
        }
        this.parentScrollPane = parentPane;
        this.chromNodeHash = new HashMap();
        this.textNodes = new ArrayList();
        this.textNodeEnds = new ArrayList();
        this.tooltipNode.setPickable(false);
        this.getCamera().addChild((PNode)this.tooltipNode);
        this.removeInputEventListener((PInputEventListener)this.getZoomEventHandler());
        this.removeInputEventListener((PInputEventListener)this.getPanEventHandler());
        this.mouseSelectionEventHandler = new MouseSelectionEventHandler();
        this.addInputEventListener((PInputEventListener)this.mouseSelectionEventHandler);
        this.mouseZoomEventHandler = new MouseZoomEventHandler();
        this.addInputEventListener((PInputEventListener)this.mouseZoomEventHandler);
    }

    public void setParent(PScrollPane scrollpane) {
        this.parentScrollPane = scrollpane;
    }

    public void initializeGraph() {
        this.chromNodeHash.clear();
        if (this.data == null) {
            System.out.println("In GraphViewPanel initializeGraph() this.data is null");
            return;
        }
        ArrayList expList = this.displayStateManager.getSelectedExperiments();
        int numOfChr = this.data.getNumChromosomes();
        System.out.println("numOfChr " + numOfChr);
        for (int i = 0; i < numOfChr; ++i) {
            int chrNumber = i + 1;
            for (int j = 0; j < expList.size(); ++j) {
                this.createChromDataGraphNode(chrNumber, (String)expList.get(j));
            }
        }
    }

    public void updatePredictionNode(int chromNumber, String exp) {
        ResultContainer selectedResults = this.displayStateManager.getSelectedResultSets();
        this.createPredictionGraphNode(selectedResults.toString(), chromNumber, exp);
    }

    public void initializePredictionNodes(ArrayList exps) {
        ResultContainer selectedResults = this.displayStateManager.getSelectedResultSets();
        for (int i = 0; i < exps.size(); ++i) {
            for (int j = 0; j < this.data.getNumChromosomes(); ++j) {
                this.createPredictionGraphNode(selectedResults.toString(), j + 1, (String)exps.get(i));
            }
        }
    }

    public void updateAxisScale(float newScale) {
        AXIS_SCALE = newScale;
        ArrayList chromGraphNodes = new ArrayList(this.chromNodeHash.values());
        IChromGraphNode currNode = null;
        ChromDataGraphNode dataNode = null;
        for (int i = 0; i < chromGraphNodes.size(); ++i) {
            currNode = (IChromGraphNode)chromGraphNodes.get(i);
            if (!(currNode instanceof ChromDataGraphNode)) continue;
            dataNode = (ChromDataGraphNode)currNode;
            dataNode.setAxisScale(newScale);
        }
        this.refreshDataGraphs();
    }

    public double getAxisScale() {
        return AXIS_SCALE;
    }

    public void setBackgroundColor(Color newColor) {
        this.setBackground(newColor);
        this.currBackgroundColor = newColor;
        if (newColor.equals(Color.BLACK)) {
            TEXT_COLOR = Color.WHITE;
            BACKGROUND_COLOR = newColor;
            SELECTIONRECT_COLOR = Color.YELLOW;
            ZOOMRECT_COLOR = Color.WHITE;
        } else if (newColor.equals(Color.WHITE)) {
            TEXT_COLOR = Color.BLACK;
            BACKGROUND_COLOR = newColor;
            SELECTIONRECT_COLOR = Color.MAGENTA;
            ZOOMRECT_COLOR = Color.BLACK;
        }
        this.updateGraph();
    }

    public Color getBackgroundColor() {
        return this.currBackgroundColor;
    }

    public void refreshDataGraphs() {
        ArrayList selectedExps = this.displayStateManager.getSelectedExperiments();
        for (int j = 0; j < this.data.getNumChromosomes(); ++j) {
            int chromosome = j + 1;
            double maxWidth = this.getMaxGeneSize(chromosome);
            double currWidth = ((MultipleArrayData)this.data).getChromWidth(chromosome);
            for (int i = 0; i < selectedExps.size(); ++i) {
                String currExp = (String)selectedExps.get(i);
                if (!this.chromNodeHash.containsKey(chromosome + "," + selectedExps.get(i))) {
                    this.createChromDataGraphNode(chromosome, (String)selectedExps.get(i));
                }
                ChromDataGraphNode currNode = (ChromDataGraphNode)this.chromNodeHash.get(chromosome + "," + selectedExps.get(i));
                currNode.render();
            }
        }
    }

    public void updateGraph() {
        ArrayList selectedExps = this.displayStateManager.getSelectedExperiments();
        this.getLayer().removeAllChildren();
        this.textNodes.clear();
        if (selectedExps.size() != 0) {
            double yOffset = 0.0;
            if (this.data == null) {
                System.out.println("data is null in GraphViewPanel updateGraph()");
            }
            for (int j = 0; j < this.data.getNumChromosomes(); ++j) {
                int chromosome = j + 1;
                double maxWidth = this.getMaxGeneSize(chromosome);
                double currWidth = ((MultipleArrayData)this.data).getChromWidth(chromosome);
                double xOffset = 1000.0 * (1.0 - currWidth / maxWidth) / 2.0 + (double)END_SPACE;
                this.getLayer().addChild((PNode)this.getTextObjectAt(chromosome + "", xOffset - 50.0, yOffset + (double)(150 / 2), false, 20));
                for (int i = 0; i < selectedExps.size(); ++i) {
                    ChromPredictionsGraphNode currPredNode;
                    ChromDataGraphNode currChrNode;
                    String currExp = (String)selectedExps.get(i);
                    if (this.chromNodeHash == null) {
                        System.out.println("In GraphViewPanel updateGraph(). chromNodeHash is NULL");
                    }
                    if (!this.chromNodeHash.containsKey(chromosome + "," + selectedExps.get(i))) {
                        this.createChromDataGraphNode(chromosome, (String)selectedExps.get(i));
                    }
                    if ((currChrNode = (ChromDataGraphNode)this.chromNodeHash.get(chromosome + "," + selectedExps.get(i))) == null) {
                        System.out.println("In GraphViewPanel updateGraph(). currChrNode is NULL");
                    }
                    currChrNode.render();
                    currChrNode.reverseLastTranslation();
                    currChrNode.translate(xOffset, yOffset + (double)(150 / 2) + (double)TEXT_HEIGHT);
                    this.getLayer().addChild((PNode)currChrNode);
                    yOffset += 150.0;
                    if (!this.displayStateManager.getStateVariable("Prediction Plot Toggle").equals("on")) continue;
                    yOffset += 10.0;
                    ResultContainer selectedResults = this.displayStateManager.getSelectedResultSets();
                    if (selectedResults == null) {
                        System.out.println("In GraphViewPanel updateGraph(). selectedResults is NULL");
                    }
                    if (!this.chromNodeHash.containsKey(selectedResults.toString() + "," + chromosome + "," + selectedExps.get(i) + "pred")) {
                        this.createPredictionGraphNode(selectedResults.toString(), chromosome, (String)selectedExps.get(i));
                    }
                    if ((currPredNode = (ChromPredictionsGraphNode)this.chromNodeHash.get(selectedResults.toString() + "," + chromosome + "," + selectedExps.get(i) + "pred")) == null) {
                        System.out.println("In GraphViewPanel updateGraph(). currPredNode is NULL");
                    }
                    currPredNode.reverseLastTranslation();
                    currPredNode.translate(xOffset, yOffset);
                    this.getLayer().addChild((PNode)currPredNode);
                    yOffset += 30.0;
                }
                yOffset += 20.0;
            }
        }
        this.mouseSelectionEventHandler.clearCurrentSelection();
        System.gc();
    }

    public int printToFile(String filename, String imageType) {
        int returnStatus = 0;
        BufferedImage graphimage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
        Graphics g = graphimage.getGraphics();
        this.paintAll(g);
        try {
            ImageIO.write((RenderedImage)graphimage, imageType, new File(filename));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            returnStatus = -1;
        }
        return returnStatus;
    }

    private void createChromDataGraphNode(int chrom, String currExp) {
        ChromDataGraphNode chromNode = new ChromDataGraphNode(chrom, currExp);
        int chromosome = chrom;
        float maxWidth = this.getMaxGeneSize(chromosome);
        float currWidth = ((MultipleArrayData)this.data).getChromWidth(chromosome);
        chromNode.setChromWidth(1000.0f * (currWidth / maxWidth));
        float genescale = (float)(150 / 2) / MAX_GENE_VALUE;
        float[] ratios = this.getRatioArray(currExp, chrom, true);
        ArrayList geneNames = this.getGeneNamesBetweenIndices(currExp, chrom, true);
        chromNode.addGeneNodes(ratios, genescale, AXIS_SCALE, geneNames);
        chromNode.addClientProperty("tooltip", currExp + ", Chrom. " + chrom);
        this.chromNodeHash.put(chromosome + "," + currExp, chromNode);
    }

    private void deleteDataGraphNode(int chrom, String exp) {
        if (this.chromNodeHash.containsKey(chrom + "," + exp)) {
            this.chromNodeHash.remove(chrom + "," + exp);
        }
    }

    private void deletePredictionGraphNode(int chrom, String exp) {
        if (this.chromNodeHash.containsKey(chrom + "," + exp)) {
            this.chromNodeHash.remove(chrom + "," + exp + "pred");
        }
    }

    private void createPredictionGraphNode(String resultSet, int chrom, String currExp) {
        ChromPredictionsGraphNode chromNode = new ChromPredictionsGraphNode(chrom, currExp, resultSet);
        int chromosome = chrom;
        double maxWidth = this.getMaxGeneSize(chromosome);
        double currWidth = ((MultipleArrayData)this.data).getChromWidth(chromosome);
        chromNode.setChromWidth(1000.0 * (currWidth / maxWidth));
        float[] data = this.getRatioArray(currExp, chrom, true);
        ArrayList indOrig = this.getOrigIndArray(currExp, chrom - 1);
        ArrayList segments = this.displayStateManager.getPredictionSegments(currExp, chrom);
        for (int i = 0; i < segments.size(); ++i) {
            SegmentInfo currSeg = (SegmentInfo)segments.get(i);
            int startIndex = this.lookupGeneIndex(indOrig, currSeg.getStart());
            int endIndex = this.lookupGeneIndex(indOrig, currSeg.getEnd());
            double startx = (double)startIndex / (double)data.length * (1000.0 * (currWidth / maxWidth));
            double endx = (double)endIndex / (double)data.length * (1000.0 * (currWidth / maxWidth));
            chromNode.addPrediction(currSeg, startx, endx);
        }
        chromNode.setType(2);
        this.chromNodeHash.put(resultSet + "," + chrom + "," + currExp + "pred", chromNode);
    }

    private void paintGeneRatios(int chrom, int exp, double x, double y, PNode parent) {
        ArrayList selectedExps = this.displayStateManager.getSelectedExperiments();
        String currExp = (String)selectedExps.get(exp);
        int chromosome = chrom;
        PLine axisLine = new PLine();
        axisLine.setStrokePaint((Paint)Color.BLACK);
        axisLine.addPoint(0, x, y);
        axisLine.addPoint(1, (double)(END_SPACE + 1000) - x, y);
        parent.addChild((PNode)axisLine);
        float genescale = (float)(150 / 2) / Math.min(this.getMaxGeneValue(currExp, chrom), MAX_GENE_VALUE);
        float[] ratios = this.getRatioArray(currExp, chrom, true);
        PLine geneLine = null;
        for (int i = 0; i < ratios.length; ++i) {
            double currx = (double)i / (double)ratios.length * (1000.0 - 2.0 * x) + x;
            if (Double.isNaN(ratios[i])) continue;
            Color upcolor = Color.RED;
            Color downcolor = Color.GREEN.darker();
            Color currColor = null;
            currColor = ratios[i] > 0.0f ? upcolor : downcolor;
            geneLine = new PLine();
            geneLine.setStrokePaint((Paint)currColor);
            geneLine.addPoint(0, currx, y);
            geneLine.addPoint(1, currx, y + (double)(ratios[i] * genescale));
            parent.addChild((PNode)geneLine);
        }
    }

    public void resetZoom() {
        Rectangle2D bounds = this.getLayer().getGlobalFullBounds().getBounds2D();
        Rectangle2D.Double newRect = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), Math.min(bounds.getHeight() / 2.0, 1500.0));
        if (((RectangularShape)newRect).getWidth() > 0.0) {
            this.getCamera().animateViewToCenterBounds((Rectangle2D)newRect, true, 1L);
        }
        this.resizeTextNodes(this.getLayer().getCamera(0).getViewScale());
    }

    private PText getTextObjectAt(String textStr, double dx, double dy, boolean resize, int size) {
        PText text = new PText(textStr);
        text.setTextPaint((Paint)TEXT_COLOR);
        text.setFont(new Font("Arial", 1, size));
        text.translate(dx, dy);
        TEXT_HEIGHT = (float)text.getHeight();
        if (resize) {
            this.textNodes.add(text);
            this.textNodeEnds.add(new Double(dx));
        }
        return text;
    }

    public void removeTextNodes() {
        this.getLayer().removeChildren((Collection)this.textNodes);
    }

    public void resizeTextNodes(double scale) {
        for (int i = 0; i < this.textNodes.size(); ++i) {
            PText currNode = (PText)this.textNodes.get(i);
            currNode.setFont(new Font("Arial", 1, (int)(20.0 / scale)));
            Rectangle2D bounds = currNode.getGlobalFullBounds().getBounds2D();
            currNode.translate((double)END_SPACE - (bounds.getX() + bounds.getWidth()), 0.0);
            TEXT_HEIGHT = (int)(20.0 / scale);
        }
        this.validateTree();
    }

    public void addTextNodes() {
        for (int i = 0; i < this.textNodes.size(); ++i) {
            ((PText)this.textNodes.get(i)).setVisible(true);
        }
    }

    public void addGeneCircles(int chrom, String exp, CGHClone[] genes) {
        this.removeGeneCircles();
        ChromDataGraphNode chromNode = (ChromDataGraphNode)this.chromNodeHash.get(chrom + "," + exp);
        for (int i = 0; i < genes.length; ++i) {
            int relCloneIndex = this.data.getRelativeIndex(genes[i].getSortedIndex(), chrom - 1);
            chromNode.setTooltip(relCloneIndex, true);
            this.currCircledGenes.add(genes[i]);
        }
        this.currCircledChromNode = chromNode;
    }

    public void removeGeneCircles() {
        ChromDataGraphNode chromNode = this.currCircledChromNode;
        if (chromNode != null) {
            for (int i = 0; i < this.currCircledGenes.size(); ++i) {
                int relCloneIndex = this.data.getRelativeIndex(((CGHClone)this.currCircledGenes.get(i)).getSortedIndex(), chromNode.getChromosomeNumber() - 1);
                chromNode.setTooltip(relCloneIndex, false);
            }
            this.currCircledGenes.clear();
            this.currCircledChromNode = null;
        }
    }

    private double getOffset(int chromIndex, int expIndex) {
        double offset = 0.0;
        ArrayList selectedExps = this.displayStateManager.getSelectedExperiments();
        offset = chromIndex * (20 + selectedExps.size() * 150);
        return offset += (double)(expIndex * 150);
    }

    private float[] getRatioArray(String currExp, int chr, boolean NAs) {
        String curExp = currExp;
        boolean NA = true;
        ArrayList featuresList = this.data.getFeaturesList();
        int exprInd = -1;
        int chrIndex = chr - 1;
        for (int column = 0; column < featuresList.size(); ++column) {
            String name = this.data.getFullSampleName(column);
            if (!name.equals(curExp)) continue;
            exprInd = column;
            break;
        }
        float[] ratios = new float[this.data.getNumDataPointsInChrom(chrIndex)];
        for (int clone = 0; clone < ratios.length; ++clone) {
            ratios[clone] = this.data.getValue(exprInd, clone, chrIndex);
        }
        return ratios;
    }

    private ArrayList getGeneNamesBetweenIndices(String currExp, int Chr, boolean NAs) {
        ArrayList<String> geneNames = new ArrayList<String>();
        boolean NA = true;
        String curExpr = currExp;
        int chromosomeIndex = Chr - 1;
        int ind_St = ((MultipleArrayData)this.data).getChromosomeStartIndex(chromosomeIndex);
        int ind_End = ((MultipleArrayData)this.data).getChromosomeEndIndex(chromosomeIndex);
        for (int st = ind_St; st <= ind_End; ++st) {
            geneNames.add(this.data.getCloneAt(st).getName());
        }
        return geneNames;
    }

    private float getMaxGeneValue(String currExp, int Chr) {
        float maxRatio = 0.0f;
        String curExp = currExp;
        ArrayList featuresList = this.data.getFeaturesList();
        int exprInd = -1;
        for (int column = 0; column < featuresList.size(); ++column) {
            String name = ((ISlideData)featuresList.get(column)).getSlideDataName();
            if (!name.equals(currExp)) continue;
            exprInd = column;
            break;
        }
        int ChrGeneCnt = this.data.getNumDataPointsInChrom(Chr);
        for (int clone = 0; clone < ChrGeneCnt; ++clone) {
            if (!(this.data.getValue(exprInd, clone, Chr) > maxRatio)) continue;
            maxRatio = this.data.getValue(exprInd, clone, Chr);
        }
        return maxRatio;
    }

    public ArrayList getOrigIndArray(String currExp, int chrInd) {
        ArrayList featuresList = this.data.getFeaturesList();
        int exprInd = -1;
        for (int column = 0; column < featuresList.size(); ++column) {
            String name = ((ISlideData)featuresList.get(column)).getSlideDataName();
            if (!name.trim().equals(currExp.trim())) continue;
            exprInd = column;
            break;
        }
        int[][] chrIndices = this.data.getChromosomeIndices();
        int st = chrIndices[chrInd][0];
        int end = chrIndices[chrInd][1];
        ArrayList<Integer> ratioIndices = new ArrayList<Integer>();
        for (int ii = st; ii < end; ++ii) {
            float tmp = this.data.getLogAverageInvertedValue(exprInd, ii);
            if (Float.isNaN(tmp)) continue;
            ratioIndices.add(new Integer(ii - st));
        }
        return ratioIndices;
    }

    private int lookupGeneIndex(ArrayList indices, int NAIndex) {
        return (Integer)indices.get(NAIndex);
    }

    public float getMaxGeneSize(int Chr) {
        float maxsize = 2.4447206E8f;
        return maxsize;
    }

    public void onCloneValuesChanged(ICGHCloneValueMenu menu) {
    }

    public void onMenuChanged(ICGHDisplayMenu menu) {
    }

    public void onThresholdsChanged(ICGHDisplayMenu menu) {
    }

    public int[][] getClusters() {
        return null;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getExperimentID() {
        return 0;
    }

    public Expression getExpression() {
        return null;
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
    }

    public void setExperiment(Experiment e) {
    }

    public void setExperimentID(int id) {
    }

    private class MouseZoomEventHandler
    extends PBasicInputEventHandler {
        private static final int MIN_ZOOMRECT_SIZE = 50;
        protected PPath rectangle;
        protected Point2D pressPoint;
        protected Point2D endPoint;
        protected Point2D dragPoint;

        private MouseZoomEventHandler() {
        }

        public void mousePressed(PInputEvent e) {
            super.mousePressed(e);
            if (GraphViewPanel.this.displayStateManager.getGraphMode().equals("Zoom In")) {
                PLayer layer = GraphViewPanel.this.getLayer();
                this.dragPoint = this.pressPoint = e.getPosition();
                this.rectangle = new PPath();
                this.rectangle.setStroke((Stroke)new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
                this.rectangle.setStrokePaint((Paint)ZOOMRECT_COLOR);
                layer.addChild((PNode)this.rectangle);
                this.updateRectangle();
            }
        }

        public void mouseDragged(PInputEvent e) {
            super.mouseDragged(e);
            if (GraphViewPanel.this.displayStateManager.getGraphMode().equals("Zoom In") && this.rectangle != null) {
                this.dragPoint = e.getPosition();
                this.updateRectangle();
            }
        }

        /*
         * Unable to fully structure code
         */
        public void mouseReleased(PInputEvent e) {
            block3: {
                super.mouseReleased(e);
                if (!GraphViewPanel.access$200(GraphViewPanel.this).getGraphMode().equals("Zoom In") || this.rectangle == null) break block3;
                this.updateRectangle();
                this.endPoint = this.dragPoint;
                layer = GraphViewPanel.this.getLayer();
                layer.removeChild((PNode)this.rectangle);
                if (this.rectangle.getWidth() < 50.0) ** GOTO lbl-1000
                if (this.rectangle.getHeight() < 50.0) lbl-1000:
                // 2 sources

                {
                    e.getCamera().scaleViewAboutPoint(2.0, this.rectangle.getX(), this.rectangle.getY());
                } else {
                    rectWidth = this.rectangle.getWidth();
                    rectHeight = this.rectangle.getHeight();
                    currWidth = e.getCamera().getWidth();
                    currHeight = e.getCamera().getHeight();
                    e.getCamera().animateViewToCenterBounds((Rectangle2D)this.rectangle.getGlobalFullBounds(), true, 70L);
                }
                this.rectangle = null;
            }
            if (GraphViewPanel.access$200(GraphViewPanel.this).getGraphMode().equals("Zoom Out")) {
                this.endPoint = e.getPosition();
                e.getCamera().scaleViewAboutPoint(0.5, this.endPoint.getX(), this.endPoint.getY());
            }
            GraphViewPanel.this.resizeTextNodes(e.getCamera().getViewScale());
        }

        public void updateRectangle() {
            PBounds b = new PBounds();
            b.add(this.pressPoint);
            b.add(this.dragPoint);
            this.rectangle.setPathTo((Shape)b);
        }
    }

    private class MouseSelectionEventHandler
    extends PBasicInputEventHandler {
        protected PPath rectangle;
        protected Point2D pressPoint;
        protected Point2D endPoint;
        protected Point2D dragPoint;
        private Point2D lastMovementPoint = new Point2D.Double(0.0, 0.0);
        private double moveSpeed;
        private PPath tooltipPt = null;
        private Rectangle2D tooltipRect;
        private GeneGraphNode currMouseOverGene;
        private boolean mousePressed;

        private MouseSelectionEventHandler() {
        }

        public void mousePressed(PInputEvent e) {
            super.mousePressed(e);
            this.mousePressed = true;
            this.clearToolTip();
            if (GraphViewPanel.this.displayStateManager.getGraphMode().equals("Select") && e.isRightMouseButton()) {
                this.displayExpToolTip(e);
            }
            if (GraphViewPanel.this.displayStateManager.getGraphMode().equals("Select") && e.isLeftMouseButton()) {
                PLayer layer = GraphViewPanel.this.getLayer();
                GraphViewPanel.this.removeGeneCircles();
                this.dragPoint = this.pressPoint = e.getPosition();
                this.clearCurrentSelection();
                this.rectangle = new PPath();
                this.rectangle.setStroke((Stroke)new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
                this.rectangle.setStrokePaint((Paint)SELECTIONRECT_COLOR);
                layer.addChild((PNode)this.rectangle);
                this.updateRectangle();
            }
        }

        public void mouseMoved(PInputEvent e) {
            super.mouseDragged(e);
            if (GraphViewPanel.this.displayStateManager.getGraphMode().equals("Select")) {
                Point2D p = e.getPosition();
                this.moveSpeed = p.distance(this.lastMovementPoint);
                this.lastMovementPoint = p;
                if (this.moveSpeed <= 100.0) {
                    this.updateToolTip(e);
                } else {
                    this.clearToolTip();
                }
            }
        }

        public void mouseClicked(PInputEvent e) {
            super.mouseClicked(e);
            if (e.isRightMouseButton()) {
                this.displayExpToolTip(e);
            }
        }

        public void mouseDragged(PInputEvent e) {
            if (GraphViewPanel.this.displayStateManager.getGraphMode().equals("Select") && this.rectangle != null) {
                super.mouseDragged(e);
                this.dragPoint = e.getPosition();
                this.updateRectangle();
            }
        }

        public void mouseReleased(PInputEvent e) {
            this.mousePressed = false;
            if (GraphViewPanel.this.displayStateManager.getGraphMode().equals("Select") && this.rectangle != null) {
                super.mouseReleased(e);
                this.updateRectangle();
                this.endPoint = this.dragPoint;
                PLayer layer = GraphViewPanel.this.getLayer();
                Iterator vals = GraphViewPanel.this.chromNodeHash.values().iterator();
                ArrayList<PNode> intersections = new ArrayList<PNode>();
                while (vals.hasNext()) {
                    PNode curr = (PNode)vals.next();
                    Rectangle2D.Double rect = new Rectangle2D.Double(this.rectangle.getGlobalFullBounds().getX(), this.rectangle.getGlobalFullBounds().getY(), this.rectangle.getGlobalFullBounds().getWidth(), this.rectangle.getGlobalFullBounds().getHeight());
                    if (!curr.getGlobalFullBounds().intersects((Rectangle2D)rect)) continue;
                    intersections.add(curr);
                }
                this.clearCurrentSelection();
                if (intersections.size() > 0) {
                    this.handleIntersection(intersections);
                }
                layer.removeChild((PNode)this.rectangle);
                this.rectangle = null;
            }
        }

        public void updateRectangle() {
            PBounds b = new PBounds();
            b.add(this.pressPoint);
            b.add(this.dragPoint);
            this.rectangle.setPathTo((Shape)b);
        }

        public void updateToolTip(PInputEvent event) {
            PNode n;
            double cameraScale = event.getCamera().getViewScale();
            if (cameraScale > 1.0) {
                this.clearToolTip();
                for (n = event.getInputManager().getMouseOver().getPickedNode(); n != null && !(n instanceof GeneGraphNode); n = n.getParent()) {
                }
                if (n != null) {
                    this.currMouseOverGene = (GeneGraphNode)n;
                    this.currMouseOverGene.setMouseOver(true);
                    this.currMouseOverGene.render();
                }
            } else {
                while (n != null && !(n instanceof ChromDataGraphNode)) {
                    n = n.getParent();
                }
            }
            if (n != null) {
                String tooltipString = (String)n.getClientProperty((Object)"tooltip");
                Point2D p = event.getCanvasPosition();
                event.getPath().canvasToLocal(p, (PNode)GraphViewPanel.this.getCamera());
                GraphViewPanel.this.tooltipNode.setText(tooltipString);
                GraphViewPanel.this.tooltipNode.setOffset(p.getX() + 8.0, p.getY() - 8.0);
                GraphViewPanel.this.tooltipNode.setPaint((Paint)new Color(255, 255, 204));
                GraphViewPanel.this.tooltipNode.setTextPaint((Paint)Color.BLACK);
            } else {
                this.clearToolTip();
            }
        }

        public void displayExpToolTip(PInputEvent e) {
            PNode n;
            for (n = e.getInputManager().getMouseOver().getPickedNode(); n != null && !(n instanceof ChromDataGraphNode); n = n.getParent()) {
            }
            if (n != null) {
                this.clearToolTip();
                String tooltipString = (String)n.getClientProperty((Object)"tooltip");
                Point2D p = e.getCanvasPosition();
                e.getPath().canvasToLocal(p, (PNode)GraphViewPanel.this.getCamera());
                GraphViewPanel.this.tooltipNode.setText(tooltipString);
                GraphViewPanel.this.tooltipNode.setOffset(p.getX() + 8.0, p.getY() - 8.0);
                GraphViewPanel.this.tooltipNode.setPaint((Paint)new Color(255, 255, 204));
                GraphViewPanel.this.tooltipNode.setTextPaint((Paint)Color.BLACK);
            }
        }

        public void clearToolTip() {
            GraphViewPanel.this.tooltipNode.setText("");
            if (this.currMouseOverGene != null) {
                this.currMouseOverGene.setMouseOver(false);
                this.currMouseOverGene.setChanged(true);
                this.currMouseOverGene.render();
                this.currMouseOverGene = null;
            }
        }

        public PNode getIntersectingChromNode(Rectangle2D rect) {
            Iterator vals = GraphViewPanel.this.chromNodeHash.values().iterator();
            PNode intersection = null;
            boolean found = false;
            while (vals.hasNext() && !found) {
                PNode curr = (PNode)vals.next();
                if (!curr.getGlobalFullBounds().intersects(rect)) continue;
                intersection = curr;
                found = true;
            }
            return intersection;
        }

        public PNode getIntersectingGeneNode(IChromGraphNode chromIntersection, Rectangle2D rect) {
            if (chromIntersection != null && chromIntersection.getType() == 1) {
                ChromDataGraphNode chromNode = (ChromDataGraphNode)chromIntersection;
                return chromNode.getIntersectingChild(rect);
            }
            return null;
        }

        public void handleIntersection(ArrayList intersectingNodes) {
            PNode node;
            double minDist = 1000000.0;
            int minIndex = 0;
            for (int i = 0; i < intersectingNodes.size(); ++i) {
                Point2D nodePt = ((PNode)intersectingNodes.get(i)).getBounds().getCenter2D();
                ((PNode)intersectingNodes.get(i)).localToGlobal(nodePt);
                Point2D rectPt = this.rectangle.getBounds().getCenter2D();
                this.rectangle.localToGlobal(rectPt);
                double currDist = Point2D.distance(0.0, nodePt.getY(), 0.0, rectPt.getY());
                if (!(currDist < minDist)) continue;
                minDist = currDist;
                minIndex = i;
            }
            GraphViewPanel.this.currChromGraphSelection = (IChromGraphNode)intersectingNodes.get(minIndex);
            GraphViewPanel.this.currSelectedIndices = GraphViewPanel.this.currChromGraphSelection.selectChildren((Rectangle2D)this.rectangle.getGlobalFullBounds());
            int selectType = GraphViewPanel.this.currChromGraphSelection.getType();
            if (selectType == 1) {
                node = (ChromDataGraphNode)GraphViewPanel.this.currChromGraphSelection;
                int currChrom = node.getChromosomeNumber();
                String currExp = node.getExperiment();
                ArrayList<CGHClone> selectedGenes = new ArrayList<CGHClone>();
                for (int i = 0; i < GraphViewPanel.this.currSelectedIndices.size(); ++i) {
                    int rowInd = (Integer)GraphViewPanel.this.currSelectedIndices.get(i);
                    int exprCol = ((MultipleArrayData)GraphViewPanel.this.data).getExperimentIndex(currExp);
                    int cloneInd = GraphViewPanel.this.data.getCloneIndex(rowInd, currChrom - 1);
                    CGHClone currGene = GraphViewPanel.this.data.getCloneAt(cloneInd);
                    float ratio = GraphViewPanel.this.data.getRatio(exprCol, cloneInd, 1);
                    currGene.setRatio(ratio);
                    selectedGenes.add(currGene);
                }
                GraphViewPanel.this.displayStateManager.setGraphSelectionGenes(currExp, currChrom, selectedGenes);
            }
            if (selectType == 2) {
                node = (ChromPredictionsGraphNode)GraphViewPanel.this.currChromGraphSelection;
                String currExp = node.getExperiment();
                int currChrom = node.getChromosomeNumber();
                ArrayList segmentList = GraphViewPanel.this.displayStateManager.getPredictionSegments(currExp, currChrom);
                ArrayList<SegmentInfo> selectedSegments = new ArrayList<SegmentInfo>();
                for (int i = 0; i < GraphViewPanel.this.currSelectedIndices.size(); ++i) {
                    selectedSegments.add((SegmentInfo)segmentList.get((Integer)GraphViewPanel.this.currSelectedIndices.get(i)));
                }
                GraphViewPanel.this.displayStateManager.setGraphSelectionSegments(currExp, node.getChromosomeNumber(), selectedSegments);
            }
        }

        public void clearCurrentSelection() {
            if (GraphViewPanel.this.currChromGraphSelection != null) {
                GraphViewPanel.this.currChromGraphSelection.unselectChildren(GraphViewPanel.this.currSelectedIndices);
                GraphViewPanel.this.currChromGraphSelection = null;
                GraphViewPanel.this.currSelectedIndices = null;
                GraphViewPanel.this.displayStateManager.clearGraphSelection();
            }
        }
    }
}

