/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer.TableDataModel;

public class GeneTable
extends JTable {
    public static final int WIDTH = 300;
    public static final int HEIGHT = 300;
    public static final Color BACKGROUND = Color.LIGHT_GRAY;
    CGHClone[] genes = null;
    String currexp = "";
    MultipleArrayData data;
    TableDataModel tableData;

    public GeneTable(MultipleArrayData data) {
        this.data = data;
        this.setBackground(BACKGROUND);
    }

    public void clearGenes() {
        this.genes = null;
        this.currexp = "";
        System.gc();
    }

    public boolean containsGenes() {
        return this.genes != null;
    }

    public void setGenes(CGHClone[] gene_selections, String experiment) {
        this.currexp = experiment;
        this.genes = gene_selections;
        if (this.genes != null && this.genes.length > 0) {
            Object[][] geneinfo = new Object[this.genes.length][4];
            for (int i = 0; i < this.genes.length; ++i) {
                geneinfo[i][0] = this.genes[i].getName();
                geneinfo[i][1] = this.genes[i].getChromosome();
                geneinfo[i][2] = Float.valueOf(this.genes[i].getRatio());
                geneinfo[i][3] = this.genes[i].getDesc(this.data);
            }
            this.tableData = new TableDataModel(geneinfo);
            this.setModel(this.tableData);
            this.initCols();
        } else {
            Object[][] info = new String[1][4];
            info[0][0] = "Probe Name";
            info[0][1] = "Chromosome";
            info[0][2] = "Log2 Ratio";
            info[0][3] = "Desc";
            this.tableData = new TableDataModel(info);
        }
    }

    public void setGenes(ArrayList gene_selections, String experiment) {
        this.currexp = experiment;
        if (gene_selections.size() > 0) {
            Object[][] geneinfo = new Object[gene_selections.size()][4];
            this.genes = new CGHClone[gene_selections.size()];
            for (int i = 0; i < gene_selections.size(); ++i) {
                this.genes[i] = (CGHClone)gene_selections.get(i);
                if (this.genes[i] != null) {
                    geneinfo[i][0] = this.genes[i].getName();
                    geneinfo[i][1] = this.genes[i].getChromosome();
                    geneinfo[i][2] = Float.valueOf(this.genes[i].getRatio());
                    geneinfo[i][3] = this.genes[i].getDesc(this.data);
                    continue;
                }
                geneinfo[i][0] = "";
                geneinfo[i][1] = "";
                geneinfo[i][2] = "";
                geneinfo[i][3] = "";
            }
            this.tableData = new TableDataModel(geneinfo);
            this.setModel(this.tableData);
            this.initCols();
        } else {
            Object[][] info = new String[1][4];
            info[0][0] = "Probe Name";
            info[0][1] = "Chromosome";
            info[0][2] = "Log2 Ratio";
            info[0][3] = "Desc";
            this.tableData = new TableDataModel(info);
        }
    }

    public CGHClone[] getGenes() {
        if (this.genes != null) {
            return this.genes;
        }
        return null;
    }

    public CGHClone[] getSelectedGenes() {
        if (this.genes != null) {
            int[] indices = this.getSelectedRows();
            if (indices.length > 0) {
                CGHClone[] selected = new CGHClone[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    if (this.genes[indices[i]] == null) continue;
                    selected[i] = this.genes[indices[i]];
                }
                return selected;
            }
            return null;
        }
        return null;
    }

    public void writeGenesToFile(String file) {
        if (this.genes != null) {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                out.write("Experiment\tChromosome\tGene ID\t");
                out.write("Value");
                out.newLine();
                for (int i = 0; i < this.genes.length; ++i) {
                    out.write(this.currexp + "\t" + this.genes[i].getChromosome() + "\t" + this.genes[i].getName() + "\t");
                    out.write(this.genes[i].getRatio() + "");
                    out.newLine();
                }
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getExperiment() {
        return this.currexp;
    }

    private void initCols() {
        TableColumn column = null;
        for (int i = 0; i < 4; ++i) {
            column = this.getColumnModel().getColumn(i);
            if (i == 3) {
                column.setPreferredWidth(400);
                continue;
            }
            if (i == 1) {
                column.setPreferredWidth(20);
                continue;
            }
            column.setPreferredWidth(30);
        }
    }
}

