/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer;

import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;

public class GeneList
extends JList {
    public static final int WIDTH = 300;
    public static final int HEIGHT = 300;
    public static final Color BACKGROUND = Color.LIGHT_GRAY;
    CGHClone[] genes = null;
    String currexp = "";
    MultipleArrayData data;
    TitledBorder listborder;

    public GeneList(MultipleArrayData data) {
        this.data = data;
        this.listborder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Genes List");
        this.setBorder(this.listborder);
        this.setListData(new String[]{"Select one or more genes to display gene information."});
        this.setBackground(BACKGROUND);
    }

    public void clearGenes() {
        this.genes = null;
        this.currexp = "";
        System.gc();
        this.setListData(new String[]{"Select one or more genes to display gene information."});
    }

    public boolean containsGenes() {
        return this.genes != null;
    }

    public void setGenes(CGHClone[] gene_selections, String experiment) {
        this.setPreferredSize(new Dimension(300, gene_selections.length * 20));
        this.currexp = experiment;
        this.genes = gene_selections;
        if (this.genes != null && this.genes.length > 0) {
            this.listborder.setTitle("Experiment " + experiment);
            String[] geneinfo = new String[this.genes.length];
            for (int i = 0; i < geneinfo.length; ++i) {
                geneinfo[i] = "" + this.genes[i].getName() + ":    Chr " + this.genes[i].getChromosome() + ",     Log2 Ratio = " + this.genes[i].getRatio() + ",\tDesc - " + this.genes[i].getDesc(this.data);
            }
            this.setListData(geneinfo);
        } else {
            this.listborder.setTitle("Gene List");
            this.setListData(new String[]{"Select one or more genes to display gene information."});
        }
    }

    public void setGenes(ArrayList gene_selections, String experiment) {
        this.setPreferredSize(new Dimension(300, gene_selections.size() * 20));
        this.currexp = experiment;
        if (gene_selections.size() > 0) {
            this.listborder.setTitle("Experiment " + experiment);
            String[] geneinfo = new String[gene_selections.size()];
            this.genes = new CGHClone[gene_selections.size()];
            for (int i = 0; i < geneinfo.length; ++i) {
                this.genes[i] = (CGHClone)gene_selections.get(i);
                geneinfo[i] = this.genes[i] != null ? "" + this.genes[i].getName() + ":    Chr " + this.genes[i].getChromosome() + ",  Value: " + this.genes[i].getRatio() + ",\tDesc - " + this.genes[i].getDesc(this.data) : " ";
            }
            this.setListData(geneinfo);
        } else {
            this.listborder.setTitle("Gene List");
            this.setListData(new String[]{"Select one or more genes to display gene information."});
        }
    }

    public CGHClone[] getGenes() {
        if (this.genes != null) {
            return this.genes;
        }
        return null;
    }

    public CGHClone[] getSelectedGenes() {
        if (this.genes != null) {
            int[] indices = this.getSelectedIndices();
            if (indices.length > 0) {
                CGHClone[] selected = new CGHClone[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    if (this.genes[indices[i]] == null) continue;
                    selected[i] = this.genes[indices[i]];
                }
                return selected;
            }
            return null;
        }
        return null;
    }

    public void writeGenesToFile(String file) {
        if (this.genes != null) {
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                out.write("Experiment\tChromosome\tGene ID\t");
                out.write("Value");
                out.newLine();
                for (int i = 0; i < this.genes.length; ++i) {
                    out.write(this.currexp + "\t" + this.genes[i].getChromosome() + "\t" + this.genes[i].getName() + "\t");
                    out.write(this.genes[i].getRatio() + "");
                    out.newLine();
                }
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getExperiment() {
        return this.currexp;
    }
}

