/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PLine;
import java.awt.Color;
import java.awt.Paint;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer.GraphProperties;

public class GeneGraphNode
extends PNode {
    private boolean isSelected = false;
    private boolean isChanged = false;
    private boolean mouseOver = false;
    private static float axisScale = 1.0f;
    private static float guiScaleFactor = 1.0f;
    private int geneIndex = 0;
    private float geneValue = 0.0f;
    private PLine geneLine;
    private PPath mouseOverCircle;
    private float lastDx;
    private float lastDy;

    public GeneGraphNode(int index, double value, double scaleFactor, String tooltip) {
        this.geneIndex = index;
        this.geneValue = (float)value;
        this.geneLine = new PLine();
        this.mouseOverCircle = new PPath();
        this.addChild((PNode)this.geneLine);
        this.addChild((PNode)this.mouseOverCircle);
        this.addClientProperty("tooltip", tooltip);
        this.lastDx = 0.0f;
        this.lastDy = 0.0f;
        guiScaleFactor = (float)scaleFactor;
        this.isChanged = true;
        this.render();
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean change) {
        this.isChanged = change;
    }

    public void setMouseOver(boolean mouse) {
        this.mouseOver = mouse;
        this.isChanged = true;
    }

    public void render() {
        Color geneColor = null;
        if (this.isChanged) {
            if (this.mouseOver) {
                this.mouseOverCircle.setPathToEllipse(-2.0f, (float)((double)(-Math.min(this.geneValue * axisScale, guiScaleFactor)) - 2.0), 4.0f, 4.0f);
                this.mouseOverCircle.setStrokePaint((Paint)GraphProperties.MOUSE_OVER_COLOR);
                this.mouseOverCircle.setPaint((Paint)Color.BLACK);
                this.mouseOverCircle.setTransparency(1.0f);
                this.addChild((PNode)this.mouseOverCircle);
            } else {
                this.mouseOverCircle.setPathToRectangle(0.0f, 0.0f, 0.0f, 0.0f);
                this.mouseOverCircle.setTransparency(1.0f);
            }
            this.removeChild((PNode)this.geneLine);
            this.geneLine = new PLine();
            if (Double.isNaN(this.geneValue)) {
                geneColor = GraphProperties.NAN_COLOR;
                this.geneLine.setStrokePaint((Paint)geneColor);
                this.geneLine.addPoint(0, 0.0, -0.01);
                this.geneLine.addPoint(1, 0.0, 0.01);
            } else if (this.isSelected()) {
                geneColor = this.geneValue >= 0.0f ? GraphProperties.SELECTED_UP_COLOR : GraphProperties.SELECTED_DOWN_COLOR;
                this.geneLine.setStrokePaint((Paint)geneColor);
                this.geneLine.addPoint(0, 0.0, 0.0);
                this.geneLine.addPoint(1, 0.0, (double)(-Math.min(this.geneValue * axisScale, guiScaleFactor)));
            } else {
                geneColor = this.geneValue >= 0.0f ? GraphProperties.UP_COLOR : GraphProperties.DOWN_COLOR;
                this.geneLine.setStrokePaint((Paint)geneColor);
                this.geneLine.addPoint(0, 0.0, 0.0);
                this.geneLine.addPoint(1, 0.0, (double)(-Math.min(this.geneValue * axisScale, guiScaleFactor)));
            }
            this.addChild((PNode)this.geneLine);
            this.isChanged = false;
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean select) {
        this.isSelected = select;
    }

    public void setGeneIndex(int index) {
        this.geneIndex = index;
    }

    public int getGeneIndex() {
        return this.geneIndex;
    }

    public void setGeneValue(double val) {
        this.geneValue = (float)val;
    }

    public double getGeneValue() {
        return this.geneValue;
    }

    public void setAxisScale(double scale) {
        axisScale = (float)scale;
    }

    public void translate(double dx, double dy) {
        super.translate(dx, dy);
        this.lastDx = (float)dx;
        this.lastDy = (float)dy;
    }

    public void reverseLastTranslation() {
        this.translate(-this.lastDx, -this.lastDy);
    }
}

