/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer;

import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.ChARM;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.PValue;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.TestSignificanceDialog;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.ResultContainer;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.SegmentInfo;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer.GeneList;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer.GeneTable;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer.GraphViewPanel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDialogs.ExportResultsDialog;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;

public class CharmGUI
extends JPanel
implements IViewer {
    public static final int LEFT_WIDTH = 285;
    public static final String EXTENSION = ".txt";
    public static final Color GRAPH_BACKGROUND = Color.BLACK;
    public static final Color STAT_BACKGROUND = Color.WHITE;
    public static final int TIMER_DELAY = 1000;
    ChARM displayState;
    JPanel contentPane = this;
    ImageIcon image1;
    ImageIcon image2;
    ImageIcon zoomInImage;
    ImageIcon zoomOutImage;
    ImageIcon image5;
    ImageIcon mousePointerImage;
    ImageIcon resetZoom;
    ImageIcon saveImage;
    ImageIcon image9;
    ImageIcon image10;
    ImageIcon predImage;
    GraphButtonListener graphButtonListener = new GraphButtonListener();
    ExpOptionsCheckboxListener expCheckboxListener = new ExpOptionsCheckboxListener();
    private Cursor zoomInCursor;
    private Cursor zoomOutCursor;
    JPanel dummyPanel = new JPanel();
    JToggleButton zoomInButton = new JToggleButton();
    JToggleButton zoomOutButton = new JToggleButton();
    JToggleButton selectButton = new JToggleButton();
    JButton resetZoomButton = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    Box viewResultsBox = Box.createVerticalBox();
    Box expOptionsBox = Box.createVerticalBox();
    Box predictionOptionsBox = Box.createVerticalBox();
    JPanel genelistPanel;
    JPanel pvaluePanel;
    JButton exportGenesButton;
    JButton runSigTestButton;
    FileDialog fileDialog1;
    PScrollPane scrollPaneRight;
    JPanel jPanelToolBar = new JPanel();
    JToolBar jToolBarZoom = new JToolBar();
    GraphViewPanel graphPanel;
    JSplitPane jSplitPane1 = new JSplitPane();
    GeneList genelist;
    GeneTable geneTable;
    int exptID;
    private JPanel expcheckboxes;
    private JPanel predcheckboxes;
    private JTextField[] pvalue_fields;
    private JComboBox cutoff_box;
    private JButton update_cutoffs_button;
    private JScrollPane expscrollpane;
    XYLayout xYLayout1 = new XYLayout();
    JToolBar jToolBarRatioPred = new JToolBar();
    JToggleButton togglePredictionsButton = new JToggleButton();
    TitledBorder titledBorder1;
    JButton exportButton = new JButton();
    IFramework framework;
    IData data;
    int[] analyzedExprIndices;

    public CharmGUI(IFramework framework, ChARM charm, int[] exprInidces) {
        this.framework = framework;
        this.data = this.framework.getData();
        this.analyzedExprIndices = exprInidces;
        this.displayState = charm;
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CharmGUI(IData dat, ChARM charm, int[] exprInidces) {
        this.data = dat;
        if (this.data == null) {
            System.out.println("In Const. CharmGUI()- data is null");
        }
        this.analyzedExprIndices = exprInidces;
        this.displayState = charm;
        charm.setCharmGUI(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            System.out.println("Exception in CharmGUI constructor, jbInit()");
            e.printStackTrace();
        }
        this.graphPanel.initializePredictionNodes(charm.getSelectedExperiments());
        this.togglePredictionsButton.setEnabled(true);
        this.togglePredictionsButton.setSelected(true);
        this.displayState.setStateVariable("Prediction Plot Toggle", "on");
        this.jTabbedPane1.setSelectedIndex(1);
        this.graphPanel.updateGraph();
        this.validate();
    }

    private void jbInit() throws Exception {
        this.contentPane = this;
        this.contentPane.setLayout(this.borderLayout1);
        this.initButtons();
        this.initLeftPanel();
        this.initRightPanel();
        this.jSplitPane1 = new JSplitPane(0, (Component)this.scrollPaneRight, this.jTabbedPane1);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setDividerLocation(600);
        this.contentPane.add((Component)this.jSplitPane1, "Center");
        ImageIcon im = new ImageIcon(this.getClass().getResource("/org/tigr/images/Charm_zoom-in.png"));
        ImageIcon im2 = new ImageIcon(this.getClass().getResource("/org/tigr/images/Charm_zoom-out.png"));
        this.zoomInCursor = Toolkit.getDefaultToolkit().createCustomCursor(im.getImage(), new Point(0, 0), "Zoom In Cursor");
        this.zoomOutCursor = Toolkit.getDefaultToolkit().createCustomCursor(im2.getImage(), new Point(0, 0), "Zoom Out Cursor");
    }

    public void initButtons() {
        this.jPanelToolBar.setLayout((LayoutManager)this.xYLayout1);
        this.jPanelToolBar.setToolTipText("");
        this.jPanelToolBar.add((Component)this.jToolBarZoom, new XYConstraints(5, 2, 0, 0));
        this.jPanelToolBar.add((Component)this.jToolBarRatioPred, new XYConstraints(245, 3, 0, 0));
        this.contentPane.add((Component)this.jPanelToolBar, "North");
        this.zoomInImage = new ImageIcon(this.getClass().getResource("/org/tigr/images/Charm_zoom-in.png"));
        this.zoomOutImage = new ImageIcon(this.getClass().getResource("/org/tigr/images/Charm_zoom-out.png"));
        this.mousePointerImage = new ImageIcon(this.getClass().getResource("/org/tigr/images/Charm_mouse.png"));
        this.resetZoom = new ImageIcon(this.getClass().getResource("/org/tigr/images/Charm_fit-1.png"));
        this.saveImage = new ImageIcon(this.getClass().getResource("/org/tigr/images/Charm_save.png"));
        this.predImage = new ImageIcon(this.getClass().getResource("/org/tigr/images/Charm_data-1.png"));
        this.exportButton.addActionListener(this.graphButtonListener);
        this.exportButton.setActionCommand("Export results");
        this.exportButton.setToolTipText("Export data");
        this.exportButton.setIcon(this.saveImage);
        this.exportButton.setEnabled(true);
        this.zoomInButton.setIcon(this.zoomInImage);
        this.zoomInButton.setToolTipText("Zoom In");
        this.zoomInButton.setActionCommand("Zoom In");
        this.zoomInButton.addActionListener(this.graphButtonListener);
        this.zoomOutButton.setIcon(this.zoomOutImage);
        this.zoomOutButton.setToolTipText("Zoom Out");
        this.zoomOutButton.setActionCommand("Zoom Out");
        this.zoomOutButton.addActionListener(this.graphButtonListener);
        this.selectButton.setIcon(this.mousePointerImage);
        this.selectButton.setToolTipText("Select mode");
        this.selectButton.setActionCommand("Select");
        this.selectButton.addActionListener(this.graphButtonListener);
        this.selectButton.setSelected(true);
        this.displayState.setGraphMode("Select");
        this.resetZoomButton.setIcon(this.resetZoom);
        this.resetZoomButton.setToolTipText("Reset Zoom");
        this.resetZoomButton.setActionCommand("Reset Zoom");
        this.resetZoomButton.addActionListener(this.graphButtonListener);
        this.togglePredictionsButton.setIcon(this.predImage);
        this.togglePredictionsButton.setToolTipText("Toggle prediction plots");
        this.togglePredictionsButton.setActionCommand("Toggle Predictions");
        this.togglePredictionsButton.addActionListener(this.graphButtonListener);
        this.togglePredictionsButton.setEnabled(true);
        this.jToolBarZoom.add((Component)this.exportButton, null);
        this.jToolBarZoom.add((Component)this.selectButton, null);
        this.jToolBarZoom.add((Component)this.zoomInButton, null);
        this.jToolBarZoom.add((Component)this.zoomOutButton, null);
        this.jToolBarZoom.add((Component)this.resetZoomButton, null);
        this.jToolBarZoom.setEnabled(false);
        this.jToolBarRatioPred.add((Component)this.togglePredictionsButton, null);
        this.jToolBarRatioPred.setBorder(null);
        this.jToolBarRatioPred.setFloatable(false);
    }

    public void initLeftPanel() {
        this.jTabbedPane1.add((Component)this.viewResultsBox, "Results");
        this.jTabbedPane1.add((Component)this.expOptionsBox, "Experiment Options");
        this.jTabbedPane1.add((Component)this.predictionOptionsBox, "Prediction Options");
        this.initViewResultsPanel();
        this.initExpOptionsPanel();
        this.initPredOptionsPanel();
    }

    public void initPredOptionsPanel() {
        this.pvaluePanel = new JPanel();
        this.pvaluePanel.setLayout(new BoxLayout(this.pvaluePanel, 1));
        this.pvaluePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Prediction p-value cutoffs"));
        String[] cutoff_types = new String[]{"Sign AND Mean Tests", "Sign OR Mean Tests", "Sign Test", "Mean Test"};
        JPanel cutoffPanel = new JPanel();
        cutoffPanel.setLayout(new BoxLayout(cutoffPanel, 0));
        this.cutoff_box = new JComboBox<String>(cutoff_types);
        this.cutoff_box.setMaximumSize(new Dimension(285, 25));
        this.cutoff_box.setSelectedIndex(0);
        this.cutoff_box.setToolTipText("Select the p-value cutoffs that displayed predictions must meet");
        this.cutoff_box.addActionListener(new CutoffSelectionListener());
        cutoffPanel.add(new JLabel("Filter predictions by: "));
        cutoffPanel.add(this.cutoff_box);
        this.pvaluePanel.add(cutoffPanel);
        this.pvalue_fields = new JTextField[2];
        String[] pvalue_labels = new String[]{"Sign p-value cutoff:  ", "Mean p-value cutoff:  "};
        for (int i = 0; i < this.pvalue_fields.length; ++i) {
            JPanel pvalCutoffpanel = new JPanel();
            pvalCutoffpanel.add(new JLabel(pvalue_labels[i]));
            pvalCutoffpanel.setLayout(new BoxLayout(pvalCutoffpanel, 0));
            pvalCutoffpanel.setAlignmentX(0.5f);
            this.pvalue_fields[i] = new JTextField();
            this.pvalue_fields[i].setMaximumSize(new Dimension(100, 25));
            pvalCutoffpanel.add(this.pvalue_fields[i]);
            this.pvaluePanel.add(pvalCutoffpanel);
        }
        this.pvalue_fields[0].setText("0.01");
        this.pvalue_fields[1].setText("0.01");
        this.displayState.setPValueCutoff(new PValue(0.01, 0.01));
        this.displayState.setPValueTestType(0);
        this.predcheckboxes = new JPanel();
        this.predcheckboxes.setLayout(new BoxLayout(this.predcheckboxes, 1));
        ResultContainer selectedResultSets = this.displayState.getSelectedResultSets();
        this.update_cutoffs_button = new JButton("Update Predictions Display");
        this.update_cutoffs_button.setToolTipText("Filter displayed predictions based on p-value cutoffs");
        this.update_cutoffs_button.setAlignmentX(0.5f);
        this.update_cutoffs_button.addActionListener(new CutoffListener());
        this.pvaluePanel.add(this.update_cutoffs_button);
        this.predictionOptionsBox.add(this.pvaluePanel);
    }

    public void initExpOptionsPanel() {
        this.expOptionsBox.setBackground(Color.lightGray);
        this.expOptionsBox.setAlignmentX(0.5f);
        this.expOptionsBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Select the experiments to be displayed"));
        this.expcheckboxes = new JPanel();
        this.expcheckboxes.setLayout(new BoxLayout(this.expcheckboxes, 1));
        String[] experiment_list = this.displayState.getExperimentList().toArray(new String[0]);
        for (int i = 0; i < experiment_list.length; ++i) {
            JCheckBox checkbox = new JCheckBox(experiment_list[i]);
            checkbox.addActionListener(this.expCheckboxListener);
            checkbox.setAlignmentX(0.5f);
            this.expcheckboxes.add(checkbox);
        }
        if (experiment_list.length > 0) {
            ((JCheckBox)this.expcheckboxes.getComponent(0)).setSelected(true);
        }
        this.expscrollpane = new JScrollPane(this.expcheckboxes);
        this.expscrollpane.getViewport().setBackground(STAT_BACKGROUND);
        this.expOptionsBox.add(this.expscrollpane);
    }

    public void initViewResultsPanel() {
        this.genelistPanel = new JPanel();
        this.genelistPanel.setLayout(new BoxLayout(this.genelistPanel, 1));
        this.geneTable = new GeneTable((MultipleArrayData)this.data);
        this.geneTable.setSelectionMode(2);
        ListSelectionModel rowSM = this.geneTable.getSelectionModel();
        rowSM.addListSelectionListener(new GeneTableListener());
        this.geneTable.setBackground(STAT_BACKGROUND);
        JScrollPane genescroll = new JScrollPane(this.geneTable);
        this.genelistPanel.add(genescroll);
        this.viewResultsBox.add(this.genelistPanel);
    }

    public void initRightPanel() {
        this.scrollPaneRight = new PScrollPane();
        if (this.scrollPaneRight == null) {
            System.out.println("In CharmGUI initRightPanel() scrollPaneRight is null");
        }
        if (this.displayState == null) {
            System.out.println("In CharmGUI initRightPanel() displayState is null");
        }
        this.graphPanel = new GraphViewPanel(this.displayState, this.scrollPaneRight);
        this.graphPanel.setLayout(new BoxLayout((Container)((Object)this.graphPanel), 1));
        this.graphPanel.setCursor(Cursor.getPredefinedCursor(12));
        this.graphPanel.setBackground(GRAPH_BACKGROUND);
        this.graphPanel.setDoubleBuffered(true);
        this.graphPanel.setOpaque(true);
        this.scrollPaneRight = new PScrollPane((Component)((Object)this.graphPanel));
        this.graphPanel.setParent(this.scrollPaneRight);
        this.scrollPaneRight.setKeyActionsDisabled(true);
        this.graphPanel.initializeGraph();
    }

    public void updateExpOptions() {
        this.expcheckboxes.removeAll();
        String[] experiment_list = this.displayState.getExperimentList().toArray(new String[0]);
        for (int i = 0; i < experiment_list.length; ++i) {
            JCheckBox checkbox = new JCheckBox(experiment_list[i]);
            checkbox.addActionListener(this.expCheckboxListener);
            this.expcheckboxes.add(checkbox);
        }
        if (experiment_list.length > 0) {
            ((JCheckBox)this.expcheckboxes.getComponent(0)).setSelected(true);
        }
        this.expscrollpane.setViewportView(this.expcheckboxes);
        this.graphPanel.resetZoom();
    }

    public void updategraphPanel() {
        this.graphPanel.updateGraph();
    }

    public void updateViewResults() {
        String graphSelectType = this.displayState.getStateVariable("Graph Selection Type");
        boolean zeroLength = false;
        if (graphSelectType.equals("gene")) {
            ArrayList selectedGenes = this.displayState.getGraphSelectionGenes();
            if (selectedGenes != null && selectedGenes.size() > 0) {
                String exp = this.displayState.getGraphSelectionExperiment();
                this.geneTable.setGenes(selectedGenes, exp);
                this.jTabbedPane1.setSelectedIndex(0);
            }
        } else if (graphSelectType.equals("window")) {
            ArrayList segments = this.displayState.getGraphSelectionWindows();
            if (segments != null) {
                int segOrigSt;
                String currExp = this.displayState.getGraphSelectionExperiment();
                int currChrom = this.displayState.getGraphSelectionChromosome();
                int segOrigEnd = -1;
                ArrayList indOrig = this.getOrigIndArray(currExp, currChrom - 1);
                int size = 0;
                for (int i = 0; i < segments.size(); ++i) {
                    segOrigSt = this.lookupGeneIndex(indOrig, ((SegmentInfo)segments.get(i)).getStart());
                    segOrigEnd = this.lookupGeneIndex(indOrig, ((SegmentInfo)segments.get(i)).getEnd());
                    size += segOrigEnd - segOrigSt + 1;
                }
                CGHClone[] windowgenes = new CGHClone[size];
                int j = 0;
                for (int i = 0; i < segments.size(); ++i) {
                    CGHClone[] clones = null;
                    segOrigSt = this.lookupGeneIndex(indOrig, ((SegmentInfo)segments.get(i)).getStart());
                    segOrigEnd = this.lookupGeneIndex(indOrig, ((SegmentInfo)segments.get(i)).getEnd());
                    clones = ((MultipleArrayData)this.data).getClonesWithinIndices(segOrigSt, segOrigEnd, currExp, currChrom);
                    for (int k = 0; k < clones.length; ++k) {
                        windowgenes[j] = clones[k];
                        ++j;
                    }
                }
                this.geneTable.setGenes(windowgenes, currExp);
                this.jTabbedPane1.setSelectedIndex(0);
            }
        } else {
            this.geneTable.clearGenes();
        }
    }

    public GraphViewPanel getGraphViewPanel() {
        return this.graphPanel;
    }

    public JToggleButton getTogglePredictionsButton() {
        return this.togglePredictionsButton;
    }

    public JTabbedPane getJTabbedPane1() {
        return this.jTabbedPane1;
    }

    public int[][] getClusters() {
        return null;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.data, this.displayState, this.analyzedExprIndices});
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onSelected(IFramework framework) {
        this.updategraphPanel();
    }

    public void setExperiment(Experiment e) {
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    public ArrayList getOrigIndArray(String currExp, int chrInd) {
        ArrayList featuresList = this.data.getFeaturesList();
        int exprInd = -1;
        for (int column = 0; column < featuresList.size(); ++column) {
            String name = ((ISlideData)featuresList.get(column)).getSlideDataName();
            if (!name.trim().equals(currExp.trim())) continue;
            exprInd = column;
            break;
        }
        int[][] chrIndices = this.data.getChromosomeIndices();
        int st = chrIndices[chrInd][0];
        int end = chrIndices[chrInd][1];
        ArrayList<Integer> ratioIndices = new ArrayList<Integer>();
        for (int ii = st; ii < end; ++ii) {
            float tmp = this.data.getLogAverageInvertedValue(exprInd, ii);
            if (Float.isNaN(tmp)) continue;
            ratioIndices.add(new Integer(ii - st));
        }
        return ratioIndices;
    }

    private int lookupGeneIndex(ArrayList indices, int NAIndex) {
        return (Integer)indices.get(NAIndex);
    }

    private class MenuListener
    implements ActionListener {
        private MenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("Exit")) {
                int returnVal = JOptionPane.showConfirmDialog(null, "Are you sure you want to quit?", "Confirm Exit", 2);
                if (returnVal == 0) {
                    System.exit(0);
                }
            } else if (!command.equals("Analyze data") && command.equals("Export results")) {
                ExportResultsDialog exportResults = new ExportResultsDialog(CharmGUI.this, CharmGUI.this.displayState);
                exportResults.setLocationRelativeTo(CharmGUI.this.dummyPanel);
                exportResults.setModal(false);
                exportResults.setVisible(true);
                if (exportResults.getExitStatus() == 1) {
                    int printStatus;
                    String filename = exportResults.getFilename();
                    System.out.println(filename + "," + exportResults.getExportType());
                    if (exportResults.getExportType() != 0 && exportResults.getExportType() == 1 && (printStatus = CharmGUI.this.displayState.printVisiblePredictionWindows(filename + CharmGUI.EXTENSION)) < 0) {
                        JOptionPane.showMessageDialog(null, "Error writing to file!  Please try again.", "File Output Error", 0);
                    }
                }
            }
        }
    }

    private class ExpOptionsCheckboxListener
    implements ActionListener {
        private ExpOptionsCheckboxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] experiment_list = CharmGUI.this.displayState.getExperimentList().toArray(new String[1]);
            for (int i = 0; i < experiment_list.length; ++i) {
                JCheckBox curr = (JCheckBox)CharmGUI.this.expcheckboxes.getComponent(i);
                if (e.getSource() != curr) continue;
                if (curr.isSelected()) {
                    CharmGUI.this.displayState.addSelectedExperiment(experiment_list[i]);
                    continue;
                }
                CharmGUI.this.displayState.removeSelectedExperiment(experiment_list[i]);
            }
            CharmGUI.this.updategraphPanel();
        }
    }

    private class CutoffListener
    implements ActionListener {
        private CutoffListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Double signCutoff = Double.valueOf(CharmGUI.this.pvalue_fields[0].getText());
                Double meanCutoff = Double.valueOf(CharmGUI.this.pvalue_fields[1].getText());
                PValue filterPval = new PValue(meanCutoff, signCutoff);
                CharmGUI.this.cutoff_box.validate();
                int index = CharmGUI.this.cutoff_box.getSelectedIndex();
                int testType = 0;
                switch (index) {
                    case 0: {
                        testType = 0;
                        break;
                    }
                    case 1: {
                        testType = 1;
                        break;
                    }
                    case 2: {
                        testType = 2;
                        break;
                    }
                    case 3: {
                        testType = 3;
                    }
                }
                CharmGUI.this.displayState.setPValueCutoff(filterPval);
                CharmGUI.this.displayState.setPValueTestType(testType);
                CharmGUI.this.graphPanel.initializePredictionNodes(CharmGUI.this.displayState.getSelectedExperiments());
                CharmGUI.this.graphPanel.updateGraph();
            }
            catch (NumberFormatException exc) {
                JOptionPane.showMessageDialog(CharmGUI.this, "Please enter P-values between 0 and 1.", "Error", 0);
            }
        }
    }

    private class CutoffSelectionListener
    implements ActionListener {
        private CutoffSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = CharmGUI.this.cutoff_box.getSelectedIndex();
            if (index == 2) {
                CharmGUI.this.pvalue_fields[0].setEnabled(true);
                CharmGUI.this.pvalue_fields[1].setEnabled(false);
            } else if (index == 3) {
                CharmGUI.this.pvalue_fields[1].setEnabled(true);
                CharmGUI.this.pvalue_fields[0].setEnabled(false);
            } else {
                CharmGUI.this.pvalue_fields[0].setEnabled(true);
                CharmGUI.this.pvalue_fields[1].setEnabled(true);
            }
        }
    }

    private class PermuteButtonListener
    implements ActionListener {
        JCheckBox mean_check;
        JCheckBox rank_check;
        JCheckBox sign_check;
        JCheckBox coeff_check;

        private PermuteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CharmGUI.this.displayState.getGraphSelectionChromosome() > 0) {
                int currChrom = CharmGUI.this.displayState.getGraphSelectionChromosome();
                String currExp = CharmGUI.this.displayState.getGraphSelectionExperiment();
                ArrayList geneList = CharmGUI.this.displayState.getGraphSelectionGenes();
                SegmentInfo currSeg = new SegmentInfo();
                if (geneList.size() > 0) {
                    currSeg.setStart(((CGHClone)geneList.get(0)).getSortedIndex());
                    currSeg.setEnd(((CGHClone)geneList.get(geneList.size() - 1)).getSortedIndex());
                    currSeg.setType(0);
                    TestSignificanceDialog testSigDialog = new TestSignificanceDialog(CharmGUI.this.displayState, currSeg, currChrom, currExp);
                    testSigDialog.setLocationRelativeTo(CharmGUI.this.dummyPanel);
                    testSigDialog.setModal(true);
                    testSigDialog.show();
                    int returnStatus = testSigDialog.getExitStatus();
                    if (returnStatus != TestSignificanceDialog.EXIT_CANCELLED) {
                        CharmGUI.this.graphPanel.updateGraph();
                        CharmGUI.this.togglePredictionsButton.setEnabled(true);
                        CharmGUI.this.togglePredictionsButton.setSelected(true);
                        CharmGUI.this.displayState.setStateVariable("Prediction Plot Toggle", "on");
                        ArrayList<String> exps = new ArrayList<String>();
                        exps.add(currExp);
                        CharmGUI.this.graphPanel.initializePredictionNodes(CharmGUI.this.displayState.getSelectedExperiments());
                        CharmGUI.this.graphPanel.updateGraph();
                    }
                }
            }
        }
    }

    private class GraphButtonListener
    implements ActionListener {
        private GraphButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("Select")) {
                CharmGUI.this.displayState.setGraphMode("Select");
                CharmGUI.this.graphPanel.setCursor(Cursor.getPredefinedCursor(12));
                CharmGUI.this.zoomInButton.setSelected(false);
                CharmGUI.this.zoomOutButton.setSelected(false);
                CharmGUI.this.selectButton.setSelected(true);
            }
            if (command.equals("Zoom In")) {
                CharmGUI.this.displayState.setGraphMode("Zoom In");
                CharmGUI.this.graphPanel.setCursor(CharmGUI.this.zoomInCursor);
                CharmGUI.this.zoomOutButton.setSelected(false);
                CharmGUI.this.selectButton.setSelected(false);
                CharmGUI.this.zoomInButton.setSelected(true);
            }
            if (command.equals("Zoom Out")) {
                CharmGUI.this.displayState.setGraphMode("Zoom Out");
                CharmGUI.this.graphPanel.setCursor(CharmGUI.this.zoomOutCursor);
                CharmGUI.this.zoomInButton.setSelected(false);
                CharmGUI.this.selectButton.setSelected(false);
                CharmGUI.this.zoomOutButton.setSelected(true);
            }
            if (command.equals("Reset Zoom")) {
                CharmGUI.this.graphPanel.resetZoom();
                CharmGUI.this.graphPanel.setCursor(new Cursor(12));
                CharmGUI.this.selectButton.setSelected(true);
                CharmGUI.this.zoomInButton.setSelected(false);
                CharmGUI.this.zoomOutButton.setSelected(false);
                CharmGUI.this.displayState.setGraphMode("Select");
            }
            if (command.equals("Toggle Predictions")) {
                if (CharmGUI.this.togglePredictionsButton.isSelected()) {
                    CharmGUI.this.displayState.setStateVariable("Prediction Plot Toggle", "on");
                } else {
                    CharmGUI.this.displayState.setStateVariable("Prediction Plot Toggle", "off");
                }
                CharmGUI.this.graphPanel.updateGraph();
            }
            if (command.equals("Export results")) {
                ExportResultsDialog exportResults = new ExportResultsDialog(CharmGUI.this, CharmGUI.this.displayState);
                exportResults.setLocationRelativeTo(CharmGUI.this.dummyPanel);
                exportResults.setModal(false);
                exportResults.setVisible(true);
                if (exportResults.getExitStatus() == 1) {
                    int printStatus;
                    String filename = exportResults.getFilename();
                    System.out.println(filename + "," + exportResults.getExportType());
                    if (exportResults.getExportType() != 0 && exportResults.getExportType() == 1 && (printStatus = CharmGUI.this.displayState.printVisiblePredictionWindows(filename + CharmGUI.EXTENSION)) < 0) {
                        JOptionPane.showMessageDialog(null, "Error writing to file!  Please try again.", "File Output Error", 0);
                    }
                }
            }
        }
    }

    private class ExportGenesListener
    implements ActionListener {
        private ExportGenesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileDialog = new JFileChooser(TMEV.getDataPath());
            int returnVal = fileDialog.showSaveDialog(CharmGUI.this);
            if (returnVal == 0) {
                String file = fileDialog.getSelectedFile().getAbsolutePath();
                CharmGUI.this.geneTable.writeGenesToFile(file + CharmGUI.EXTENSION);
            }
        }
    }

    private class GeneTableListener
    implements ListSelectionListener {
        private GeneTableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CGHClone[] selected = CharmGUI.this.geneTable.getSelectedGenes();
            if (selected != null) {
                CharmGUI.this.graphPanel.addGeneCircles(CharmGUI.this.displayState.getGraphSelectionChromosome(), CharmGUI.this.displayState.getGraphSelectionExperiment(), selected);
            }
        }
    }

    private class GeneListListener
    implements ListSelectionListener {
        private GeneListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            CGHClone[] selected = CharmGUI.this.genelist.getSelectedGenes();
            if (selected != null) {
                CharmGUI.this.graphPanel.addGeneCircles(CharmGUI.this.displayState.getGraphSelectionChromosome(), CharmGUI.this.displayState.getGraphSelectionExperiment(), selected);
            }
        }
    }
}

