/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CytoBandsModel;
import org.tigr.microarray.mev.cgh.CGHDataObj.CytoBand;

public class CytoBandsCanvas
extends JPanel {
    private Insets insets;
    private double unitLength;
    int rectWidth = 80;
    int origXOffset = 5;
    int origYOffset = 5;
    int rectSpacing = 5;
    int cytoBandWidth = 60;
    int fontSize = 12;
    CytoBandsModel model;
    int chromosomeIndex = 0;
    int rulerOffset;
    int cytoBandsOffset;

    public CytoBandsCanvas(Insets insets) {
        this.insets = insets;
        this.rulerOffset = insets.left + 20;
        this.cytoBandsOffset = this.rulerOffset + 10;
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(Color.black);
        this.setPreferredSize(new Dimension(this.cytoBandWidth + this.cytoBandsOffset + this.insets.right, 400));
        this.setMaximumSize(new Dimension(this.cytoBandWidth + this.cytoBandsOffset + this.insets.right, 10000));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        double width = d.width;
        double height = d.height;
        g2.setPaint(Color.white);
        g2.drawLine(this.rulerOffset, this.insets.top, this.rulerOffset, (int)height);
        g2.setFont(new Font("", 0, 10));
        for (int i = 0; i < this.model.getMaxPosition(); i += 10000000) {
            String pos = i + "";
            String trimmedPos = pos.length() < 6 ? pos : pos.substring(0, pos.length() - 6);
            g2.drawString(trimmedPos, this.insets.left, (int)((double)this.insets.top + (double)i * this.unitLength));
        }
        for (int bandIndex = 0; bandIndex < this.model.getNumCytoBands(); ++bandIndex) {
            CytoBand curCytoBand = this.model.getCytoBandAt(bandIndex);
            int bandStart = curCytoBand.getChromStart();
            int bandStop = curCytoBand.getChromEnd();
            int rectY = (int)((double)this.insets.top + (double)bandStart * this.unitLength);
            double dRectHeight = (double)(bandStop - bandStart) * this.unitLength;
            int rectHeight = dRectHeight < 1.0 && dRectHeight > 0.0 ? 1 : (int)dRectHeight;
            this.cytoBandsOffset = this.rulerOffset + 5;
            RoundRectangle2D.Float curRect = new RoundRectangle2D.Float(this.cytoBandsOffset, rectY, this.cytoBandWidth, rectHeight, 5.0f, 5.0f);
            Color curCytoColor = this.model.getDataPointColor(bandIndex);
            g2.setPaint(curCytoColor);
            g2.fill(curRect);
            if (curCytoColor == Color.darkGray) {
                g2.setColor(Color.white);
            } else {
                g2.setColor(Color.black);
            }
            int fontSize = 10;
            if (rectHeight < fontSize + 1) {
                fontSize = rectHeight - 1;
            }
            int stringY = rectY + rectHeight / 2 + fontSize / 2;
            g2.setFont(new Font("", 0, fontSize));
            g2.drawString(curCytoBand.getName(), this.cytoBandsOffset, stringY);
        }
        Object curCytoBand = null;
    }

    public CytoBandsModel getModel() {
        return this.model;
    }

    public void setModel(CytoBandsModel model) {
        this.model = model;
    }

    public int getChromosomeIndex() {
        return this.chromosomeIndex;
    }

    public void setChromosomeIndex(int chromosomeIndex) {
        this.chromosomeIndex = chromosomeIndex;
    }

    public void onSelected() {
        this.model.setChromosomeIndex(this.chromosomeIndex);
    }

    public double getUnitLength() {
        return this.unitLength;
    }

    public void setUnitLength(double unitLength) {
        this.unitLength = unitLength;
    }
}

