/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHAnnotationsModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHPositionGraphDataModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CytoBandsModel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphCombinedHeader;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphCombinedViewer;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphSeparatedViewer;
import org.tigr.microarray.mev.cgh.CGHListenerObj.IDataRegionSelectionListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHViewer;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class CGHPositionGraphViewer
extends JPanel
implements ActionListener,
ICGHViewer {
    IFramework framework;
    CGHPositionGraphCombinedViewer combinedViewer;
    CGHPositionGraphSeparatedViewer separatedViewer;
    ICGHViewer viewer;
    CGHPositionGraphDataModel positionGraphModel;

    public CGHPositionGraphViewer(IFramework framework, CGHPositionGraphCombinedHeader combinedHeader) {
        this.framework = framework;
        this.combinedViewer = new CGHPositionGraphCombinedViewer(framework, combinedHeader);
        this.separatedViewer = new CGHPositionGraphSeparatedViewer(framework);
        this.updateViewer(framework.getCghDisplayMenu().getDisplayType());
    }

    private void updateViewer(int viewerType) {
        if (viewerType == 0) {
            this.viewer = this.combinedViewer;
        } else if (viewerType == 1) {
            this.viewer = this.separatedViewer;
        }
    }

    public void setPositionGraphModel(CGHPositionGraphDataModel positionGraphModel) {
        this.positionGraphModel = positionGraphModel;
        this.combinedViewer.setPositionGraphModel(positionGraphModel);
        this.separatedViewer.setPositionGraphModel(positionGraphModel);
        this.onThresholdsChanged(this.framework.getCghDisplayMenu());
    }

    public void setAnnotationsModel(CGHAnnotationsModel annotationsModel) {
        this.combinedViewer.setAnnotationsModel(annotationsModel);
        this.separatedViewer.setAnnotationsModel(annotationsModel);
    }

    public void setCytoBandsModel(CytoBandsModel cytoBandsModel) {
        this.combinedViewer.setCytoBandsModel(cytoBandsModel);
        this.separatedViewer.setCytoBandsModel(cytoBandsModel);
    }

    public void setDrsListener(IDataRegionSelectionListener drsListener) {
        this.combinedViewer.setDrsListener(drsListener);
        this.separatedViewer.setDrsListener(drsListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public JComponent getContentComponent() {
        return this.viewer.getContentComponent();
    }

    public JComponent getHeaderComponent() {
        return this.viewer.getHeaderComponent();
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
        this.viewer.onDataChanged(data);
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.combinedViewer.onMenuChanged(menu);
        this.positionGraphModel.setMaxRatioScale(menu.getMaxRatioScale());
        this.positionGraphModel.setMinRatioScale(menu.getMinRatioScale());
        this.positionGraphModel.setNegColorImage(menu.getNegativeGradientImage());
        this.positionGraphModel.setPosColorImage(menu.getPositiveGradientImage());
    }

    public void onThresholdsChanged(ICGHDisplayMenu menu) {
    }

    public void onMenuChanged(ICGHDisplayMenu menu) {
        this.setBackground(menu.getCircleViewerBackgroundColor());
        this.updateViewer(menu.getDisplayType());
        this.viewer.onMenuChanged(menu);
    }

    public void onSelected(IFramework framework) {
        this.framework = framework;
        ICGHDisplayMenu cghMenu = this.framework.getCghDisplayMenu();
        IDisplayMenu menu = framework.getDisplayMenu();
        this.onMenuChanged(menu);
        this.onMenuChanged(cghMenu);
        this.viewer.onSelected(framework);
    }

    public void onCloneValuesChanged(ICGHCloneValueMenu menu) {
        this.viewer.onCloneValuesChanged(menu);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int id) {
    }

    public Expression getExpression() {
        return null;
    }
}

