/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHAnnotationsModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHPositionGraphDataModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CytoBandsModel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphSeparatedCanvas;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphSeparatedHeader;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CytoBandsCanvas;
import org.tigr.microarray.mev.cgh.CGHListenerObj.IDataRegionSelectionListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHViewer;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class CGHPositionGraphSeparatedViewer
extends JPanel
implements ActionListener,
ICGHViewer {
    IFramework framework;
    Insets insets = new Insets(10, 10, 10, 10);
    private BufferedImage negColorImage;
    private BufferedImage posColorImage;
    double unitLength;
    int elementWidth;
    int displayType;
    CGHPositionGraphSeparatedCanvas positionGraphLeft;
    CGHPositionGraphSeparatedCanvas positionGraphRight;
    CytoBandsCanvas cytoBandsCanvas;
    CGHPositionGraphSeparatedHeader header;
    CGHPositionGraphDataModel positionGraphModel;
    CytoBandsModel cytoBandsModel;
    CGHAnnotationsModel annotationsModel;

    public CGHPositionGraphSeparatedViewer(IFramework framework) {
        this.framework = framework;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 0));
        this.header = new CGHPositionGraphSeparatedHeader(this.insets, this);
        this.positionGraphLeft = new CGHPositionGraphSeparatedCanvas(this.insets, true, 1);
        this.positionGraphRight = new CGHPositionGraphSeparatedCanvas(this.insets);
        this.cytoBandsCanvas = new CytoBandsCanvas(this.insets);
        this.negColorImage = this.framework.getDisplayMenu().getNegativeGradientImage();
        this.posColorImage = this.framework.getDisplayMenu().getPositiveGradientImage();
        this.add(this.positionGraphLeft);
        this.add(this.cytoBandsCanvas);
        this.add(this.positionGraphRight);
    }

    @Override
    public void paint(Graphics g) {
        this.checkUpdateSize();
        this.header.updateSize();
        super.paint(g);
    }

    private void checkUpdateSize() {
        if (this.framework.getCghDisplayMenu().getUnitLength() == -1.0) {
            this.unitLength = this.calculateFitUnitLength();
            this.updateUnitLength(this.unitLength);
        }
        if ((double)this.framework.getCghDisplayMenu().getElementWidth() == -1.0) {
            this.elementWidth = this.calculateFitElementWidth();
            this.updateElementWidth(this.elementWidth);
        }
    }

    private double calculateFitUnitLength() {
        Rectangle rect = this.framework.getViewerBounds();
        double height = rect.getHeight();
        double maxVal = this.cytoBandsModel.getMaxPosition();
        double unitLength = (height -= (double)(this.insets.bottom + this.insets.top)) / maxVal;
        return unitLength;
    }

    private int calculateFitElementWidth() {
        int rectSpacing = 5;
        double viewerWidth = this.framework.getViewerBounds().getWidth() - this.cytoBandsCanvas.getPreferredSize().getWidth();
        int rectWidth = (int)(((viewerWidth /= 2.0) - (double)this.insets.left - (double)this.insets.right) / (double)this.positionGraphModel.getNumExperiments()) - rectSpacing;
        if (rectWidth > 80) {
            rectWidth = 80;
        }
        return rectWidth;
    }

    private void updateSize() {
        int posGraphWidth = this.positionGraphModel.getNumExperiments() * (this.elementWidth + 5) + this.insets.left + this.insets.right;
        int width = posGraphWidth * 2;
        width = (int)((double)width + this.cytoBandsCanvas.getPreferredSize().getWidth());
        int height = (int)((double)this.cytoBandsModel.getMaxPosition() * this.unitLength + (double)(this.insets.top + this.insets.bottom));
        this.positionGraphLeft.setSize(posGraphWidth, height);
        this.positionGraphLeft.setPreferredSize(new Dimension(posGraphWidth, height));
        this.positionGraphRight.setSize(posGraphWidth, height);
        this.positionGraphRight.setPreferredSize(new Dimension(posGraphWidth, height));
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
        this.repaint();
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onMenuChanged(ICGHDisplayMenu menu) {
        this.positionGraphLeft.setShowFlankingRegions(menu.isShowFlankingRegions());
        this.positionGraphRight.setShowFlankingRegions(menu.isShowFlankingRegions());
        this.unitLength = menu.getUnitLength() == -1.0 ? this.calculateFitUnitLength() : menu.getUnitLength();
        this.updateUnitLength(this.unitLength);
        this.elementWidth = (double)menu.getElementWidth() == -1.0 ? this.calculateFitElementWidth() : menu.getElementWidth();
        this.updateElementWidth(this.elementWidth);
        this.updateSize();
    }

    public void onSelected(IFramework framework) {
        this.cytoBandsCanvas.onSelected();
        this.framework = framework;
        ICGHDisplayMenu cghMenu = this.framework.getCghDisplayMenu();
        ICGHCloneValueMenu cloneValueMenu = this.framework.getCghCloneValueMenu();
        this.onMenuChanged(cghMenu);
        this.onCloneValuesChanged(cloneValueMenu);
    }

    public void setPositionGraphModel(CGHPositionGraphDataModel positionGraphModel) {
        this.positionGraphModel = positionGraphModel;
        this.positionGraphLeft.setModel(positionGraphModel);
        this.positionGraphRight.setModel(positionGraphModel);
        this.header.setModel(positionGraphModel);
        this.cytoBandsCanvas.setChromosomeIndex(positionGraphModel.getChromosomeIndex());
    }

    public void setAnnotationsModel(CGHAnnotationsModel annotationsModel) {
        this.annotationsModel = annotationsModel;
    }

    public CytoBandsModel getCytoBandsModel() {
        return this.cytoBandsModel;
    }

    public void setCytoBandsModel(CytoBandsModel cytoBandsModel) {
        this.cytoBandsModel = cytoBandsModel;
        this.cytoBandsCanvas.setModel(cytoBandsModel);
    }

    private void updateUnitLength(double unitLength) {
        this.positionGraphLeft.setUnitLength(unitLength);
        this.positionGraphRight.setUnitLength(unitLength);
        this.cytoBandsCanvas.setUnitLength(unitLength);
    }

    private void updateElementWidth(int elementWidth) {
        this.positionGraphLeft.setElementWidth(elementWidth);
        this.positionGraphRight.setElementWidth(elementWidth);
        this.header.setElementWidth(elementWidth);
    }

    public void setDrsListener(IDataRegionSelectionListener drsListener) {
        this.positionGraphLeft.setDrsListener(drsListener);
        this.positionGraphRight.setDrsListener(drsListener);
    }

    public void onThresholdsChanged(ICGHDisplayMenu menu) {
    }

    public CGHPositionGraphSeparatedCanvas getPositionGraphLeft() {
        return this.positionGraphLeft;
    }

    public void setPositionGraphLeft(CGHPositionGraphSeparatedCanvas positionGraphLeft) {
        this.positionGraphLeft = positionGraphLeft;
    }

    public CGHPositionGraphSeparatedCanvas getPositionGraphRight() {
        return this.positionGraphRight;
    }

    public void setPositionGraphRight(CGHPositionGraphSeparatedCanvas positionGraphRight) {
        this.positionGraphRight = positionGraphRight;
    }

    public CytoBandsCanvas getCytoBandsCanvas() {
        return this.cytoBandsCanvas;
    }

    public void setCytoBandsCanvas(CytoBandsCanvas cytoBandsCanvas) {
        this.cytoBandsCanvas = cytoBandsCanvas;
    }

    public void onCloneValuesChanged(ICGHCloneValueMenu menu) {
        this.positionGraphModel.onCloneValuesChanged(menu);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int id) {
    }

    public Expression getExpression() {
        return null;
    }
}

