/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphHeader;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphSeparatedViewer;

public class CGHPositionGraphSeparatedHeader
extends CGHPositionGraphHeader {
    CGHPositionGraphSeparatedViewer viewer;

    public CGHPositionGraphSeparatedHeader(Insets insets, CGHPositionGraphSeparatedViewer viewer) {
        super(insets);
        this.viewer = viewer;
    }

    @Override
    public void paint(Graphics g1D) {
        super.paint(g1D);
        if (this.model == null || this.model.getNumExperiments() == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)g1D;
        int width = this.model.getNumExperiments() * (this.elementWidth + this.rectSpacing) + this.elementWidth / 2 + this.insets.left;
        width *= 2;
        g.drawImage(this.model.getNegColorImage(), this.viewer.getWidth() / 2 - (width += this.viewer.getCytoBandsCanvas().getWidth()) / 2, 0, (int)((float)width / 2.0f), 15, null);
        g.drawImage(this.model.getPosColorImage(), this.viewer.getWidth() / 2, 0, (int)((double)width / 2.0), 15, null);
        FontMetrics hfm = g.getFontMetrics();
        int descent = hfm.getDescent();
        int fHeight = hfm.getHeight();
        g.setColor(Color.white);
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int textWidth = hfm.stringWidth(String.valueOf(this.model.getMinRatioScale()));
        g.drawString(String.valueOf(this.model.getMinRatioScale()), this.viewer.getWidth() / 2 - width / 2 - textWidth, 15 + fHeight);
        textWidth = hfm.stringWidth("0:0");
        g.drawString("0:0", this.viewer.getWidth() / 2, 15 + fHeight);
        textWidth = hfm.stringWidth(String.valueOf(this.maxValue));
        g.drawString(String.valueOf(this.model.getMaxRatioScale()), this.viewer.getWidth() / 2 + width / 2, 15 + fHeight);
        this.drawColumnHeaders(g);
    }

    private void drawColumnHeaders(Graphics2D g) {
        int xCoord;
        String name;
        int exp;
        int numExperiments = this.model.getNumExperiments();
        int rectSpacing = 5;
        if (numExperiments == 0) {
            return;
        }
        FontMetrics hfm = g.getFontMetrics();
        int descent = hfm.getDescent();
        g.rotate(-1.5707963267948966);
        for (exp = 0; exp < numExperiments; ++exp) {
            name = this.model.getExperimentName(this.model.getExperimentIndexAt(exp));
            xCoord = exp * (this.elementWidth + rectSpacing) + this.elementWidth / 2 + this.insets.left;
            g.drawString(name, this.insets.bottom - this.getSize().height + 5, xCoord += this.viewer.getPositionGraphLeft().getWidth() + this.viewer.getCytoBandsCanvas().getWidth());
        }
        for (exp = 0; exp < numExperiments; ++exp) {
            name = this.model.getExperimentName(this.model.getExperimentIndexAt(exp));
            xCoord = (this.model.getNumExperiments() - exp - 1) * (this.elementWidth + rectSpacing) + this.elementWidth / 2 + this.insets.left;
            xCoord = this.viewer.getPositionGraphLeft().getWidth() - xCoord;
            g.drawString(name, this.insets.bottom - this.getSize().height + 5, xCoord);
        }
        g.rotate(1.5707963267948966);
    }
}

