/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHDataRegionInfo;
import org.tigr.microarray.mev.cgh.CGHDataObj.FlankingRegion;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphCanvas;
import org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil.PositionDataRegionClickedPopup;

public class CGHPositionGraphSeparatedCanvas
extends CGHPositionGraphCanvas
implements ActionListener {
    PositionDataRegionClickedPopup regionClickedPopup = new PositionDataRegionClickedPopup(this);
    public static final int AMPLIFICATIONS = 0;
    public static final int DELETIONS = 1;
    boolean isReversed = false;
    private int flankingRegionType = 0;

    public CGHPositionGraphSeparatedCanvas(Insets insets) {
        super(insets);
    }

    public CGHPositionGraphSeparatedCanvas(Insets insets, boolean isReversed, int flankingRegionType) {
        super(insets);
        this.flankingRegionType = flankingRegionType;
        this.isReversed = isReversed;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2D = (Graphics2D)g;
        this.drawColumns(g2D);
    }

    private void drawColumns(Graphics2D g) {
        for (int column = 0; column < this.model.getNumExperiments(); ++column) {
            this.drawColumn(g, this.model.getExperimentIndexAt(column));
        }
    }

    private void drawColumn(Graphics2D g, int column) {
        int columnIndex = this.model.getExperimentIndexAt(column);
        for (int flankingRegion = 0; flankingRegion < this.model.getNumFlankingRegions(columnIndex); ++flankingRegion) {
            this.drawFlankingRegion(g, flankingRegion, column, columnIndex);
        }
    }

    private void drawFlankingRegion(Graphics2D g2, int frIndex, int column, int columnIndex) {
        FlankingRegion fr = this.model.getFlankingRegionAt(columnIndex, frIndex);
        if (this.flankingRegionType == 1 && fr.getType() == 0) {
            return;
        }
        if (this.flankingRegionType == 0 && fr.getType() == 1) {
            return;
        }
        int frStart = fr.getStart();
        int frStop = fr.getStop();
        Dimension d = this.getSize();
        double width = d.width;
        double height = d.height - 50;
        double maxVal = this.model.getMaxClonePosition();
        int rectX = this.insets.left + column * (this.elementWidth + this.rectSpacing);
        if (this.isReversed) {
            rectX = this.getWidth() - this.elementWidth - this.insets.right - (this.model.getNumExperiments() - column - 1) * (this.elementWidth + this.rectSpacing);
        }
        int rectY = (int)((double)this.insets.top + (double)frStart * this.unitLength);
        double dRectHeight = (double)(frStop - frStart) * this.unitLength;
        int rectHeight = dRectHeight < 1.0 && dRectHeight > 0.0 ? 1 : (int)dRectHeight;
        Rectangle curRect = new Rectangle(rectX, rectY, this.elementWidth, rectHeight);
        g2.setPaint(this.model.getFlankingRegionColor(columnIndex, frIndex));
        g2.fill(curRect);
    }

    public boolean isIsReversed() {
        return this.isReversed;
    }

    public void setIsReversed(boolean isReversed) {
        this.isReversed = isReversed;
    }

    public int getFlankingRegionType() {
        return this.flankingRegionType;
    }

    public void setFlankingRegionType(int flankingRegionType) {
        this.flankingRegionType = flankingRegionType;
    }

    @Override
    protected void formMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            Point point = evt.getPoint();
            int selectedColumn = this.getSelectedColumn(point.x);
            int selectedPosition = this.getSelectedPosition(point.y);
            if (selectedColumn == -1 || selectedPosition < 0 || selectedPosition > this.model.getMaxClonePosition()) {
                this.selectedDataRegion = null;
                return;
            }
            int experimentIndex = this.model.getExperimentIndexAt(selectedColumn);
            this.selectedDataRegion = this.getFlankingRegionAtLocation(experimentIndex, selectedPosition);
            if (this.selectedDataRegion != null) {
                this.regionClickedPopup.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private int getSelectedColumn(int xCoord) {
        if (!this.isReversed) {
            for (int column = 0; column < this.model.getNumExperiments(); ++column) {
                int rectX = this.insets.left + column * (this.elementWidth + this.rectSpacing);
                if (xCoord < rectX || xCoord > rectX + this.elementWidth) continue;
                return column;
            }
        } else {
            for (int column = 0; column < this.model.getNumExperiments(); ++column) {
                int rectX = this.getWidth() - this.elementWidth - this.insets.right - (this.model.getNumExperiments() - column - 1) * (this.elementWidth + this.rectSpacing);
                if (xCoord < rectX || xCoord > rectX + this.elementWidth) continue;
                return column;
            }
        }
        return -1;
    }

    private int getSelectedPosition(int yCoord) {
        return (int)((double)(yCoord - this.insets.top) / this.unitLength);
    }

    private CGHDataRegionInfo getFlankingRegionAtLocation(int experimentIndex, int selectedPosition) {
        int selectedFrIndex = -1;
        for (int i = 0; i < this.model.getNumFlankingRegions(experimentIndex); ++i) {
            FlankingRegion fr = this.model.getFlankingRegionAt(experimentIndex, i);
            if (selectedPosition < fr.getStart() || selectedPosition > fr.getStop() || fr.getType() != this.flankingRegionType) continue;
            selectedFrIndex = i;
        }
        if (selectedFrIndex != -1) {
            FlankingRegion fr = this.model.getFlankingRegionAt(experimentIndex, selectedFrIndex);
            return new CGHDataRegionInfo(fr, experimentIndex);
        }
        return null;
    }
}

