/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHPositionGraphDataModel;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;

public class CGHPositionGraphHeader
extends JPanel {
    protected Insets insets;
    protected int contentWidth;
    protected int elementWidth;
    protected boolean isAntiAliasing = true;
    protected boolean isTracing = false;
    protected int tracespace;
    protected final int RECT_HEIGHT = 15;
    BufferedImage negColorImage;
    BufferedImage posColorImage;
    protected float maxValue;
    protected float minValue;
    CGHPositionGraphDataModel model;
    int rectSpacing = 5;

    public CGHPositionGraphHeader(Insets insets) {
        this.setBackground(Color.black);
        this.setSize(200, 200);
        this.setPreferredSize(new Dimension(200, 200));
        this.insets = insets;
        this.maxValue = 3.0f;
        this.minValue = 0.0f;
    }

    public void setAntiAliasing(boolean isAntiAliasing) {
        this.isAntiAliasing = isAntiAliasing;
    }

    void setElementWidth(int width) {
        this.elementWidth = width;
        this.setFontSize(width);
        this.updateSize();
        this.repaint();
    }

    void setContentWidth(int width) {
        this.contentWidth = width;
        this.repaint();
    }

    public void setMinAndMaxRatios(float min, float max) {
        this.minValue = min;
        this.maxValue = max;
        this.repaint();
    }

    void setTracing(boolean isTracing) {
        this.isTracing = isTracing;
    }

    private int getSpacing() {
        return this.rectSpacing;
    }

    private void setFontSize(int width) {
        if (width > 12) {
            width = 12;
        }
        this.setFont(new Font("monospaced", 0, width));
    }

    void updateSize() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics hfm = g.getFontMetrics();
        int maxHeight = 0;
        int size = this.model.getNumExperiments();
        for (int feature = 0; feature < size; ++feature) {
            String name = this.model.getExperimentName(feature);
            maxHeight = name == null ? 1 : Math.max(maxHeight, hfm.stringWidth(name));
        }
        this.setSize(this.contentWidth, maxHeight + 10 + this.RECT_HEIGHT + hfm.getHeight());
        this.setPreferredSize(new Dimension(this.contentWidth, maxHeight + 10 + this.RECT_HEIGHT + hfm.getHeight()));
    }

    public CGHPositionGraphDataModel getModel() {
        return this.model;
    }

    public void setModel(CGHPositionGraphDataModel model) {
        this.model = model;
        this.negColorImage = model.getNegColorImage();
        this.posColorImage = model.getPosColorImage();
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.model.setNegColorImage(menu.getNegativeGradientImage());
        this.model.setPosColorImage(menu.getPositiveGradientImage());
        this.setMinAndMaxRatios(menu.getMinRatioScale(), menu.getMaxRatioScale());
    }
}

