/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHAnnotationsModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHPositionGraphDataModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CytoBandsModel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphCombinedCanvas;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphCombinedHeader;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CytoBandsCanvas;
import org.tigr.microarray.mev.cgh.CGHListenerObj.IDataRegionSelectionListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHViewer;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class CGHPositionGraphCombinedViewer
extends JPanel
implements ActionListener,
ICGHViewer {
    IFramework framework;
    IData data;
    Insets insets = new Insets(10, 10, 10, 10);
    private BufferedImage negColorImage;
    private BufferedImage posColorImage;
    double unitLength;
    int elementWidth;
    int annotationsWidth = 40;
    int displayType;
    CGHPositionGraphCombinedCanvas positionGraph;
    CytoBandsCanvas cytoBandsCanvas;
    CGHPositionGraphCombinedHeader header;
    CGHPositionGraphDataModel positionGraphModel;
    CytoBandsModel cytoBandsModel;

    public CGHPositionGraphCombinedViewer(IFramework framework, CGHPositionGraphCombinedHeader header) {
        this.framework = framework;
        this.header = header;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.positionGraph = new CGHPositionGraphCombinedCanvas(this.insets);
        this.cytoBandsCanvas = new CytoBandsCanvas(new Insets(this.insets.top, 0, this.insets.bottom, 5));
        this.add((Component)this.positionGraph, "Center");
        this.add((Component)this.cytoBandsCanvas, "West");
        this.positionGraph.setData(this.framework.getData());
    }

    @Override
    public void paint(Graphics g) {
        this.checkUpdateSize();
        this.header.updateSize();
        this.header.repaint();
        super.paint(g);
    }

    private void checkUpdateSize() {
        if (this.framework.getCghDisplayMenu().getUnitLength() == -1.0) {
            this.unitLength = this.calculateFitUnitLength();
            this.updateUnitLength(this.unitLength);
        }
        if ((double)this.framework.getCghDisplayMenu().getElementWidth() == -1.0) {
            this.elementWidth = this.calculateFitElementWidth();
            this.updateElementWidth(this.elementWidth);
        }
    }

    private double calculateFitUnitLength() {
        Rectangle rect = this.framework.getViewerBounds();
        double height = rect.getHeight();
        double maxVal = this.cytoBandsModel.getMaxPosition();
        double unitLength = (height -= (double)(this.insets.bottom + this.insets.top)) / maxVal;
        return unitLength;
    }

    private int calculateFitElementWidth() {
        int rectSpacing = 5;
        double viewerWidth = this.framework.getViewerBounds().getWidth() - this.cytoBandsCanvas.getPreferredSize().getWidth() - (double)this.annotationsWidth;
        int rectWidth = (int)((viewerWidth - (double)this.insets.left - (double)this.insets.right) / (double)this.positionGraphModel.getNumExperiments()) - rectSpacing;
        if (rectWidth > 80) {
            rectWidth = 80;
        }
        return rectWidth;
    }

    private void updateSize() {
        int width = this.positionGraphModel.getNumExperiments() * (this.elementWidth + 5) + this.insets.left + this.insets.right;
        width = (int)((double)width + this.cytoBandsCanvas.getPreferredSize().getWidth());
        int height = (int)((double)this.cytoBandsModel.getMaxPosition() * this.unitLength + (double)(this.insets.top + this.insets.bottom));
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
        this.data = data;
        this.updateSize();
        this.header.setContentWidth(this.getSize().width);
        this.header.updateSize();
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.header.onMenuChanged(menu);
    }

    public void onMenuChanged(ICGHDisplayMenu menu) {
        this.positionGraph.setShowFlankingRegions(menu.isShowFlankingRegions());
        this.unitLength = menu.getUnitLength() == -1.0 ? this.calculateFitUnitLength() : menu.getUnitLength();
        this.updateUnitLength(this.unitLength);
        this.elementWidth = (double)menu.getElementWidth() == -1.0 ? this.calculateFitElementWidth() : menu.getElementWidth();
        this.updateElementWidth(this.elementWidth);
        this.updateSize();
        Insets headerInsets = new Insets(0, (int)this.cytoBandsCanvas.getPreferredSize().getWidth() + this.insets.left, 0, 0);
        this.header.setInsets(headerInsets);
        this.header.setElementWidth(this.elementWidth);
        this.header.setContentWidth(this.getSize().width);
        this.updateSize();
        this.header.updateSize();
        this.header.repaint();
    }

    public void onSelected(IFramework framework) {
        this.cytoBandsCanvas.onSelected();
        this.framework = framework;
        ICGHDisplayMenu cghMenu = this.framework.getCghDisplayMenu();
        ICGHCloneValueMenu cloneValueMenu = this.framework.getCghCloneValueMenu();
        this.onMenuChanged(cghMenu);
        this.onDataChanged(this.framework.getData());
        this.onCloneValuesChanged(cloneValueMenu);
    }

    public CGHPositionGraphDataModel getPositionGraphModel() {
        return this.positionGraphModel;
    }

    public void setPositionGraphModel(CGHPositionGraphDataModel positionGraphModel) {
        this.positionGraphModel = positionGraphModel;
        positionGraphModel.setNegColorImage(this.framework.getDisplayMenu().getNegativeGradientImage());
        positionGraphModel.setPosColorImage(this.framework.getDisplayMenu().getPositiveGradientImage());
        this.header.setModel(positionGraphModel);
        this.positionGraph.setModel(positionGraphModel);
        this.cytoBandsCanvas.setChromosomeIndex(positionGraphModel.getChromosomeIndex());
    }

    public void setAnnotationsModel(CGHAnnotationsModel annotationsModel) {
        this.positionGraph.setAnnotationsModel(annotationsModel);
    }

    public CytoBandsModel getCytoBandsModel() {
        return this.cytoBandsModel;
    }

    public void setCytoBandsModel(CytoBandsModel cytoBandsModel) {
        this.cytoBandsModel = cytoBandsModel;
        this.cytoBandsCanvas.setModel(cytoBandsModel);
    }

    private void updateUnitLength(double unitLength) {
        this.positionGraph.setUnitLength(unitLength);
        this.cytoBandsCanvas.setUnitLength(unitLength);
    }

    private void updateElementWidth(int elementWidth) {
        this.positionGraph.setElementWidth(elementWidth);
        this.header.setElementWidth(elementWidth);
    }

    public void setDrsListener(IDataRegionSelectionListener drsListener) {
        this.positionGraph.setDrsListener(drsListener);
    }

    public void onThresholdsChanged(ICGHDisplayMenu menu) {
    }

    public void onCloneValuesChanged(ICGHCloneValueMenu menu) {
        this.positionGraphModel.onCloneValuesChanged(menu);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int id) {
    }

    public Expression getExpression() {
        return null;
    }
}

