/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphHeader;

public class CGHPositionGraphCombinedHeader
extends CGHPositionGraphHeader {
    public CGHPositionGraphCombinedHeader(Insets insets) {
        super(insets);
    }

    @Override
    public void paint(Graphics g1D) {
        super.paint(g1D);
        if (this.model == null || this.model.getNumExperiments() == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)g1D;
        int width = !this.isTracing ? this.model.getNumExperiments() * this.elementWidth : (this.model.getNumExperiments() - 1) * (this.elementWidth + this.rectSpacing) + this.elementWidth;
        width = this.model.getNumExperiments() * (this.elementWidth + this.rectSpacing);
        g.drawImage(this.model.getNegColorImage(), this.insets.left, 0, (int)((float)width / 2.0f), 15, null);
        g.drawImage(this.model.getPosColorImage(), (int)((float)width / 2.0f) + this.insets.left, 0, (int)((double)width / 2.0), 15, null);
        FontMetrics hfm = g.getFontMetrics();
        int descent = hfm.getDescent();
        int fHeight = hfm.getHeight();
        g.setColor(Color.white);
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.drawString(String.valueOf(this.minValue), this.insets.left, 15 + fHeight);
        int textWidth = hfm.stringWidth("0:0");
        g.drawString("0:0", (int)((float)width / 2.0f) - textWidth / 2 + this.insets.left, 15 + fHeight);
        textWidth = hfm.stringWidth(String.valueOf(this.maxValue));
        g.drawString(String.valueOf(this.maxValue), width - textWidth + this.insets.left, 15 + fHeight);
        this.drawColumnHeaders(g);
    }

    private void drawColumnHeaders(Graphics2D g) {
        int size = this.model.getNumExperiments();
        if (size == 0) {
            return;
        }
        FontMetrics hfm = g.getFontMetrics();
        int descent = hfm.getDescent();
        g.rotate(-1.5707963267948966);
        for (int feature = 0; feature < size; ++feature) {
            String name = this.model.getExperimentName(this.model.getExperimentIndexAt(feature));
            int xCoord = feature * (this.elementWidth + this.rectSpacing) + this.elementWidth / 2 + this.insets.left;
            g.drawString(name, this.insets.bottom - this.getSize().height + 5, xCoord += descent);
        }
        g.rotate(1.5707963267948966);
    }
}

