/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHDataRegionInfo;
import org.tigr.microarray.mev.cgh.CGHDataObj.FlankingRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph.CGHPositionGraphCanvas;
import org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil.PositionDataRegionClickedPopup;
import org.tigr.microarray.mev.cluster.gui.IData;

public class CGHPositionGraphCombinedCanvas
extends CGHPositionGraphCanvas
implements ActionListener {
    PositionDataRegionClickedPopup regionClickedPopup = new PositionDataRegionClickedPopup(this);
    IData data;
    int annotationsRectWidth = 10;
    public static final int COLUMN_NOT_FOUND = -1;
    public static final int ANNOTATIONS_COLUMN = -2;

    public CGHPositionGraphCombinedCanvas(Insets insets) {
        super(insets);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2D = (Graphics2D)g;
        this.drawColumns(g2D);
    }

    private void drawColumns(Graphics2D g) {
        for (int column = 0; column < this.model.getNumExperiments(); ++column) {
            int columnIndex = this.model.getExperimentIndexAt(column);
            this.drawColumn(g, columnIndex);
        }
        this.drawAnnotations(g);
    }

    private void drawColumn(Graphics2D g, int column) {
        int columnIndex = this.model.getExperimentIndexAt(column);
        for (int row = 0; row < this.model.getNumElements(); ++row) {
            this.drawSlideDataElement(g, row, column, columnIndex);
        }
        if (this.showFlankingRegions) {
            for (int flankingRegion = 0; flankingRegion < this.model.getNumFlankingRegions(columnIndex); ++flankingRegion) {
                this.drawFlankingRegion(g, flankingRegion, column, columnIndex);
            }
        }
    }

    private void drawSlideDataElement(Graphics2D g2, int row, int column, int columnIndex) {
        int cloneStart = this.model.getStart(row);
        int cloneStop = this.model.getStop(row);
        Dimension d = this.getSize();
        double width = d.width;
        double height = d.height - 50;
        double maxVal = this.model.getMaxClonePosition();
        int rectX = this.insets.left + column * (this.elementWidth + this.rectSpacing);
        int rectY = (int)((double)this.insets.top + (double)cloneStart * this.unitLength);
        double dRectHeight = (double)(cloneStop - cloneStart) * this.unitLength;
        int rectHeight = dRectHeight < 1.0 && dRectHeight > 0.0 ? 1 : (int)dRectHeight;
        Rectangle curRect = new Rectangle(rectX, rectY, this.elementWidth, rectHeight);
        g2.setPaint(this.model.getDataPointColor(row, columnIndex));
        g2.fill(curRect);
    }

    private void drawFlankingRegion(Graphics2D g2, int frIndex, int column, int columnIndex) {
        FlankingRegion fr = this.model.getFlankingRegionAt(columnIndex, frIndex);
        int frStart = fr.getStart();
        int frStop = fr.getStop();
        Dimension d = this.getSize();
        double width = d.width;
        double height = d.height - 50;
        double maxVal = this.model.getMaxClonePosition();
        int rectX = this.insets.left + column * (this.elementWidth + this.rectSpacing);
        int rectY = (int)((double)this.insets.top + (double)frStart * this.unitLength);
        double dRectHeight = (double)(frStop - frStart) * this.unitLength;
        int rectHeight = dRectHeight < 1.0 && dRectHeight > 0.0 ? 1 : (int)dRectHeight;
        Rectangle curRect = new Rectangle(rectX, rectY, this.elementWidth, rectHeight);
        g2.setPaint(this.model.getFlankingRegionColor(columnIndex, frIndex));
        g2.fill(curRect);
    }

    private void drawAnnotations(Graphics2D g2) {
        int annotationsX = this.getAnnotationsXCoord();
        int fontSize = 8;
        for (int i = 0; i < this.annotationsModel.getNumAnnotations(); ++i) {
            ICGHDataRegion dataRegion = this.annotationsModel.getAnnotationAt(i);
            String name = dataRegion.getName();
            int start = dataRegion.getStart();
            int stop = dataRegion.getStop();
            int rectY = (int)((double)this.insets.top + (double)start * this.unitLength);
            double dRectHeight = (double)(stop - start) * this.unitLength;
            int rectHeight = dRectHeight < 1.0 && dRectHeight > 0.0 ? 1 : (int)dRectHeight;
            Rectangle curRect = new Rectangle(annotationsX, rectY, this.annotationsRectWidth, rectHeight);
            g2.setPaint(this.annotationsModel.getAnnotationColorAt(i));
            g2.fill(curRect);
            g2.setFont(new Font("", 0, fontSize));
            g2.drawString(name, annotationsX + this.annotationsRectWidth + 5, rectY);
        }
    }

    @Override
    protected void formMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            Point point = evt.getPoint();
            int selectedColumn = this.getSelectedColumn(point.x);
            int selectedPosition = this.getSelectedPosition(point.y);
            if (selectedColumn == -1 || selectedPosition < 0 || selectedPosition > this.model.getMaxClonePosition()) {
                this.selectedDataRegion = null;
                return;
            }
            if (selectedColumn == -2) {
                this.selectedDataRegion = this.getAnnotationAtLocation(selectedPosition);
            } else {
                int experimentIndex = this.model.getExperimentIndexAt(selectedColumn);
                if (this.isShowFlankingRegions()) {
                    this.selectedDataRegion = this.getFlankingRegionAtLocation(experimentIndex, selectedPosition);
                }
                if (!this.isShowFlankingRegions() || this.selectedDataRegion == null) {
                    this.selectedDataRegion = this.getCloneAtLocation(experimentIndex, selectedPosition);
                }
            }
            if (this.selectedDataRegion != null) {
                this.regionClickedPopup.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private CGHDataRegionInfo getCloneAtLocation(int experimentIndex, int selectedPosition) {
        int selectedRow = -1;
        for (int i = 0; i < this.model.getNumElements(); ++i) {
            if (selectedPosition < this.model.getStart(i) || selectedPosition > this.model.getStop(i)) continue;
            selectedRow = i;
        }
        if (selectedRow != -1) {
            CGHClone selectedClone = this.model.getCloneAt(selectedRow);
            return new CGHDataRegionInfo(selectedClone, experimentIndex);
        }
        return null;
    }

    private CGHDataRegionInfo getFlankingRegionAtLocation(int experimentIndex, int selectedPosition) {
        int selectedFrIndex = -1;
        for (int i = 0; i < this.model.getNumFlankingRegions(experimentIndex); ++i) {
            FlankingRegion fr = this.model.getFlankingRegionAt(experimentIndex, i);
            if (selectedPosition < fr.getStart() || selectedPosition > fr.getStop()) continue;
            selectedFrIndex = i;
        }
        if (selectedFrIndex != -1) {
            FlankingRegion fr = this.model.getFlankingRegionAt(experimentIndex, selectedFrIndex);
            return new CGHDataRegionInfo(fr, experimentIndex);
        }
        return null;
    }

    private CGHDataRegionInfo getAnnotationAtLocation(int selectedPosition) {
        int selectedAnnotationIndex = -1;
        for (int i = 0; i < this.annotationsModel.getNumAnnotations(); ++i) {
            ICGHDataRegion dataRegion = this.annotationsModel.getAnnotationAt(i);
            if (selectedPosition < dataRegion.getStart() || selectedPosition > dataRegion.getStop()) continue;
            return new CGHDataRegionInfo(dataRegion, -1);
        }
        return null;
    }

    private int getSelectedColumn(int xCoord) {
        for (int column = 0; column < this.model.getNumExperiments(); ++column) {
            int rectX = this.insets.left + column * (this.elementWidth + this.rectSpacing);
            if (xCoord < rectX || xCoord > rectX + this.elementWidth) continue;
            return column;
        }
        int annotationsX = this.getAnnotationsXCoord();
        if (xCoord >= annotationsX && xCoord <= annotationsX + this.annotationsRectWidth) {
            return -2;
        }
        return -1;
    }

    private int getAnnotationsXCoord() {
        return this.insets.left + this.model.getNumExperiments() * (this.elementWidth + this.rectSpacing);
    }

    private int getSelectedPosition(int yCoord) {
        return (int)((double)(yCoord - this.insets.top) / this.unitLength);
    }

    public IData getData() {
        return this.data;
    }

    public void setData(IData data) {
        this.data = data;
    }
}

