/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHPositionGraph;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHAnnotationsModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHPositionGraphDataModel;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHDataRegionInfo;
import org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil.GenomeBrowserLauncher;
import org.tigr.microarray.mev.cgh.CGHListenerObj.IDataRegionSelectionListener;

public abstract class CGHPositionGraphCanvas
extends JPanel {
    Insets insets;
    CGHPositionGraphDataModel model;
    CGHAnnotationsModel annotationsModel;
    IDataRegionSelectionListener drsListener;
    CGHDataRegionInfo selectedDataRegion = null;
    boolean showFlankingRegions;
    int elementWidth = 40;
    int rectSpacing = 5;
    double unitLength;

    public CGHPositionGraphCanvas(Insets insets) {
        this.setBackground(Color.black);
        this.insets = insets;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CGHPositionGraphCanvas.this.formMouseClicked(evt);
            }
        });
    }

    protected abstract void formMouseClicked(MouseEvent var1);

    public CGHPositionGraphDataModel getModel() {
        return this.model;
    }

    public void setModel(CGHPositionGraphDataModel model) {
        this.model = model;
    }

    public boolean isShowFlankingRegions() {
        return this.showFlankingRegions;
    }

    public void setShowFlankingRegions(boolean showFlankingRegions) {
        this.showFlankingRegions = showFlankingRegions;
    }

    public double getUnitLength() {
        return this.unitLength;
    }

    public void setUnitLength(double unitLength) {
        this.unitLength = unitLength;
    }

    public int getElementWidth() {
        return this.elementWidth;
    }

    public void setElementWidth(int elementWidth) {
        this.elementWidth = elementWidth;
    }

    public IDataRegionSelectionListener getDrsListener() {
        return this.drsListener;
    }

    public void setDrsListener(IDataRegionSelectionListener drsListener) {
        this.drsListener = drsListener;
    }

    public CGHAnnotationsModel getAnnotationsModel() {
        return this.annotationsModel;
    }

    public void setAnnotationsModel(CGHAnnotationsModel annotationsModel) {
        this.annotationsModel = annotationsModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem item = (JMenuItem)actionEvent.getSource();
        if (this.selectedDataRegion != null) {
            if ("Show Genes in Region".equals(item.getActionCommand())) {
                this.drsListener.onShowGenes(new EventObject(this.selectedDataRegion));
            } else if ("Show Browser".equals(item.getActionCommand())) {
                this.drsListener.onShowBrowser(new EventObject(this.selectedDataRegion));
            } else if ("Display Data Values".equals(item.getActionCommand())) {
                this.drsListener.onDisplayDataValues(new EventObject(this.selectedDataRegion));
            } else if ("Launch Ensembl".equals(item.getActionCommand())) {
                GenomeBrowserLauncher.launchEnsembl(this.selectedDataRegion.getDataRegion(), this.model.getCGHSpecies());
            } else if ("Launch Golden Path".equals(item.getActionCommand())) {
                GenomeBrowserLauncher.launchGoldenPath(this.selectedDataRegion.getDataRegion(), this.model.getCGHSpecies());
            } else if ("Launch NCBI Viewer".equals(item.getActionCommand())) {
                GenomeBrowserLauncher.launchNCBIMapViewer(this.selectedDataRegion.getDataRegion(), this.model.getCGHSpecies());
            }
        }
    }
}

