/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cluster.gui.IData;

public class CGHDisplayOrderChanger
extends JDialog {
    DisplayOrderObj[] dataObjs;
    int[] indicesOrder;
    IData data;
    boolean cancel;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JButton btnMoveDown;
    private JPanel jPanel3;
    private JButton btnMoveUp;
    private JPanel jPanel2;
    private JList lstData;
    private JPanel jPanel1;
    private JButton btnOk;
    private JButton btnCancel;

    public CGHDisplayOrderChanger(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public CGHDisplayOrderChanger(IData data, Frame parent, boolean modal) {
        super(parent, modal);
        this.cancel = false;
        this.data = data;
        this.initComponents();
        this.lstData.setModel(new DefaultListModel());
        this.data = data;
        this.indicesOrder = data.getSamplesOrder();
        for (int i = 0; i < this.indicesOrder.length; ++i) {
            ((DefaultListModel)this.lstData.getModel()).addElement(data.getSampleName(this.indicesOrder[i]));
        }
        this.setSize(400, 400);
    }

    private void initializeIndices() {
        this.indicesOrder = new int[this.data.getFeaturesCount()];
        int[] experimentIndices = this.data.getSamplesOrder();
        for (int i = 0; i < this.data.getFeaturesCount(); ++i) {
            this.indicesOrder[experimentIndices[i]] = i;
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstData = new JList();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.btnMoveUp = new JButton();
        this.btnMoveDown = new JButton();
        this.jPanel4 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CGHDisplayOrderChanger.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.lstData);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.btnMoveUp.setText("Up");
        this.btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHDisplayOrderChanger.this.btnMoveUpActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.btnMoveUp);
        this.btnMoveDown.setText("Down");
        this.btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHDisplayOrderChanger.this.btnMoveDownActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.btnMoveDown);
        this.jPanel2.add(this.jPanel3);
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHDisplayOrderChanger.this.btnOkActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnOk);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHDisplayOrderChanger.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.btnCancel);
        this.jPanel2.add(this.jPanel4);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void btnMoveDownActionPerformed(ActionEvent evt) {
        int selectedIndex = this.lstData.getSelectedIndex();
        if (selectedIndex < this.lstData.getModel().getSize() - 1) {
            Object obj = ((DefaultListModel)this.lstData.getModel()).remove(selectedIndex);
            ((DefaultListModel)this.lstData.getModel()).insertElementAt(obj, selectedIndex + 1);
            this.lstData.setSelectedIndex(selectedIndex + 1);
            int tmp = this.indicesOrder[selectedIndex];
            this.indicesOrder[selectedIndex] = this.indicesOrder[selectedIndex + 1];
            this.indicesOrder[selectedIndex + 1] = tmp;
        }
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.dispose();
    }

    private void btnMoveUpActionPerformed(ActionEvent evt) {
        int selectedIndex = this.lstData.getSelectedIndex();
        if (selectedIndex > 0) {
            Object obj = ((DefaultListModel)this.lstData.getModel()).remove(selectedIndex);
            ((DefaultListModel)this.lstData.getModel()).insertElementAt(obj, selectedIndex - 1);
            this.lstData.setSelectedIndex(selectedIndex - 1);
            int tmp = this.indicesOrder[selectedIndex];
            this.indicesOrder[selectedIndex] = this.indicesOrder[selectedIndex - 1];
            this.indicesOrder[selectedIndex - 1] = tmp;
        }
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public int[] getIndicesOrder() {
        this.generateIndicesOrder();
        return this.indicesOrder;
    }

    private void generateIndicesOrder() {
        this.indicesOrder = new int[this.dataObjs.length];
        for (int i = 0; i < this.indicesOrder.length; ++i) {
            this.indicesOrder[((DisplayOrderObj)this.lstData.getModel().getElementAt((int)i)).getOrigIndex()] = i;
        }
    }

    public void setIndicesOrder(int[] indicesOrder) {
        this.indicesOrder = indicesOrder;
    }

    private class DisplayOrderObj {
        Object value;
        int origIndex;

        DisplayOrderObj(Object value, int origIndex) {
            this.value = value;
            this.origIndex = origIndex;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public int getOrigIndex() {
            return this.origIndex;
        }

        public void setOrigIndex(int origIndex) {
            this.origIndex = origIndex;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

