/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHDataRegionInfo;
import org.tigr.microarray.mev.cgh.CGHDataObj.FlankingRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil.GuiUtil;
import org.tigr.microarray.mev.cluster.gui.IData;

public class CGHDataValuesDisplay
extends JDialog {
    CGHDataRegionInfo dataRegionInfo;
    IData data;
    private JScrollPane jScrollPane1;
    private JEditorPane pneInfo;

    public CGHDataValuesDisplay(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Data Region Values");
        this.pneInfo.setContentType("text/html");
        this.pneInfo.setEditable(false);
        this.setSize(400, 400);
        GuiUtil.center(this);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.pneInfo = new JEditorPane();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CGHDataValuesDisplay.this.closeDialog(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.pneInfo);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public CGHDataRegionInfo getDataRegionInfo() {
        return this.dataRegionInfo;
    }

    public void setDataRegionInfo(CGHDataRegionInfo dataRegionInfo) {
        this.dataRegionInfo = dataRegionInfo;
    }

    public void createTextDocument() {
        this.pneInfo.setText(this.createDocument());
    }

    private String createDocument() {
        int experimentIndex = this.dataRegionInfo.getExperimentIndex();
        ICGHDataRegion dataRegion = this.dataRegionInfo.getDataRegion();
        String retVal = "Experiment " + this.data.getSampleName(experimentIndex) + "<br>";
        retVal = retVal + "Chromosome " + (dataRegion.getChromosomeIndex() + 1) + "<br>";
        retVal = retVal + "Start " + dataRegion.getStart() + "<br>";
        retVal = retVal + "Stop " + dataRegion.getStop() + "<br><br>";
        if (dataRegion instanceof FlankingRegion) {
            CGHClone startClone = ((FlankingRegion)dataRegion).getStartClone();
            CGHClone stopClone = ((FlankingRegion)dataRegion).getStopClone();
            int startCloneIndex = this.data.getClones().indexOf(startClone);
            int stopCloneIndex = this.data.getClones().indexOf(stopClone);
            for (int index = startCloneIndex; index <= stopCloneIndex; ++index) {
                retVal = retVal + this.getCloneString(this.data.getCloneAt(index), experimentIndex);
            }
        } else if (dataRegion instanceof CGHClone) {
            retVal = retVal + this.getCloneString((CGHClone)dataRegion, experimentIndex);
        }
        return retVal;
    }

    private String getCloneString(CGHClone clone, int experimentIndex) {
        String retVal = "";
        int cloneIndex = this.data.getClones().indexOf(clone);
        retVal = retVal + "<b>" + clone.getName() + "</b><br>";
        retVal = retVal + "<i>Cy3 Value</i><br>";
        retVal = retVal + this.getTab() + this.data.getCY3(experimentIndex, cloneIndex) + "<br>";
        retVal = retVal + "<i>Cy5 Value</i><br>";
        retVal = retVal + this.getTab() + this.data.getCY5(experimentIndex, cloneIndex) + "<br>";
        retVal = retVal + this.getTab() + "<i>Ratio: " + this.data.getRatio(experimentIndex, cloneIndex, 1) + "</i><br>";
        retVal = retVal + "<br>";
        return retVal;
    }

    private String getTab() {
        return "&nbsp;&nbsp;&nbsp;";
    }

    public IData getData() {
        return this.data;
    }

    public void setData(IData data) {
        this.data = data;
    }
}

