/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHCircleViewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHCircleViewerModel;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHDataRegionInfo;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHCircleViewer.CGHCircleViewerHeader;
import org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil.GenomeBrowserLauncher;
import org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil.PositionDataRegionClickedPopup;
import org.tigr.microarray.mev.cgh.CGHListenerObj.IDataRegionSelectionListener;
import org.tigr.microarray.mev.cgh.CGHUtil.CGHUtility;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.ICGHViewer;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class CGHCircleViewerPanel
extends JPanel
implements ICGHViewer,
Cloneable,
ActionListener {
    CGHCircleViewerModel model;
    int experimentIndex = 0;
    CGHDataRegionInfo selectedDataRegion;
    PositionDataRegionClickedPopup regionClickedPopup;
    IDataRegionSelectionListener drsListener;
    CGHCircleViewerHeader header;

    public CGHCircleViewerPanel(CGHCircleViewerModel model) {
        this.model = model;
        this.header = new CGHCircleViewerHeader(new Insets(15, 15, 0, 0), model, this);
        this.regionClickedPopup = new PositionDataRegionClickedPopup(this);
        this.initComponents();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        super.setBackground(Color.white);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CGHCircleViewerPanel.this.formMouseClicked(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        double rectWidth;
        super.paint(g);
        this.header.updateSize();
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        double diameter = Math.min(d.width, d.height);
        double halfWidth = diameter / 2.0;
        double halfHeight = diameter / 2.0;
        double midWidth = d.width / 2;
        double midHeight = d.height / 2;
        double rectHeight = rectWidth = halfWidth / 60.0;
        double widthScale = halfWidth;
        double heightScale = halfHeight;
        double widthInc = widthScale * 0.85 / (double)this.model.getNumChromosomes();
        double heightInc = heightScale * 0.85 / (double)this.model.getNumChromosomes();
        int k = 0;
        for (int curChrom = 0; curChrom < this.model.getNumChromosomes(); ++curChrom) {
            heightScale -= heightInc;
            widthScale -= heightInc;
            ++k;
            int m = 0;
            double totalDataPoints = this.model.getNumDataPointsInChrom(curChrom);
            int curBac = 0;
            while ((double)curBac < totalDataPoints) {
                double angle = 360.0 * (double)m / totalDataPoints;
                double sin = Math.sin(Math.toRadians(angle));
                double cos = Math.cos(Math.toRadians(angle));
                double y = midHeight - heightScale * sin;
                double x = midWidth - widthScale * cos;
                Ellipse2D.Double el = new Ellipse2D.Double(x, y, rectWidth, rectHeight);
                g2.setPaint(this.model.getDataPointColor(curChrom, curBac, this.experimentIndex));
                g2.fill(el);
                ++m;
                ++curBac;
            }
        }
    }

    private String getSelectedPopupValue(int xCoord, int yCoord) {
        CGHClone clone = this.getSelectedClone(xCoord, yCoord);
        if (clone == null) {
            return null;
        }
        String retVal = "Chromosome: " + CGHUtility.convertChromToString(clone.getChromosomeIndex() + 1, this.model.getCGHSpecies()) + " Probe " + clone.getName();
        return retVal;
    }

    private CGHClone getSelectedClone(int xCoord, int yCoord) {
        double rectWidth;
        Dimension d = this.getSize();
        double diameter = Math.min(d.width, d.height);
        double halfWidth = diameter / 2.0;
        double halfHeight = diameter / 2.0;
        double midWidth = d.width / 2;
        double midHeight = d.height / 2;
        double rectHeight = rectWidth = halfWidth / 60.0;
        double widthScale = halfWidth;
        double heightScale = halfHeight;
        double widthInc = widthScale * 0.85 / (double)this.model.getNumChromosomes();
        double heightInc = heightScale * 0.85 / (double)this.model.getNumChromosomes();
        int k = 0;
        for (int curChrom = 0; curChrom < this.model.getNumChromosomes(); ++curChrom) {
            heightScale -= heightInc;
            widthScale -= heightInc;
            ++k;
            int m = 0;
            double totalDataPoints = this.model.getNumDataPointsInChrom(curChrom);
            int curBac = 0;
            while ((double)curBac < totalDataPoints) {
                double y;
                double angle = 360.0 * (double)m / totalDataPoints;
                double sin = Math.sin(Math.toRadians(angle));
                double cos = Math.cos(Math.toRadians(angle));
                double x = midWidth - widthScale * cos;
                Ellipse2D.Double el = new Ellipse2D.Double(x, y = midHeight - heightScale * sin, rectWidth, rectHeight);
                if (el.contains(xCoord, yCoord)) {
                    CGHClone clone = this.model.getCloneAt(curBac, curChrom);
                    return clone;
                }
                ++m;
                ++curBac;
            }
        }
        return null;
    }

    public void setExperimentIndex(int experimentIndex) {
        this.experimentIndex = experimentIndex;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
        this.repaint();
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.model.setMaxRatioScale(menu.getMaxRatioScale());
        this.model.setMinRatioScale(menu.getMinRatioScale());
        this.model.setNegColorImage(menu.getNegativeGradientImage());
        this.model.setPosColorImage(menu.getPositiveGradientImage());
        this.header.onMenuChanged(menu);
    }

    public void onMenuChanged(ICGHDisplayMenu menu) {
        this.setBackground(menu.getCircleViewerBackgroundColor());
    }

    public void onSelected(IFramework framework) {
        ICGHDisplayMenu cghMenu = framework.getCghDisplayMenu();
        IDisplayMenu menu = framework.getDisplayMenu();
        ICGHCloneValueMenu cloneValueMenu = framework.getCghCloneValueMenu();
        this.onMenuChanged(menu);
        this.onMenuChanged(cghMenu);
        this.onCloneValuesChanged(cloneValueMenu);
    }

    public void onThresholdsChanged(ICGHDisplayMenu menu) {
    }

    protected void formMouseClicked(MouseEvent evt) {
        String sel;
        Point point = evt.getPoint();
        if (evt.getButton() == 3) {
            CGHClone selectedClone = this.getSelectedClone(point.x, point.y);
            if (selectedClone != null) {
                this.selectedDataRegion = new CGHDataRegionInfo(selectedClone, this.experimentIndex);
                this.regionClickedPopup.show(evt.getComponent(), point.x, point.y);
            }
        } else if (evt.getButton() == 1 && (sel = this.getSelectedPopupValue(point.x, point.y)) != null) {
            JPopupMenu popup = new JPopupMenu();
            popup.add(new JLabel(sel));
            popup.show(evt.getComponent(), point.x, point.y);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem item = (JMenuItem)actionEvent.getSource();
        if (this.selectedDataRegion != null) {
            if ("Show Genes in Region".equals(item.getActionCommand())) {
                this.drsListener.onShowGenes(new EventObject(this.selectedDataRegion));
            } else if ("Show Browser".equals(item.getActionCommand())) {
                this.drsListener.onShowBrowser(new EventObject(this.selectedDataRegion));
            } else if ("Display Data Values".equals(item.getActionCommand())) {
                this.drsListener.onDisplayDataValues(new EventObject(this.selectedDataRegion));
            } else if ("Launch Ensembl".equals(item.getActionCommand())) {
                GenomeBrowserLauncher.launchEnsembl(this.selectedDataRegion.getDataRegion(), this.model.getCGHSpecies());
            } else if ("Launch Golden Path".equals(item.getActionCommand())) {
                GenomeBrowserLauncher.launchGoldenPath(this.selectedDataRegion.getDataRegion(), this.model.getCGHSpecies());
            } else if ("Launch NCBI Viewer".equals(item.getActionCommand())) {
                GenomeBrowserLauncher.launchNCBIMapViewer(this.selectedDataRegion.getDataRegion(), this.model.getCGHSpecies());
            }
        }
    }

    public IDataRegionSelectionListener getDrsListener() {
        return this.drsListener;
    }

    public void setDrsListener(IDataRegionSelectionListener drsListener) {
        this.drsListener = drsListener;
    }

    public void onCloneValuesChanged(ICGHCloneValueMenu menu) {
        this.model.onCloneValuesChanged(menu);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int id) {
    }

    public Expression getExpression() {
        return null;
    }
}

