/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHCircleViewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHCircleViewerModel;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;

public class CGHCircleViewerHeader
extends JPanel {
    protected final int RECT_HEIGHT = 15;
    protected boolean isAntiAliasing = true;
    protected float maxValue;
    protected float minValue;
    CGHCircleViewerModel model;
    Insets insets;
    JPanel viewer;

    public CGHCircleViewerHeader(Insets insets, CGHCircleViewerModel model, JPanel viewer) {
        this.setBackground(Color.black);
        this.insets = insets;
        this.model = model;
        this.viewer = viewer;
        this.updateSize();
    }

    @Override
    public void paint(Graphics g1D) {
        super.paint(g1D);
        if (this.model == null) {
            return;
        }
        int viewerWidth = Math.min(this.viewer.getWidth(), this.viewer.getHeight());
        Graphics2D g = (Graphics2D)g1D;
        int width = viewerWidth - (this.insets.left + this.insets.right);
        g.drawImage(this.model.getNegColorImage(), this.viewer.getWidth() / 2 - width / 2, 0, (int)((float)width / 2.0f), 15, null);
        g.drawImage(this.model.getPosColorImage(), this.viewer.getWidth() / 2, 0, (int)((double)width / 2.0), 15, null);
        FontMetrics hfm = g.getFontMetrics();
        int descent = hfm.getDescent();
        int fHeight = hfm.getHeight();
        g.setColor(Color.white);
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.drawString(String.valueOf(this.minValue), this.viewer.getWidth() / 2 - width / 2, 15 + fHeight);
        int textWidth = hfm.stringWidth("0:0");
        g.drawString("0:0", this.viewer.getWidth() / 2 - textWidth / 2, 15 + fHeight);
        textWidth = hfm.stringWidth(String.valueOf(this.maxValue));
        g.drawString(String.valueOf(this.maxValue), this.viewer.getWidth() / 2 + width / 2 - textWidth, 15 + fHeight);
    }

    void updateSize() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            return;
        }
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics hfm = g.getFontMetrics();
        this.setSize(2, 10 + this.RECT_HEIGHT + hfm.getHeight());
        this.setPreferredSize(new Dimension(2, 10 + this.RECT_HEIGHT + hfm.getHeight()));
    }

    public void setMinAndMaxRatios(float min, float max) {
        this.minValue = min;
        this.maxValue = max;
        this.repaint();
    }

    public void onMenuChanged(IDisplayMenu menu) {
        this.model.setNegColorImage(menu.getNegativeGradientImage());
        this.model.setPosColorImage(menu.getPositiveGradientImage());
        this.setMinAndMaxRatios(menu.getMinRatioScale(), menu.getMaxRatioScale());
        this.updateSize();
    }
}

