/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHBrowser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.GBA;

public class SetChartRangeDialog
extends JDialog {
    private int result;
    private Dimension size;
    private JLabel minLabel;
    private JLabel maxLabel;
    float min;
    float max;
    private JTextField minTextField;
    private JTextField maxTextField;
    private GBA gba;

    public SetChartRangeDialog(JFrame parent, float origMin, float origMax) {
        super((Frame)parent, true);
        this.setTitle("Set Display Range");
        this.gba = new GBA();
        this.minLabel = new JLabel("Min: ");
        this.minTextField = new JTextField(10);
        this.minTextField.setText("" + origMin);
        this.maxLabel = new JLabel("Max: ");
        this.maxTextField = new JTextField(10);
        this.maxTextField.setText("" + origMax);
        JButton okButton = new JButton("Okay");
        okButton.setActionCommand("ok-command");
        okButton.addActionListener(new Listener());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel-command");
        cancelButton.addActionListener(new Listener());
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        this.gba.add(content, (Component)this.minLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)this.minTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)this.maxLabel, 0, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)this.maxTextField, 1, 1, 2, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)cancelButton, 0, 2, 1, 1, 0, 0, 0, 17, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add(content, (Component)okButton, 1, 2, 1, 1, 0, 0, 0, 13, new Insets(5, 5, 5, 5), 0, 0);
        this.setResizable(false);
        this.minTextField.grabFocus();
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command.equals("ok-command")) {
                String minText = SetChartRangeDialog.this.minTextField.getText();
                String maxText = SetChartRangeDialog.this.maxTextField.getText();
                try {
                    SetChartRangeDialog.this.min = Float.parseFloat(minText);
                    SetChartRangeDialog.this.max = Float.parseFloat(maxText);
                    SetChartRangeDialog.this.result = 0;
                }
                catch (Exception e) {
                    SetChartRangeDialog.this.result = 2;
                }
                SetChartRangeDialog.this.dispose();
            } else if (command.equals("cancel-command")) {
                SetChartRangeDialog.this.result = 2;
                SetChartRangeDialog.this.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SetChartRangeDialog.this.result = -1;
            SetChartRangeDialog.this.dispose();
        }
    }
}

