/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHBrowser;

import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.beans.SimpleChart;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class CGHPaintableChart
extends SimpleChart {
    Rectangle currentRect = null;
    Rectangle rectToDraw = null;
    Rectangle previousRectDrawn = new Rectangle();
    int startIndex;
    int stopIndex;

    public void paint(Graphics g) {
        super.paint(g);
        this.paintRect(g);
    }

    public void paintRect(Graphics g) {
        this.updateRect();
        if (this.currentRect != null) {
            g.setColor(Color.white);
            g.setXORMode(Color.yellow);
            g.fillRect(this.currentRect.x, this.currentRect.y, this.currentRect.width, this.currentRect.height - 1);
        }
    }

    public void setSelectedCoordinates(int pointIndex) {
        this.startIndex = pointIndex;
        this.stopIndex = -1;
        this.repaint();
    }

    public void updateRect() {
        if (this.startIndex == -1) {
            return;
        }
        if (this.stopIndex == -1) {
            this.highlightPoint();
        } else {
            this.highlightRegion();
        }
    }

    public void highlightPoint() {
        try {
            JCAxis yaxis = this.getDataView(0).getYAxis();
            Point point = this.unpick(this.startIndex, this.getDataView(0).getSeries(0));
            int x = point.x - 5;
            int width = 10;
            Point topY = this.getDataView(0).unmap(point.getX(), yaxis.getMax());
            Point bottomY = this.getDataView(0).unmap(point.getY(), yaxis.getMin());
            int y = (int)topY.getY();
            int height = (int)(bottomY.getY() - topY.getY());
            this.currentRect = new Rectangle(x, y, width, height);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            System.out.println("Paintable char set selected coords npe");
        }
    }

    public void setSelectedCoordinates(int startIndex, int stopIndex) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.repaint();
    }

    public void highlightRegion() {
        try {
            JCAxis yaxis = this.getDataView(0).getYAxis();
            Point pointStart = this.unpick(this.startIndex, this.getDataView(0).getSeries(0));
            Point pointStop = this.unpick(this.stopIndex, this.getDataView(0).getSeries(0));
            int x = pointStart.x;
            int xStop = pointStop.x;
            int width = xStop - x;
            Point topY = this.getDataView(0).unmap(pointStart.getX(), yaxis.getMax());
            Point bottomY = this.getDataView(0).unmap(pointStart.getY(), yaxis.getMin());
            int y = (int)topY.getY();
            int height = (int)(bottomY.getY() - topY.getY());
            this.currentRect = new Rectangle(x, y, width, height);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void deleteRect() {
        this.currentRect = null;
        this.startIndex = -1;
        this.stopIndex = -1;
    }
}

