/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHBrowser;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCPickEvent;
import com.klg.jclass.chart.JCPickListener;
import com.klg.jclass.chart.beans.SimpleChart;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHBrowserModelAdaptor;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHChartDataModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHTableDataModel;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHDataObj.FlankingRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHBrowser.CGHPaintableChart;

public class CGHChartPanel
extends JPanel
implements JCPickListener {
    private int experimentIndex;
    private int chromosomeIndex;
    private CGHChartDataModel chartModel;
    private CGHTableDataModel tableModel;
    private ICGHDataRegion selectedRegion = null;
    CGHBrowserModelAdaptor browserModel;
    private JScrollPane jScrollPane1;
    private SimpleChart chart;
    private JSplitPane jSplitPane1;
    private JTable tblData;

    public CGHChartPanel(int experimentIndex, int chromosomeIndex, CGHBrowserModelAdaptor browserModel) {
        this.browserModel = browserModel;
        this.experimentIndex = experimentIndex;
        this.chromosomeIndex = chromosomeIndex;
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.chart = new CGHPaintableChart();
        this.jScrollPane1 = new JScrollPane();
        this.tblData = new JTable();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOrientation(0);
        this.chart.setBackground(Color.white);
        this.chart.setXAxisAnnotationMethod(1);
        this.chart.setYAxisGridVisible(true);
        this.chart.setYAxisMinMax("-4,4");
        this.jSplitPane1.setLeftComponent((Component)this.chart);
        this.tblData.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tblData);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void initCustomComponents() {
        this.initTable();
        this.initChart();
    }

    private void initChart() {
        this.setPointSize(3);
        this.chart.setFont(new Font("Dialog.bold", 1, 10));
        this.chart.getChartArea().getXAxis(0).setAnnotationRotation(3);
        this.chart.getDataView(0).getYAxis().getTitle().setRotation(3);
        this.chart.getDataView(0).getYAxis().getTitle().setPlacement(2);
        this.chart.setTrigger(0, new EventTrigger(16, 4));
        this.chart.setTrigger(1, new EventTrigger(1, 1));
        this.chart.setTrigger(2, new EventTrigger(2, 2));
        this.chart.addPickListener((JCPickListener)this);
        this.chart.getDataView(0).getYAxis().setEditable(false);
    }

    public void setPointSize(int size) {
        List seriesList = this.chart.getDataView(0).getSeries();
        Iterator it = seriesList.iterator();
        while (it.hasNext()) {
            ((ChartDataViewSeries)it.next()).getStyle().setSymbolSize(size);
        }
    }

    private void initTable() {
        this.tblData.setSelectionMode(1);
        ListSelectionModel rowSM = this.tblData.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedStopRow;
                    int selectedStartRow = lsm.getMinSelectionIndex();
                    if (selectedStartRow == (selectedStopRow = lsm.getMaxSelectionIndex())) {
                        CGHChartPanel.this.highlightChartData(selectedStartRow);
                    } else {
                        CGHChartPanel.this.highlightChartData(selectedStartRow - 1, selectedStopRow + 1);
                    }
                }
            }
        });
    }

    public void highlightChartData(int dataIndex) {
        ((CGHPaintableChart)this.chart).setSelectedCoordinates(dataIndex);
    }

    public void highlightChartData(int startIndex, int stopIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (stopIndex > this.chartModel.getSeriesSize() - 1) {
            stopIndex = this.chartModel.getSeriesSize() - 1;
        }
        ((CGHPaintableChart)this.chart).setSelectedCoordinates(startIndex, stopIndex);
    }

    public void deleteHighlightedRect() {
        this.selectedRegion = null;
        ((CGHPaintableChart)this.chart).deleteRect();
    }

    public void smoothUnconfirmed(boolean smooth) {
        this.chartModel.smoothUnconfirmed(smooth);
    }

    public void setShowLegend(boolean show) {
        this.chart.setLegendVisible(show);
    }

    public void setChromosomeIndex(int chromaIndex) {
        this.chromosomeIndex = chromaIndex;
        this.browserModel.setChromosomeIndex(chromaIndex);
        this.deleteHighlightedRect();
    }

    public void setExperimentIndex(int expIndex) {
        this.experimentIndex = expIndex;
        this.browserModel.setExperimentIndex(expIndex);
        this.deleteHighlightedRect();
    }

    public void setChartType(int chartType) {
        this.chart.setChartType(chartType);
    }

    public void setXAxisPositionsByLinearOrder() {
        this.chartModel.setXAxisPositions(1);
        this.chart.repaint();
    }

    public void setXAxisPositionsByChromLocation() {
        this.chartModel.setXAxisPositions(0);
        this.chart.repaint();
    }

    public void setXAxisLabelsByValue() {
        this.chart.setXAxisAnnotationMethod(0);
    }

    public void setXAxisLabelsByClone() {
        this.chart.setXAxisAnnotationMethod(3);
    }

    public void setXAxisLabelsNone() {
        this.chart.setXAxisAnnotationMethod(1);
    }

    private void updateSelection() {
        if (this.selectedRegion != null) {
            this.setSelectedRegion(this.selectedRegion);
        } else {
            this.chart.repaint();
        }
    }

    public void setChartDisplayRange(float min, float max) {
        String range = min + "," + max;
        this.chart.setYAxisMinMax(range);
    }

    public void pick(JCPickEvent jCPickEvent) {
        JCDataIndex di = jCPickEvent.getPickResult();
        if (di != null) {
            int point = di.getPoint();
            int series = di.getSeriesIndex();
            this.tblData.setRowSelectionInterval(point, point);
            this.tblData.scrollRectToVisible(this.tblData.getCellRect(point, 0, false));
        }
    }

    public void setSelectedRegion(ICGHDataRegion selectedRegion) {
        this.selectedRegion = selectedRegion;
        if (selectedRegion instanceof CGHClone) {
            this.setSelectedClone((CGHClone)selectedRegion);
        } else if (selectedRegion instanceof FlankingRegion) {
            this.setSelectedFlankingRegion((FlankingRegion)selectedRegion);
        }
    }

    public void setSelectedClone(CGHClone selectedClone) {
        int selectionIndex = this.chartModel.getCloneIndex(selectedClone);
        this.tblData.setRowSelectionInterval(selectionIndex, selectionIndex);
        this.tblData.scrollRectToVisible(this.tblData.getCellRect(selectionIndex, 0, false));
    }

    public void setSelectedFlankingRegion(FlankingRegion selectedFlankingRegion) {
        CGHClone stopClone;
        CGHClone startClone = selectedFlankingRegion.getStartClone();
        if (startClone == null) {
            startClone = this.chartModel.getCloneByPosition(selectedFlankingRegion.getStart());
        }
        if ((stopClone = selectedFlankingRegion.getStopClone()) == null) {
            stopClone = this.chartModel.getCloneByPosition(selectedFlankingRegion.getStop());
        }
        if (startClone == null || stopClone == null) {
            return;
        }
        int startIndex = this.chartModel.getStartCloneIndex(startClone);
        int stopIndex = this.chartModel.getStopCloneIndex(stopClone);
        this.tblData.setRowSelectionInterval(startIndex, stopIndex);
        this.tblData.scrollRectToVisible(this.tblData.getCellRect(startIndex, 0, false));
    }

    public CGHChartDataModel getChartModel() {
        return this.chartModel;
    }

    public void setChartModel(CGHChartDataModel chartModel) {
        this.chartModel = chartModel;
        this.chart.getDataView(0).setDataSource((ChartDataModel)chartModel);
    }

    public CGHTableDataModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(CGHTableDataModel tableModel) {
        this.tableModel = tableModel;
        this.tblData.setModel(tableModel);
    }

    public void setCloneValuesByPScore() {
        int startRow = this.tblData.getSelectionModel().getMinSelectionIndex();
        int stopRow = this.tblData.getSelectionModel().getMaxSelectionIndex();
        this.browserModel.setCloneValueType(0);
        this.tblData.setRowSelectionInterval(startRow, stopRow);
    }

    public void setCloneValuesByDyeSwap() {
        int startRow = this.tblData.getSelectionModel().getMinSelectionIndex();
        int stopRow = this.tblData.getSelectionModel().getMaxSelectionIndex();
        this.browserModel.setCloneValueType(1);
        this.tblData.setRowSelectionInterval(startRow, stopRow);
    }

    public void setCloneValuesByLogAverageInverted() {
        int startRow = this.tblData.getSelectionModel().getMinSelectionIndex();
        int stopRow = this.tblData.getSelectionModel().getMaxSelectionIndex();
        this.browserModel.setCloneValueType(2);
        this.tblData.setRowSelectionInterval(startRow, stopRow);
    }

    public void setCloneValuesByLogDyeSwap() {
        int startRow = this.tblData.getSelectionModel().getMinSelectionIndex();
        int stopRow = this.tblData.getSelectionModel().getMaxSelectionIndex();
        this.browserModel.setCloneValueType(3);
        this.tblData.setRowSelectionInterval(startRow, stopRow);
    }

    public SimpleChart getChart() {
        return this.chart;
    }

    public void setChart(SimpleChart chart) {
        this.chart = chart;
    }

    public JTable getTblData() {
        return this.tblData;
    }

    public void setTblData(JTable tblData) {
        this.tblData = tblData;
    }
}

