/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.CGHBrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHBrowserModelAdaptor;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHChartDataModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHTableDataModel;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHBrowser.CGHBrowserMenubar;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHBrowser.CGHChartPanel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CGHBrowser.SetChartRangeDialog;
import org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil.GuiUtil;
import org.tigr.microarray.mev.cgh.CGHUtil.CGHUtility;
import org.tigr.microarray.mev.cluster.gui.IData;

public class CGHBrowser
extends JFrame
implements ActionListener {
    private CGHChartPanel chartPanel;
    private IData data;
    private CGHBrowserModelAdaptor browserModel;
    private JMenu mnuChromosome;
    private JRadioButtonMenuItem rdoXAxisLabelsByClone;
    private ButtonGroup grpXAxisOrder;
    private JCheckBoxMenuItem chkShowLegend;
    private JRadioButtonMenuItem rdoArea;
    private JCheckBoxMenuItem chkSmoothUnconfirmed;
    private ButtonGroup grpChartTypes;
    private JMenuBar menubar;
    private JRadioButtonMenuItem rdoXAxisLabelsByValue;
    private JRadioButtonMenuItem rdoBar;
    private JPanel pnlMain;
    private JMenuItem btnPointSize;
    private JMenu mnuView;
    private JMenu mnuXAxisValues;
    private JMenuItem btnDisplayRange;
    private JRadioButtonMenuItem rdoXAxisLabelsNone;
    private ButtonGroup grpCloneValues;
    private ButtonGroup grpXAxisLabels;
    private JMenu mnuXAxisLabels;
    private JMenu mnuExperiment;
    private JRadioButtonMenuItem rdoScatterPlot;
    private JRadioButtonMenuItem rdoPlot;
    private JRadioButtonMenuItem rdoXAxisByPosition;
    private JRadioButtonMenuItem rdoXAxisByLinearOrder;
    private JMenu mnuChartType;

    public CGHBrowser(IData data, CGHChartDataModel chartModel, CGHTableDataModel tableModel) {
        this(data, 0, 0, chartModel, tableModel, 1, true);
    }

    public CGHBrowser(IData data, int sampleIndex, int chromosomeIndex, CGHChartDataModel chartModel, CGHTableDataModel tableModel, int cloneValueType, boolean hasDyeSwap) {
        this.data = data;
        this.browserModel = new CGHBrowserModelAdaptor(data, sampleIndex, chromosomeIndex, cloneValueType);
        this.browserModel.setCloneValueType(cloneValueType);
        chartModel.setAdaptor(this.browserModel);
        tableModel.setAdaptor(this.browserModel);
        this.browserModel.addChangeListener(chartModel);
        this.browserModel.addChangeListener(tableModel);
        this.chartPanel = new CGHChartPanel(sampleIndex, chromosomeIndex, this.browserModel);
        this.initComponents();
        this.setSize(1000, 800);
        this.setChartModel(chartModel);
        this.setTableModel(tableModel);
        this.initCustomComponents();
        this.initMenus(sampleIndex, chromosomeIndex, cloneValueType, hasDyeSwap);
    }

    private void initComponents() {
        this.grpXAxisOrder = new ButtonGroup();
        this.grpXAxisLabels = new ButtonGroup();
        this.grpCloneValues = new ButtonGroup();
        this.grpChartTypes = new ButtonGroup();
        this.pnlMain = new JPanel();
        this.menubar = new JMenuBar();
        this.mnuExperiment = new JMenu();
        this.mnuChromosome = new JMenu();
        this.mnuView = new JMenu();
        this.mnuChartType = new JMenu();
        this.rdoPlot = new JRadioButtonMenuItem();
        this.rdoScatterPlot = new JRadioButtonMenuItem();
        this.rdoBar = new JRadioButtonMenuItem();
        this.rdoArea = new JRadioButtonMenuItem();
        this.mnuXAxisValues = new JMenu();
        this.rdoXAxisByPosition = new JRadioButtonMenuItem();
        this.rdoXAxisByLinearOrder = new JRadioButtonMenuItem();
        this.mnuXAxisLabels = new JMenu();
        this.rdoXAxisLabelsNone = new JRadioButtonMenuItem();
        this.rdoXAxisLabelsByClone = new JRadioButtonMenuItem();
        this.rdoXAxisLabelsByValue = new JRadioButtonMenuItem();
        this.chkShowLegend = new JCheckBoxMenuItem();
        this.chkSmoothUnconfirmed = new JCheckBoxMenuItem();
        this.btnPointSize = new JMenuItem();
        this.btnDisplayRange = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CGHBrowser.this.exitForm(evt);
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.mnuExperiment.setText("Experiment");
        this.menubar.add(this.mnuExperiment);
        this.mnuChromosome.setText("Chromosome");
        this.menubar.add(this.mnuChromosome);
        this.mnuView.setText("View");
        this.mnuChartType.setText("Chart Type");
        this.rdoPlot.setSelected(true);
        this.rdoPlot.setText("Plot");
        this.grpChartTypes.add(this.rdoPlot);
        this.rdoPlot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.rdoPlotActionPerformed(evt);
            }
        });
        this.mnuChartType.add(this.rdoPlot);
        this.rdoScatterPlot.setText("Scatter Plot");
        this.grpChartTypes.add(this.rdoScatterPlot);
        this.rdoScatterPlot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.rdoScatterPlotActionPerformed(evt);
            }
        });
        this.mnuChartType.add(this.rdoScatterPlot);
        this.rdoBar.setText("Bar");
        this.grpChartTypes.add(this.rdoBar);
        this.rdoBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.rdoBarActionPerformed(evt);
            }
        });
        this.mnuChartType.add(this.rdoBar);
        this.rdoArea.setText("Area");
        this.grpChartTypes.add(this.rdoArea);
        this.rdoArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.rdoAreaActionPerformed(evt);
            }
        });
        this.mnuChartType.add(this.rdoArea);
        this.mnuView.add(this.mnuChartType);
        this.mnuXAxisValues.setText("X Axis Order");
        this.rdoXAxisByPosition.setText("Position");
        this.grpXAxisOrder.add(this.rdoXAxisByPosition);
        this.rdoXAxisByPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.rdoXAxisByPositionActionPerformed(evt);
            }
        });
        this.mnuXAxisValues.add(this.rdoXAxisByPosition);
        this.rdoXAxisByLinearOrder.setSelected(true);
        this.rdoXAxisByLinearOrder.setText("Linear Order");
        this.grpXAxisOrder.add(this.rdoXAxisByLinearOrder);
        this.rdoXAxisByLinearOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.rdoXAxisByLinearOrderActionPerformed(evt);
            }
        });
        this.mnuXAxisValues.add(this.rdoXAxisByLinearOrder);
        this.mnuView.add(this.mnuXAxisValues);
        this.mnuXAxisLabels.setText("X Axis Labels");
        this.rdoXAxisLabelsNone.setSelected(true);
        this.rdoXAxisLabelsNone.setText("None");
        this.grpXAxisLabels.add(this.rdoXAxisLabelsNone);
        this.rdoXAxisLabelsNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.rdoXAxisLabelsNoneActionPerformed(evt);
            }
        });
        this.mnuXAxisLabels.add(this.rdoXAxisLabelsNone);
        this.rdoXAxisLabelsByClone.setText("Clone");
        this.grpXAxisLabels.add(this.rdoXAxisLabelsByClone);
        this.rdoXAxisLabelsByClone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.rdoXAxisLabelsByCloneActionPerformed(evt);
            }
        });
        this.mnuXAxisLabels.add(this.rdoXAxisLabelsByClone);
        this.rdoXAxisLabelsByValue.setText("Value");
        this.grpXAxisLabels.add(this.rdoXAxisLabelsByValue);
        this.rdoXAxisLabelsByValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.rdoXAxisLabelsByValueActionPerformed(evt);
            }
        });
        this.mnuXAxisLabels.add(this.rdoXAxisLabelsByValue);
        this.mnuView.add(this.mnuXAxisLabels);
        this.chkShowLegend.setText("Show Legend");
        this.chkShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.chkShowLegendActionPerformed(evt);
            }
        });
        this.mnuView.add(this.chkShowLegend);
        this.chkSmoothUnconfirmed.setText("Smooth Unconfirmed");
        this.chkSmoothUnconfirmed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.chkSmoothUnconfirmedActionPerformed(evt);
            }
        });
        this.mnuView.add(this.chkSmoothUnconfirmed);
        this.btnPointSize.setText("Point Size");
        this.btnPointSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.btnPointSizeActionPerformed(evt);
            }
        });
        this.mnuView.add(this.btnPointSize);
        this.btnDisplayRange.setText("Set Display Range");
        this.btnDisplayRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CGHBrowser.this.btnDisplayRangeActionPerformed(evt);
            }
        });
        this.mnuView.add(this.btnDisplayRange);
        this.menubar.add(this.mnuView);
        this.setJMenuBar(this.menubar);
        this.pack();
    }

    private void rdoBarActionPerformed(ActionEvent evt) {
        this.chartPanel.setChartType(9);
    }

    private void rdoAreaActionPerformed(ActionEvent evt) {
        this.chartPanel.setChartType(8);
    }

    private void rdoPlotActionPerformed(ActionEvent evt) {
        this.chartPanel.setChartType(0);
    }

    private void rdoScatterPlotActionPerformed(ActionEvent evt) {
        this.chartPanel.setChartType(1);
    }

    private void btnDisplayRangeActionPerformed(ActionEvent evt) {
        SetChartRangeDialog crd = new SetChartRangeDialog(this, Float.parseFloat(this.chartPanel.getChart().getYAxisMin()), Float.parseFloat(this.chartPanel.getChart().getYAxisMax()));
        if (crd.showModal() == 0) {
            float min = crd.getMin();
            float max = crd.getMax();
            this.chartPanel.setChartDisplayRange(min, max);
        }
    }

    private void btnPointSizeActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog(null, "Enter Point Size", "Data Point Size", -1);
        if (s == null || s.length() == 0) {
            return;
        }
        try {
            int val = Integer.parseInt(s);
            this.chartPanel.setPointSize(val);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Input Must Be An Integer", "Number Format Error", -1);
        }
    }

    private void rdoXAxisLabelsByValueActionPerformed(ActionEvent evt) {
        this.chartPanel.setXAxisLabelsByValue();
    }

    private void rdoXAxisLabelsByCloneActionPerformed(ActionEvent evt) {
        this.chartPanel.setXAxisLabelsByClone();
    }

    private void rdoXAxisLabelsNoneActionPerformed(ActionEvent evt) {
        this.chartPanel.setXAxisLabelsNone();
    }

    private void chkShowLegendActionPerformed(ActionEvent evt) {
        this.chartPanel.setShowLegend(this.chkShowLegend.isSelected());
    }

    private void chkSmoothUnconfirmedActionPerformed(ActionEvent evt) {
        this.chartPanel.smoothUnconfirmed(this.chkSmoothUnconfirmed.isSelected());
    }

    private void rdoXAxisByLinearOrderActionPerformed(ActionEvent evt) {
        this.chartPanel.setXAxisPositionsByLinearOrder();
    }

    private void rdoXAxisByPositionActionPerformed(ActionEvent evt) {
        this.chartPanel.setXAxisPositionsByChromLocation();
    }

    private void initCustomComponents() {
        this.setTitle("CGH Browser");
        GuiUtil.center(this);
        this.pnlMain.add((Component)this.chartPanel, "Center");
        this.initChart();
    }

    private void initChart() {
        this.chartPanel.setShowLegend(this.chkShowLegend.isSelected());
        this.chartPanel.smoothUnconfirmed(this.chkSmoothUnconfirmed.isSelected());
        if (this.rdoXAxisByLinearOrder.isSelected()) {
            this.chartPanel.setXAxisPositionsByLinearOrder();
        } else {
            this.chartPanel.setXAxisPositionsByChromLocation();
        }
        if (this.rdoXAxisLabelsByValue.isSelected()) {
            this.chartPanel.setXAxisLabelsByValue();
        } else if (this.rdoXAxisLabelsByClone.isSelected()) {
            this.chartPanel.setXAxisLabelsByClone();
        } else if (this.rdoXAxisLabelsNone.isSelected()) {
            this.chartPanel.setXAxisLabelsNone();
        }
    }

    private void initMenus(int sampleIndex, int chromosomeIndex, int cloneValueType, boolean hasDyeSwap) {
        CGHBrowserMenubar bm = new CGHBrowserMenubar(this);
        this.menubar.add(bm.createCloneValuesMenu(this.browserModel.getCloneValueType(), hasDyeSwap, this.data.getDataType() == 1, this.data.isLog2Data(), this.data.hasCloneDistribution()));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int exp = 0; exp < this.data.getFeaturesCount(); ++exp) {
            if (exp == sampleIndex) {
                this.mnuExperiment.add(this.createJRadioButtonMenuItem(this.createBrowserSampleSelectedAction(exp), buttonGroup, true));
                continue;
            }
            this.mnuExperiment.add(this.createJRadioButtonMenuItem(this.createBrowserSampleSelectedAction(exp), buttonGroup));
        }
        AbstractAction action = new SampleSelectedAction("All Experiments");
        action.putValue("SelectionIndex", new Integer(-1));
        if (chromosomeIndex == -1) {
            this.mnuExperiment.add(this.createJRadioButtonMenuItem(action, buttonGroup, true));
        } else {
            this.mnuExperiment.add(this.createJRadioButtonMenuItem(action, buttonGroup));
        }
        buttonGroup = new ButtonGroup();
        for (int chrom = 0; chrom < this.data.getNumChromosomes(); ++chrom) {
            if (chromosomeIndex == chrom) {
                this.mnuChromosome.add(this.createJRadioButtonMenuItem(this.createBrowserChromosomeSelectedAction(chrom), buttonGroup, true));
                continue;
            }
            this.mnuChromosome.add(this.createJRadioButtonMenuItem(this.createBrowserChromosomeSelectedAction(chrom), buttonGroup));
        }
        action = new ChromosomeSelectedAction("All Chromosomes");
        action.putValue("SelectionIndex", new Integer(-1));
        this.mnuChromosome.add(this.createJRadioButtonMenuItem(action, buttonGroup));
    }

    private Action createBrowserSampleSelectedAction(int index) {
        SampleSelectedAction action = new SampleSelectedAction(this.data.getSampleName(index));
        action.putValue("SelectionIndex", new Integer(index));
        return action;
    }

    private Action createBrowserChromosomeSelectedAction(int index) {
        String name = CGHUtility.convertChromToLongString(index + 1, this.data.getCGHSpecies());
        ChromosomeSelectedAction action = new ChromosomeSelectedAction(name);
        action.putValue("SelectionIndex", new Integer(index));
        return action;
    }

    protected JMenuItem createJMenuItem(String name, String command, ActionListener listener) {
        JMenuItem item = new JMenuItem(name);
        item.setActionCommand(command);
        item.addActionListener(listener);
        return item;
    }

    protected JMenuItem createJRadioButtonMenuItem(Action action, ButtonGroup buttonGroup) {
        return this.createJRadioButtonMenuItem(action, buttonGroup, false);
    }

    protected JMenuItem createJRadioButtonMenuItem(Action action, ButtonGroup buttonGroup, boolean isSelected) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
        item.setSelected(isSelected);
        if (buttonGroup != null) {
            buttonGroup.add(item);
        }
        return item;
    }

    public void setSelectedRegion(ICGHDataRegion selectedRegion) {
        this.chartPanel.setSelectedRegion(selectedRegion);
    }

    public void setChartModel(CGHChartDataModel chartModel) {
        this.chartPanel.setChartModel(chartModel);
    }

    public void setTableModel(CGHTableDataModel tableModel) {
        this.chartPanel.setTableModel(tableModel);
    }

    public void setCloneValueType(int cloneValueType) {
        JTable tblData = this.chartPanel.getTblData();
        int[] selectedRows = tblData.getSelectedRows();
        this.browserModel.setCloneValueType(cloneValueType);
        if (selectedRows.length > 0) {
            tblData.setRowSelectionInterval(selectedRows[0], selectedRows[selectedRows.length - 1]);
        }
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        if (command.equals("clone-values-dye-swap")) {
            this.setCloneValueType(1);
        } else if (command.equals("clone-values-log-invert-average")) {
            this.setCloneValueType(2);
        } else if (command.equals("clone-values-log-dye-swap")) {
            this.setCloneValueType(3);
        } else if (command.equals("clone-values-p-values")) {
            this.setCloneValueType(0);
        } else if (command.equals("clone-values-log-ratios")) {
            this.setCloneValueType(5);
        } else if (command.equals("clone-values-ratios")) {
            this.setCloneValueType(4);
        } else if (command.equals("clone-values-p-values")) {
            this.setCloneValueType(0);
        }
    }

    class ChromosomeSelectedAction
    extends AbstractAction {
        public ChromosomeSelectedAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int chromosomeIndex = (Integer)this.getValue("SelectionIndex");
            CGHBrowser.this.chartPanel.setChromosomeIndex(chromosomeIndex);
        }
    }

    class SampleSelectedAction
    extends AbstractAction {
        public SampleSelectedAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int sampleIndex = (Integer)this.getValue("SelectionIndex");
            CGHBrowser.this.chartPanel.setExperimentIndex(sampleIndex);
        }
    }
}

