/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.AlgorithmResultsViewers.NumberOfAlterationsViewers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHGuiObj.AlgorithmResultsViewers.NumberOfAlterationsViewers.NumberOfAlterationsDataModel;
import org.tigr.microarray.mev.cgh.CGHGuiObj.GuiUtil.GenomeBrowserLauncher;
import org.tigr.microarray.mev.cgh.CGHListenerObj.IDataRegionSelectionListener;
import org.tigr.microarray.mev.cgh.CGHUtil.TableDataWriter;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.ICGHDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;

public class NumberOfAlterationsViewer
extends JPanel
implements IViewer {
    NumberOfAlterationsDataModel dataModel;
    JTable resultsTable = new JTable();
    Vector listeners = new Vector();
    IData data;
    private JMenu mnuAnnotations;
    private JMenuBar menubar;
    private JMenu mnuLinks;
    private JMenuItem btnEnsembl;
    private JMenuItem btnGoldenPath;
    private JMenuItem btnNcbi;
    private JMenuItem itmSave;
    private JMenuItem itmAnnotateSelected;
    private JMenu mnuFile;

    public NumberOfAlterationsViewer() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.menubar = new JMenuBar();
        this.mnuFile = new JMenu();
        this.itmSave = new JMenuItem();
        this.mnuAnnotations = new JMenu();
        this.itmAnnotateSelected = new JMenuItem();
        this.mnuLinks = new JMenu();
        this.btnEnsembl = new JMenuItem();
        this.btnGoldenPath = new JMenuItem();
        this.btnNcbi = new JMenuItem();
        this.mnuFile.setText("File");
        this.itmSave.setText("Save");
        this.itmSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberOfAlterationsViewer.this.itmSaveActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.itmSave);
        this.menubar.add(this.mnuFile);
        this.mnuAnnotations.setText("Annotations");
        this.itmAnnotateSelected.setText("Annotate Selected");
        this.itmAnnotateSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberOfAlterationsViewer.this.itmAnnotateSelectedActionPerformed(evt);
            }
        });
        this.mnuAnnotations.add(this.itmAnnotateSelected);
        this.menubar.add(this.mnuAnnotations);
        this.mnuLinks.setText("Links");
        this.btnEnsembl.setText("Ensembl");
        this.btnEnsembl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberOfAlterationsViewer.this.btnEnsemblActionPerformed(evt);
            }
        });
        this.mnuLinks.add(this.btnEnsembl);
        this.btnGoldenPath.setText("Golden Path");
        this.btnGoldenPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberOfAlterationsViewer.this.btnGoldenPathActionPerformed(evt);
            }
        });
        this.mnuLinks.add(this.btnGoldenPath);
        this.btnNcbi.setText("NCBI");
        this.btnNcbi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberOfAlterationsViewer.this.btnNCBIActionPerformed(evt);
            }
        });
        this.mnuLinks.add(this.btnNcbi);
        this.menubar.add(this.mnuLinks);
        this.setLayout(new BorderLayout());
    }

    private void btnNCBIActionPerformed(ActionEvent evt) {
        int[] selectedRow = this.resultsTable.getSelectedRows();
        if (selectedRow.length != 0) {
            ICGHDataRegion[] dataRegions = this.dataModel.getDataRegionAt(selectedRow);
            GenomeBrowserLauncher.launchNCBIMapViewer(dataRegions, this.data.getCGHSpecies());
        }
    }

    private void btnGoldenPathActionPerformed(ActionEvent evt) {
        int selectedRow = this.resultsTable.getSelectedRow();
        if (selectedRow != -1) {
            ICGHDataRegion dataRegion = this.dataModel.getDataRegionAt(selectedRow);
            GenomeBrowserLauncher.launchGoldenPath(dataRegion, this.data.getCGHSpecies());
        }
    }

    private void btnEnsemblActionPerformed(ActionEvent evt) {
        int selectedRow = this.resultsTable.getSelectedRow();
        if (selectedRow != -1) {
            ICGHDataRegion dataRegion = this.dataModel.getDataRegionAt(selectedRow);
            GenomeBrowserLauncher.launchEnsembl(dataRegion, this.data.getCGHSpecies());
        }
    }

    private void itmSaveActionPerformed(ActionEvent evt) {
        TableDataWriter writer = new TableDataWriter();
        writer.writeTable(this.dataModel);
    }

    private void itmAnnotateSelectedActionPerformed(ActionEvent evt) {
        Vector[] vecAnnotationRegions = new Vector[this.data.getNumChromosomes()];
        for (int i = 0; i < vecAnnotationRegions.length; ++i) {
            vecAnnotationRegions[i] = new Vector();
        }
        int[] selectedRows = this.resultsTable.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            ICGHDataRegion dataRegion = this.dataModel.getDataRegionAt(selectedRows[i]);
            int chromosomeIndex = dataRegion.getChromosomeIndex();
            vecAnnotationRegions[chromosomeIndex].add(dataRegion);
        }
        ICGHDataRegion[][] annotationRegions = new ICGHDataRegion[this.data.getNumChromosomes()][];
        for (int i = 0; i < annotationRegions.length; ++i) {
            Vector chromRegions = vecAnnotationRegions[i];
            annotationRegions[i] = new ICGHDataRegion[chromRegions.size()];
            for (int j = 0; j < chromRegions.size(); ++j) {
                annotationRegions[i][j] = (ICGHDataRegion)chromRegions.get(j);
            }
        }
        ((MultipleArrayData)this.data).setAnnotations(annotationRegions);
        this.fireAnnotationsSelected(new EventObject(annotationRegions));
    }

    private void fireAnnotationsSelected(EventObject eventObject) {
        for (Object obj : this.listeners) {
            if (!(obj instanceof IDataRegionSelectionListener)) continue;
            ((IDataRegionSelectionListener)obj).onAnnotationsSelected(eventObject);
        }
    }

    private void initCustomComponents() {
        this.setLayout(new BorderLayout());
        JScrollPane scrResults = new JScrollPane();
        scrResults.setViewportView(this.resultsTable);
        this.add((Component)scrResults, "Center");
    }

    public JComponent getContentComponent() {
        return this;
    }

    public JComponent getHeaderComponent() {
        return this.menubar;
    }

    public BufferedImage getImage() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onMenuChanged(ICGHDisplayMenu menu) {
    }

    public void onSelected(IFramework framework) {
    }

    public void onThresholdsChanged(ICGHDisplayMenu menu) {
    }

    public NumberOfAlterationsDataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(NumberOfAlterationsDataModel dataModel) {
        this.dataModel = dataModel;
        this.resultsTable.setModel(dataModel);
    }

    public IData getData() {
        return this.data;
    }

    public void setData(IData dat) {
        this.data = dat;
    }

    public void addDrsListener(IDataRegionSelectionListener listener) {
        this.listeners.add(listener);
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public int[][] getClusters() {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public void setExperiment(Experiment e) {
    }

    public int getExperimentID() {
        return 0;
    }

    public void setExperimentID(int id) {
    }

    public Expression getExpression() {
        return null;
    }
}

