/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHGuiObj.AlgorithmResultsViewers.NumberOfAlterationsViewers;

import javax.swing.table.AbstractTableModel;
import org.tigr.microarray.mev.cgh.CGHDataObj.AlterationRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;

public class NumberOfAlterationsDataModel
extends AbstractTableModel {
    AlterationRegion[] alterationRegions;

    public AlterationRegion[] getAlterationRegions() {
        return this.alterationRegions;
    }

    public void setAlterationRegions(AlterationRegion[] alterationRegions) {
        this.alterationRegions = alterationRegions;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.alterationRegions.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.alterationRegions[row].getDataRegion().getName();
            }
            case 1: {
                return new Integer(this.alterationRegions[row].getDataRegion().getChromosomeIndex() + 1);
            }
            case 2: {
                return new Integer(this.alterationRegions[row].getDataRegion().getStart());
            }
            case 3: {
                return new Integer(this.alterationRegions[row].getDataRegion().getStop());
            }
            case 4: {
                return new Integer(this.alterationRegions[row].getNumAlterations());
            }
            case 5: {
                return new Float(this.alterationRegions[row].getPercentAltered());
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Chrom";
            }
            case 2: {
                return "Start";
            }
            case 3: {
                return "Stop";
            }
            case 4: {
                return "# Alterations";
            }
            case 5: {
                return "% Altered";
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        if (this.getValueAt(0, c) == null) {
            return String.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    public ICGHDataRegion getDataRegionAt(int index) {
        return this.alterationRegions[index].getDataRegion();
    }

    public ICGHDataRegion[] getDataRegionAt(int[] indices) {
        ICGHDataRegion[] alteredRegions = new ICGHDataRegion[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            alteredRegions[i] = this.alterationRegions[indices[i]].getDataRegion();
        }
        return alteredRegions;
    }
}

