/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataObj;

import java.sql.ResultSet;
import org.tigr.microarray.mev.cgh.CGHDataObj.IGeneData;
import org.tigr.microarray.mev.cgh.CGHUtil.CGHUtility;

public class RefGeneLinkData
implements IGeneData {
    private int chromosome;
    private String geneName;
    private int locusLinkId;
    private int start;
    private int stop;

    public int getChromosome() {
        return this.chromosome;
    }

    public void setChromosome(int chromosome) {
        this.chromosome = chromosome;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setGeneName(String geneName) {
        this.geneName = geneName;
    }

    public int getLocusLinkId() {
        return this.locusLinkId;
    }

    public void setLocusLinkId(int locusLinkId) {
        this.locusLinkId = locusLinkId;
    }

    public void populate(ResultSet rs, int species) {
        try {
            this.chromosome = CGHUtility.convertStringToChrom(rs.getString("chrom"), species);
            this.start = rs.getInt("txStart");
            this.stop = rs.getInt("txEnd");
            this.geneName = rs.getString("name");
            this.locusLinkId = rs.getInt("locusLinkId");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.geneName;
    }

    @Override
    public int getChromosomeIndex() {
        return this.chromosome - 1;
    }

    @Override
    public String getName() {
        return this.geneName;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getStop() {
        return this.stop;
    }

    public void setStop(int stop) {
        this.stop = stop;
    }
}

