/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataObj;

import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.tigr.microarray.mev.cgh.CGHDataObj.IGeneData;
import org.tigr.microarray.mev.cgh.CGHDataObj.IGeneDataSet;
import org.tigr.microarray.mev.cgh.CGHDataObj.RefGeneLinkData;
import org.tigr.microarray.mev.cgh.CGHUtil.CGHUtility;
import org.tigr.microarray.mev.cgh.DBObj.DSqlHandler;

public class GeneDataSet
implements IGeneDataSet {
    private Vector geneData;

    public void loadGeneDataByGeneName(String geneName, int species) {
        String db = this.getDBName(species);
        String sql = "SELECT chrom, txStart, txEnd, name, locusLinkId FROM \"" + db + "\"" + " GROUP BY chrom, txStart, txEnd, name, locusLinkId HAVING UPPER(name)= " + CGHUtility.encap(geneName.toUpperCase());
        System.out.println(sql);
        this.loadGenes(sql, species);
    }

    public void loadGeneDataByGeneNames(Vector geneNames, int species) {
        String db = this.getDBName(species);
        String strGeneNames = "";
        Iterator it = geneNames.iterator();
        if (it.hasNext()) {
            strGeneNames = strGeneNames + CGHUtility.encap(((String)it.next()).toUpperCase());
        }
        while (it.hasNext()) {
            strGeneNames = strGeneNames + ", " + CGHUtility.encap(((String)it.next()).toUpperCase());
        }
        String sql = "SELECT chrom, txStart, txEnd, name, locusLinkId FROM \"" + db + "\"" + " GROUP BY chrom, txStart, txEnd, name, locusLinkId HAVING UPPER(name) IN (" + strGeneNames + ")";
        System.out.println(sql);
        this.loadGenes(sql, species);
    }

    public void loadAllGenes(int species) {
        String db = this.getDBName(species);
        String sql = "select chrom, txStart, txEnd, name, locusLinkId from \"" + db + "\"" + " GROUP BY chrom, txStart, txEnd, name, locusLinkId";
        System.out.println(sql);
        this.loadGenes(sql, species);
    }

    private String getDBName(int species) {
        String dbName = "";
        switch (species) {
            case 0: {
                dbName = "Hs_RefGenesMapped";
                break;
            }
            case 1: {
                dbName = "Mm_RefGenesMapped";
            }
        }
        return dbName;
    }

    private void loadGenes(String sql, int species) {
        Hashtable<String, RefGeneLinkData> uniqueGenes = new Hashtable<String, RefGeneLinkData>();
        this.geneData = new Vector();
        DSqlHandler objPersist = new DSqlHandler();
        ResultSet rs = objPersist.fetchItemsCSV(sql);
        RefGeneLinkData curGeneData = null;
        try {
            while (rs.next()) {
                IGeneData testGeneData;
                int chromosome = CGHUtility.convertStringToChrom(rs.getString("chrom"), species);
                String geneName = rs.getString("name");
                if (chromosome == -1 || geneName == null || (testGeneData = (IGeneData)uniqueGenes.get(geneName)) != null) continue;
                curGeneData = new RefGeneLinkData();
                curGeneData.populate(rs, species);
                this.geneData.add(curGeneData);
                uniqueGenes.put(curGeneData.getName(), curGeneData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Vector getGeneData() {
        return this.geneData;
    }

    public void setGeneData(Vector geneData) {
        this.geneData = geneData;
    }
}

