/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataObj;

import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.Vector;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHDataObj.IGeneData;
import org.tigr.microarray.mev.cgh.CGHDataObj.IGeneDataSet;
import org.tigr.microarray.mev.cgh.CGHDataObj.RefGeneLinkData;
import org.tigr.microarray.mev.cgh.CGHUtil.CGHUtility;
import org.tigr.microarray.mev.cgh.DBObj.DSqlHandler;

public class DataRegionGeneData
implements IGeneDataSet {
    ICGHDataRegion dataRegion;
    Vector geneData;

    public DataRegionGeneData(ICGHDataRegion dataRegion) {
        this.dataRegion = dataRegion;
    }

    public void loadGeneData(int species) {
        String db = this.getDBName(species);
        int regionSt = this.dataRegion.getStart() - 1000000;
        if (regionSt <= 0) {
            regionSt = 0;
        }
        int regionStop = this.dataRegion.getStop() + 1000000;
        String sql = "SELECT chrom, txStart, txEnd, name, locusLinkId FROM \"" + db + "\"" + " WHERE chrom = " + CGHUtility.encap(CGHUtility.convertChromToString(this.dataRegion.getChromosomeIndex() + 1, species)) + " AND txStart >= " + regionSt + " AND txEnd <= " + regionStop + " GROUP BY chrom, txStart, txEnd, name, locusLinkId";
        System.out.println("Show Genes Sql: " + sql);
        this.loadGenes(sql, species);
    }

    private String getDBName(int species) {
        String dbName = "";
        switch (species) {
            case 0: {
                dbName = "Hs_RefGenesMapped";
                break;
            }
            case 1: {
                dbName = "Mm_RefGenesMapped";
            }
        }
        return dbName;
    }

    private void loadGenes(String sql, int species) {
        Hashtable<String, RefGeneLinkData> uniqueGenes = new Hashtable<String, RefGeneLinkData>();
        this.geneData = new Vector();
        DSqlHandler objPersist = new DSqlHandler();
        ResultSet rs = objPersist.fetchItemsCSV(sql);
        RefGeneLinkData curGeneData = null;
        try {
            while (rs.next()) {
                String geneName = rs.getString("name");
                IGeneData testGeneData = (IGeneData)uniqueGenes.get(geneName);
                if (testGeneData != null) continue;
                curGeneData = new RefGeneLinkData();
                curGeneData.populate(rs, species);
                this.geneData.add(curGeneData);
                uniqueGenes.put(curGeneData.getName(), curGeneData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Vector getGeneData() {
        return this.geneData;
    }

    public void setGeneData(Vector geneData) {
        this.geneData = geneData;
    }

    public ICGHDataRegion getDataRegion() {
        return this.dataRegion;
    }

    public void setDataRegion(ICGHDataRegion dataRegion) {
        this.dataRegion = dataRegion;
    }
}

