/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataObj;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigr.microarray.mev.cgh.CGHDataObj.CytoBand;

public class CytoBands {
    private Vector[] cytoBands = new Vector[24];

    public CytoBands() {
        for (int i = 0; i < this.cytoBands.length; ++i) {
            this.cytoBands[i] = new Vector();
        }
    }

    public Vector[] getCytoBands() {
        return this.cytoBands;
    }

    public Vector getDataElementsAt(int chromosomeIndex) {
        return this.cytoBands[chromosomeIndex];
    }

    public void setCytoBands(Vector[] cytoBands) {
        this.cytoBands = cytoBands;
    }

    public void loadAllCytoBands(File file, int species) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            Vector<CytoBand> allCytoBands = new Vector<CytoBand>();
            CytoBand curCytoBand2 = null;
            while ((line = reader.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, "\t");
                String chromosome = st.nextToken();
                int chromStart = Integer.parseInt(st.nextToken());
                int chromEnd = Integer.parseInt(st.nextToken());
                String name = st.nextToken();
                String stain = st.nextToken();
                curCytoBand2 = new CytoBand(chromosome, chromStart, chromEnd, name, stain, species);
                allCytoBands.add(curCytoBand2);
            }
            reader.close();
            for (CytoBand curCytoBand2 : allCytoBands) {
                if (curCytoBand2.getChromosome() <= 0) continue;
                this.cytoBands[curCytoBand2.getChromosome() - 1].add(curCytoBand2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

