/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataObj;

import java.sql.ResultSet;
import org.tigr.microarray.mev.cgh.CGHUtil.CGHUtility;

public class CytoBand {
    private int chromosome;
    private int chromStart;
    private int chromEnd;
    private String name;
    private String stain;

    public CytoBand() {
    }

    public CytoBand(String chromosome, int chromStart, int chromEnd, String name, String stain, int species) {
        this.chromosome = CGHUtility.convertStringToChrom(chromosome, species);
        this.chromStart = chromStart;
        this.chromEnd = chromEnd;
        this.name = name;
        this.stain = stain;
    }

    public void populate(ResultSet rs, int species) {
        try {
            this.chromosome = CGHUtility.convertStringToChrom(rs.getString("chrom"), species);
            this.chromStart = rs.getInt("chromStart");
            this.chromEnd = rs.getInt("chromEnd");
            this.name = rs.getString("name");
            this.stain = rs.getString("gieStain");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getChromosome() {
        return this.chromosome;
    }

    public void setChromosome(int chrom) {
        this.chromosome = chrom;
    }

    public int getChromStart() {
        return this.chromStart;
    }

    public void setChromStart(int chromStart) {
        this.chromStart = chromStart;
    }

    public int getChromEnd() {
        return this.chromEnd;
    }

    public void setChromEnd(int chromEnd) {
        this.chromEnd = chromEnd;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStain() {
        return this.stain;
    }

    public void setStain(String stain) {
        this.stain = stain;
    }
}

