/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataObj;

import java.util.ArrayList;
import org.tigr.microarray.mev.CGHSlideDataElement;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;
import org.tigr.microarray.mev.cgh.CGHUtil.CGHUtility;
import org.tigr.microarray.mev.cluster.gui.IData;

public class CGHClone
implements ICGHDataRegion {
    public static final int NOT_FOUND = -1;
    protected String name;
    private int chromosome;
    protected int start;
    protected int stop;
    protected float ratio = 0.0f;
    protected int sortedIndex = 0;

    public CGHClone() {
    }

    public CGHClone(String name, String chromosome, String start, String stop, int species) {
        this.name = name;
        try {
            this.chromosome = Integer.parseInt(chromosome);
        }
        catch (NumberFormatException e) {
            this.chromosome = CGHUtility.convertStringToChrom(chromosome, species);
        }
        this.start = Integer.parseInt(start);
        this.stop = Integer.parseInt(stop);
    }

    public CGHClone(String name, int chromosome, int start, int stop) {
        this.name = name;
        this.chromosome = chromosome;
        this.start = start;
        this.stop = stop;
    }

    public CGHClone(String name, String chromosome, int start, int stop, int species) {
        this(name, CGHUtility.convertStringToChrom(chromosome, species), start, stop);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getChromosome() {
        return this.chromosome;
    }

    public void setChromosome(int chromosome) {
        this.chromosome = chromosome;
    }

    @Override
    public int getChromosomeIndex() {
        return this.chromosome - 1;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getStop() {
        return this.stop;
    }

    public void setStop(int stop) {
        this.stop = stop;
    }

    public boolean equals(Object obj) {
        CGHClone obj_T = (CGHClone)obj;
        return this.getChromosome() == obj_T.getChromosome() && this.getName().equals(obj_T.getName()) && this.getStart() == obj_T.getStart();
    }

    public Object clone() {
        return new CGHClone(this.getName().trim(), this.getChromosome(), this.getStart(), this.getStop());
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setSortedIndex(int ind) {
        this.sortedIndex = ind;
    }

    public int getSortedIndex() {
        return this.sortedIndex;
    }

    public String getDesc(IData data) {
        ArrayList features = data.getFeaturesList();
        ISlideData temp = (ISlideData)features.get(0);
        CGHSlideDataElement sde_T1 = (CGHSlideDataElement)temp.getSlideDataElement(this.sortedIndex);
        return sde_T1.getDesc();
    }
}

