/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataObj;

import java.text.NumberFormat;
import java.util.Vector;
import org.tigr.microarray.mev.cgh.CGHDataObj.ICGHDataRegion;

public class AlterationRegion {
    ICGHDataRegion dataRegion;
    int numAlterations = 0;
    int numSamples;
    Vector alteredExperiments = new Vector();
    int numAmplifications;
    int numDeletions;
    String name;
    float[] alteredExperimentValues;

    public ICGHDataRegion getDataRegion() {
        return this.dataRegion;
    }

    public void setDataRegion(ICGHDataRegion dataRegion) {
        this.dataRegion = dataRegion;
    }

    public int getNumAlterations() {
        return this.numAlterations;
    }

    public void setNumAlterations(int numAlterations) {
        this.numAlterations = numAlterations;
    }

    public void incrementAlterations() {
        ++this.numAlterations;
    }

    public float getPercentAltered() {
        return (float)this.numAlterations / (float)this.numSamples;
    }

    public Vector getAlteredExperiments() {
        return this.alteredExperiments;
    }

    public void setAlteredExperiments(Vector alteredExperiments) {
        this.alteredExperiments = alteredExperiments;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int numSamples) {
        this.alteredExperimentValues = new float[numSamples];
        for (int i = 0; i < this.alteredExperimentValues.length; ++i) {
            this.alteredExperimentValues[i] = 0.0f;
        }
        this.numSamples = numSamples;
    }

    public float[] getAlteredExperimentValues() {
        return this.alteredExperimentValues;
    }

    public String getName() {
        NumberFormat nf = NumberFormat.getInstance();
        String name = "Chrom: " + (this.dataRegion.getChromosomeIndex() + 1);
        String startString = nf.format(this.dataRegion.getStart() / 1000000);
        name = name + " Start: " + startString;
        String stopString = nf.format(this.dataRegion.getStop() / 1000000);
        name = name + " Stop: " + stopString;
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumDeletions() {
        return this.numDeletions;
    }

    public void setNumDeletions(int numDeletions) {
        this.numDeletions = numDeletions;
    }

    public int getNumAmplifications() {
        return this.numAmplifications;
    }

    public void setNumAmplifications(int numAmplifications) {
        this.numAmplifications = numAmplifications;
    }

    public float getPercentAmplified() {
        return (float)this.numAmplifications / (float)this.numSamples;
    }

    public float getPercentDeleted() {
        return (float)this.numDeletions / (float)this.numSamples;
    }
}

