/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel;

import java.awt.Color;
import java.util.Vector;
import org.tigr.microarray.mev.cgh.CGHDataObj.CytoBand;
import org.tigr.microarray.mev.cgh.CGHDataObj.CytoBands;

public class CytoBandsModel {
    public Color COLOR_GNEG = Color.lightGray;
    public Color COLOR_GPOS = Color.darkGray;
    public Color COLOR_GVAR = Color.gray;
    public Color COLOR_ACEN = Color.red;
    public Color COLOR_DEFAULT = Color.yellow;
    private CytoBands cytoBands;
    int chromosomeIndex = 0;
    Vector dataElements = new Vector();

    public CytoBandsModel(CytoBands cytoBands) {
        this.cytoBands = cytoBands;
    }

    public void setChromosomeIndex(int chromosomeIndex) {
        this.chromosomeIndex = chromosomeIndex;
        this.dataElements = this.cytoBands.getDataElementsAt(chromosomeIndex);
    }

    public int getNumCytoBands() {
        return this.dataElements.size();
    }

    public int getMaxPosition() {
        int maxPosition = 0;
        for (CytoBand curCytoBand : this.dataElements) {
            if (curCytoBand.getChromEnd() <= maxPosition) continue;
            maxPosition = curCytoBand.getChromEnd();
        }
        return maxPosition;
    }

    public CytoBand getCytoBandAt(int index) {
        return (CytoBand)this.dataElements.get(index);
    }

    public Color getDataPointColor(int cytoBandIndex) {
        String stain = ((CytoBand)this.dataElements.get(cytoBandIndex)).getStain();
        if ("gpos75".equals(stain) || "gpos50".equals(stain) || "gpos100".equals(stain) || "gpos25".equals(stain) || "gpos33".equals(stain) || "gpos66".equals(stain)) {
            return this.COLOR_GPOS;
        }
        if ("gneg".equals(stain)) {
            return this.COLOR_GNEG;
        }
        if ("gvar".equals(stain)) {
            return this.COLOR_GVAR;
        }
        if ("acen".equals(stain)) {
            return this.COLOR_ACEN;
        }
        return this.COLOR_DEFAULT;
    }
}

