/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel;

import java.util.HashMap;

public class SegmentInfo
implements Comparable {
    public static final String[] PVAL_STATISTICS = new String[]{new String("Mean"), new String("Sign pos"), new String("Sign neg")};
    public static final int TYPE_MANUAL = 0;
    public static final int TYPE_AUTO = 1;
    private HashMap statisticsHash = new HashMap();
    private int start = 0;
    private int end = 0;
    private float dataMean = 0.0f;
    private int numPermutations = 0;
    private int type = 1;
    private int bonferroniCorrection = 1;

    public int compareTo(Object other) {
        SegmentInfo otherWindow = (SegmentInfo)other;
        if (this.start < otherWindow.getStart()) {
            return -1;
        }
        if (this.start > otherWindow.getStart()) {
            return 1;
        }
        return 0;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setNumPermutations(int num) {
        this.numPermutations = num;
    }

    public void setDataMean(float d) {
        this.dataMean = d;
    }

    public float getDataMean() {
        return this.dataMean;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getSize() {
        return this.end - this.start + 1;
    }

    public int getNumPermutations() {
        return this.numPermutations;
    }

    public void setStatistic(String statName, float statValue) {
        this.statisticsHash.put(statName, new Float(statValue));
    }

    public float getStatistic(String statName) {
        float retValue = Float.NaN;
        if (this.statisticsHash.containsKey(statName)) {
            retValue = ((Float)this.statisticsHash.get(statName)).floatValue();
        }
        return Math.min(retValue * (float)this.getBonferroniCorrection(), 1.0f);
    }

    public void resetSegment() {
        this.statisticsHash = new HashMap();
        this.dataMean = 0.0f;
        this.numPermutations = 0;
    }

    public void setStatisticsHash(HashMap statsHash) {
        this.statisticsHash = statsHash;
    }

    public HashMap getStatisticsHash() {
        return this.statisticsHash;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public int getBonferroniCorrection() {
        return this.bonferroniCorrection;
    }

    public void setBonferroniCorrection(int num) {
        this.bonferroniCorrection = num;
    }
}

