/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.PValue;
import org.tigr.microarray.mev.cgh.CGHAlgorithms.Charm.SigTestThread;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.SegmentInfo;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.util.FloatMatrix;

public class ResultContainer {
    private static double MERGE_SIGTHRESH = 0.03;
    private static double MERGE_SIZETHRESH = 5.0;
    private static int MERGE_PERMUTATIONS = 50;
    private HashMap segmentHash = null;
    private ArrayList experiments = null;
    private String resultID = null;
    IData data;

    public ResultContainer(IData data, ArrayList exprNames) {
        this.data = data;
        if (this.data == null) {
            System.out.println("In Const. ResultContainer()- data is null");
        }
        this.experiments = exprNames;
        this.segmentHash = new HashMap();
    }

    public ResultContainer(IData data, ArrayList exprNames, HashMap map, String resID) {
        this.data = data;
        if (this.data == null) {
            System.out.println("In SS Const. ResultContainer()- data is null");
        }
        this.experiments = exprNames;
        this.segmentHash = map;
        this.resultID = resID;
    }

    public void addSegment(SegmentInfo newSegment, String exp, int chromosome) {
        if (this.segmentHash.containsKey(exp + "," + chromosome)) {
            ((ArrayList)this.segmentHash.get(exp + "," + chromosome)).add(newSegment);
        } else {
            ArrayList<SegmentInfo> newArray = new ArrayList<SegmentInfo>();
            newArray.add(newSegment);
            this.segmentHash.put(exp + "," + chromosome, newArray);
        }
    }

    public ArrayList getSegments(String exp, int chromosome) {
        ArrayList retArray = null;
        retArray = this.segmentHash.containsKey(exp + "," + chromosome) ? (ArrayList)this.segmentHash.get(exp + "," + chromosome) : new ArrayList();
        return retArray;
    }

    public void setSegments(String exp, int chromosome, ArrayList newSegments) {
        this.segmentHash.put(exp + "," + chromosome, newSegments);
    }

    public HashMap getSegmentHashMap() {
        return this.segmentHash;
    }

    public void setSegmentHashMap(HashMap map) {
        this.segmentHash = map;
    }

    public IData getData() {
        return this.data;
    }

    public void setData(IData dat) {
        this.data = dat;
    }

    public void setExperiments(ArrayList exprs) {
        this.experiments = exprs;
    }

    public ArrayList getExperiments() {
        return this.experiments;
    }

    public void addResults(ResultContainer moreResults) {
        HashMap newSegmentHash = moreResults.getSegmentHashMap();
        ArrayList keyList = new ArrayList(newSegmentHash.keySet());
        for (int i = 0; i < keyList.size(); ++i) {
            if (((ArrayList)newSegmentHash.get(keyList.get(i))).size() <= 0) continue;
            this.segmentHash.put((String)keyList.get(i), (ArrayList)newSegmentHash.get(keyList.get(i)));
        }
    }

    public ArrayList getSegmentsMeetingCriteria(String exp, int chromosome, PValue pvalueCutoff, int pvalTestType) {
        ArrayList allSegments = this.getSegments(exp, chromosome);
        if (allSegments == null) {
            return null;
        }
        ArrayList<SegmentInfo> matches = new ArrayList<SegmentInfo>();
        for (int i = 0; i < allSegments.size(); ++i) {
            SegmentInfo currSeg = (SegmentInfo)allSegments.get(i);
            PValue pval = new PValue(currSeg.getStatistic(new String("Mean")), Math.min(currSeg.getStatistic(new String("Sign neg")), currSeg.getStatistic(new String("Sign pos"))));
            if (pvalueCutoff.compareTo(pval, pvalTestType) < 0) continue;
            matches.add(currSeg);
        }
        return matches;
    }

    public int printToFile(String outFile, boolean append) {
        int status = 0;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile, append));
            int numOfChrs = this.data.getNumChromosomes();
            for (int currChrom = 1; currChrom < numOfChrs; ++currChrom) {
                int currChromInd = currChrom - 1;
                for (int j = 0; j < this.experiments.size(); ++j) {
                    String currExp = (String)this.experiments.get(j);
                    ArrayList segments = this.getSegments(currExp, currChrom);
                    if (segments == null) continue;
                    ArrayList indOrig = this.getOrigIndArray(currExp, currChromInd);
                    for (int k = 0; k < segments.size(); ++k) {
                        SegmentInfo currSeg = (SegmentInfo)segments.get(k);
                        int startIndex = this.lookupGeneIndex(indOrig, currSeg.getStart());
                        int endIndex = this.lookupGeneIndex(indOrig, currSeg.getEnd());
                        out.write(currExp + "\t" + currChrom + "\t" + this.data.getCloneAt(startIndex, currChromInd) + "\t" + this.data.getCloneAt(endIndex, currChromInd) + "\t" + currSeg.getDataMean() + "\t" + currSeg.getStatistic("Sign pos") + "\t" + currSeg.getStatistic("Sign neg") + "\t" + currSeg.getStatistic("Mean") + "\t");
                        out.newLine();
                    }
                }
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            status = -1;
        }
        return status;
    }

    public int printHeaderToFile(String outFile, boolean append) {
        int status = 0;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile, append));
            out.write("Experiment\tChromosome\tStart ID\tEnd ID\tMean value over region\tSign test (positive) p-value\tSign test (negative) p-value\tMean test p-value");
            out.newLine();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            status = -1;
        }
        return status;
    }

    public int printToFile(String outFile, boolean append, PValue pvalCriteria, int pvalTestType) {
        int status = 0;
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outFile, append));
            int numOfChrs = this.data.getNumChromosomes();
            for (int currChrom = 1; currChrom <= numOfChrs; ++currChrom) {
                int currChromInd = currChrom - 1;
                for (int j = 0; j < this.experiments.size(); ++j) {
                    String currExp = (String)this.experiments.get(j);
                    ArrayList segments = this.getSegmentsMeetingCriteria(currExp, currChrom, pvalCriteria, pvalTestType);
                    if (segments == null) continue;
                    ArrayList indOrig = this.getOrigIndArray(currExp, currChromInd);
                    for (int k = 0; k < segments.size(); ++k) {
                        SegmentInfo currSeg = (SegmentInfo)segments.get(k);
                        int startIndex = this.lookupGeneIndex(indOrig, currSeg.getStart());
                        int endIndex = this.lookupGeneIndex(indOrig, currSeg.getEnd());
                        out.write(currExp + "\t" + currChrom + "\t" + this.data.getCloneAt(startIndex, currChromInd) + "\t" + this.data.getCloneAt(endIndex, currChromInd) + "\t" + currSeg.getDataMean() + "\t" + currSeg.getStatistic("Sign pos") + "\t" + currSeg.getStatistic("Sign neg") + "\t" + currSeg.getStatistic("Mean") + "\t");
                        out.newLine();
                    }
                }
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            status = -1;
        }
        return status;
    }

    public void mergeAllSegments() {
        for (int numOfChrs = 0; numOfChrs < this.data.getNumChromosomes(); ++numOfChrs) {
            for (int j = 0; j < this.experiments.size(); ++j) {
                this.mergeSegments((String)this.experiments.get(j), numOfChrs + 1);
            }
        }
    }

    private void mergeSegments(String exp, int chromosome) {
        ArrayList oldSegmentArray = this.getSegments(exp, chromosome);
        ArrayList segmentArray = (ArrayList)oldSegmentArray.clone();
        Collections.sort(segmentArray);
        for (int i = 1; i < segmentArray.size(); ++i) {
            SegmentInfo currLeft = (SegmentInfo)segmentArray.get(i - 1);
            SegmentInfo currRight = (SegmentInfo)segmentArray.get(i);
            if (!((double)(currRight.getStart() - currLeft.getEnd()) < MERGE_SIZETHRESH)) continue;
            if (!((double)currLeft.getStatistic("Mean") < MERGE_SIGTHRESH)) continue;
            if (!((double)currRight.getStatistic("Mean") < MERGE_SIGTHRESH) || !(currRight.getStatistic("Sign pos") < currRight.getStatistic("Sign neg") && currLeft.getStatistic("Sign pos") < currLeft.getStatistic("Sign neg")) && (!(currRight.getStatistic("Sign pos") > currRight.getStatistic("Sign neg")) || !(currLeft.getStatistic("Sign pos") > currLeft.getStatistic("Sign neg")))) continue;
            currLeft.setEnd(currRight.getEnd());
            currLeft.resetSegment();
            float[] geneRatiosOfExprChr = this.getGeneRatiosOfExprChr(chromosome, exp);
            SigTestThread tester = new SigTestThread(geneRatiosOfExprChr, chromosome, exp, currLeft);
            tester.setTests(true, true, false, false);
            tester.runPermuteTest();
            tester.runSignTest();
            segmentArray.remove(i);
            --i;
        }
        this.setSegments(exp, chromosome, segmentArray);
    }

    public float[] getGeneRatiosOfExprChr(int curChr, String expr) {
        String exprName;
        int expr_ind;
        for (expr_ind = 0; expr_ind < this.data.getFeaturesCount() && !(exprName = this.data.getFullSampleName(expr_ind)).equals(expr.trim()); ++expr_ind) {
        }
        Experiment experiment = this.data.getExperiment();
        FloatMatrix fm = experiment.getMatrix();
        int[][] chrIndices = this.data.getChromosomeIndices();
        int st = chrIndices[curChr][0];
        int end = chrIndices[curChr][1];
        float[] geneRatiosOfExprChr = fm.getMatrix(st, end, expr_ind, expr_ind).getColumnPackedCopy();
        return geneRatiosOfExprChr;
    }

    public ArrayList getOrigIndArray(String currExp, int chrInd) {
        ArrayList featuresList = this.data.getFeaturesList();
        int exprInd = -1;
        for (int column = 0; column < featuresList.size(); ++column) {
            String name = ((ISlideData)featuresList.get(column)).getSlideDataName();
            if (!name.trim().equals(currExp.trim())) continue;
            exprInd = column;
            break;
        }
        int[][] chrIndices = this.data.getChromosomeIndices();
        int st = chrIndices[chrInd][0];
        int end = chrIndices[chrInd][1];
        ArrayList<Integer> ratioIndices = new ArrayList<Integer>();
        for (int ii = st; ii < end; ++ii) {
            float tmp = this.data.getLogAverageInvertedValue(exprInd, ii);
            if (Float.isNaN(tmp)) continue;
            ratioIndices.add(new Integer(ii - st));
        }
        return ratioIndices;
    }

    private int lookupGeneIndex(ArrayList indices, int NAIndex) {
        return (Integer)indices.get(NAIndex);
    }

    public void setResultID(String id) {
        this.resultID = id;
    }

    public String getResultID() {
        return this.resultID;
    }
}

