/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel;

import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.IChromGraphNode;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.SegmentInfo;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer.PredictionGraphNode;

public class ChromPredictionsGraphNode
extends PNode
implements IChromGraphNode {
    private int chromNum;
    private String experiment;
    private String resultSet;
    private int type;
    private double lastDx = 0.0;
    private double lastDy = 0.0;
    private double chromWidth;
    private ArrayList predNodes;

    public ChromPredictionsGraphNode(int chrom, String exp, String resultSet) {
        this.chromNum = chrom;
        this.experiment = exp;
        this.resultSet = resultSet;
        this.type = 2;
        this.predNodes = new ArrayList();
    }

    @Override
    public void translate(double dx, double dy) {
        super.translate(dx, dy);
        this.lastDx = dx;
        this.lastDy = dy;
    }

    @Override
    public void reverseLastTranslation() {
        this.translate(-this.lastDx, -this.lastDy);
    }

    public void addPrediction(SegmentInfo currSeg, double startx, double endx) {
        double sign = 1.0;
        if (currSeg.getDataMean() < 0.0f) {
            sign = -1.0;
        }
        PredictionGraphNode predNode = new PredictionGraphNode(startx, endx, sign, currSeg.getType());
        this.predNodes.add(predNode);
        this.addChild(predNode);
    }

    @Override
    public void render() {
        for (int i = 0; i < this.predNodes.size(); ++i) {
            PredictionGraphNode currPred = (PredictionGraphNode)((Object)this.predNodes.get(i));
            currPred.render();
        }
    }

    @Override
    public ArrayList selectChildren(Rectangle2D selectionRect) {
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.predNodes.size(); ++i) {
            PredictionGraphNode currNode = (PredictionGraphNode)((Object)this.predNodes.get(i));
            if (!currNode.getGlobalFullBounds().intersects(selectionRect)) continue;
            currNode.setSelected(true);
            currNode.setChanged(true);
            currNode.render();
            selectedIndices.add(new Integer(i));
        }
        return selectedIndices;
    }

    @Override
    public void unselectChildren(ArrayList unselectIndices) {
        for (int i = 0; i < unselectIndices.size(); ++i) {
            PredictionGraphNode currPred = (PredictionGraphNode)((Object)this.predNodes.get((Integer)unselectIndices.get(i)));
            currPred.setSelected(false);
            currPred.setChanged(true);
            currPred.render();
        }
    }

    public double getChromWidth() {
        return this.chromWidth;
    }

    public void setChromWidth(double width) {
        this.chromWidth = width;
    }

    public int getChromosomeNumber() {
        return this.chromNum;
    }

    public String getExperiment() {
        return this.experiment;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public String getResultSet() {
        return this.resultSet;
    }
}

