/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.nodes.PLine;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.tigr.microarray.mev.cgh.CGHDataModel.CharmDataModel.IChromGraphNode;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDataViewer.GeneGraphNode;

public class ChromDataGraphNode
extends PNode
implements IChromGraphNode {
    private static final Color AXIS_COLOR = Color.BLACK;
    private int chromNum;
    private String experiment;
    private int type;
    private double lastDx = 0.0;
    private double lastDy = 0.0;
    private double yAxisScale = 1.0;
    private ArrayList geneNodes = new ArrayList();
    private PLine axisLine = new PLine();
    private float chromWidth;

    public ChromDataGraphNode(int chrom, String exp) {
        this.chromNum = chrom;
        this.experiment = exp;
        this.type = 1;
    }

    @Override
    public void translate(double dx, double dy) {
        super.translate(dx, dy);
        this.lastDx = dx;
        this.lastDy = dy;
    }

    @Override
    public void reverseLastTranslation() {
        this.translate(-this.lastDx, -this.lastDy);
    }

    public void addGeneNodes(float[] geneData, float scaleFactor, float yAxisScale, ArrayList geneNames) {
        float currx = 0.0f;
        int dataLength = geneData.length;
        GeneGraphNode currNode = null;
        for (int i = 0; i < geneData.length; ++i) {
            currNode = new GeneGraphNode(i, geneData[i] * scaleFactor, scaleFactor, (String)geneNames.get(i));
            currNode.setAxisScale(yAxisScale);
            currNode.setChanged(true);
            currx = (float)i / (float)dataLength * this.chromWidth;
            currNode.translate(currx, 0.0);
            this.geneNodes.add(currNode);
            this.addChild(currNode);
        }
    }

    public void setAxisScale(double newScale) {
        double currValue = 0.0;
        GeneGraphNode currGene = null;
        for (int i = 0; i < this.geneNodes.size(); ++i) {
            currGene = (GeneGraphNode)((Object)this.geneNodes.get(i));
            currGene.setAxisScale(newScale);
            currGene.setChanged(true);
        }
        this.yAxisScale = newScale;
    }

    public void addPredictionNodes(double[] geneData, double scaleFactor, double yAxisScale, ArrayList geneNames) {
        double currx = 0.0;
        int dataLength = geneData.length;
        for (int i = 0; i < geneData.length; ++i) {
            GeneGraphNode currNode = new GeneGraphNode(i, geneData[i] * scaleFactor, scaleFactor, (String)geneNames.get(i));
            currx = (double)i / (double)dataLength * (double)this.chromWidth;
            currNode.translate(currx, 0.0);
            this.geneNodes.add(currNode);
            this.addChild(currNode);
        }
    }

    @Override
    public void render() {
        int numGenes = this.geneNodes.size();
        for (int i = 0; i < numGenes; ++i) {
            GeneGraphNode currGene = (GeneGraphNode)((Object)this.geneNodes.get(i));
            currGene.render();
        }
    }

    public PNode getIntersectingChild(Rectangle2D rect) {
        GeneGraphNode currNode = null;
        GeneGraphNode intersectingNode = null;
        boolean found = false;
        float geneWidth = this.getChromWidth() / (float)this.geneNodes.size();
        for (int i = 0; i < this.geneNodes.size() && !found; ++i) {
            currNode = (GeneGraphNode)((Object)this.geneNodes.get(i));
            if (!currNode.getGlobalFullBounds().intersects(rect)) continue;
            found = true;
            intersectingNode = currNode;
        }
        return intersectingNode;
    }

    public void setTooltip(int geneindex, boolean set) {
        GeneGraphNode currNode = (GeneGraphNode)((Object)this.geneNodes.get(geneindex));
        currNode.setMouseOver(set);
        currNode.render();
    }

    @Override
    public ArrayList selectChildren(Rectangle2D selectionRect) {
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.geneNodes.size(); ++i) {
            GeneGraphNode currNode = (GeneGraphNode)((Object)this.geneNodes.get(i));
            if (!currNode.getGlobalFullBounds().intersects(selectionRect)) continue;
            currNode.setSelected(true);
            currNode.setChanged(true);
            currNode.render();
            selectedIndices.add(new Integer(i));
        }
        return selectedIndices;
    }

    @Override
    public void unselectChildren(ArrayList geneIndices) {
        for (int i = 0; i < geneIndices.size(); ++i) {
            GeneGraphNode currGene = (GeneGraphNode)((Object)this.geneNodes.get((Integer)geneIndices.get(i)));
            currGene.setSelected(false);
            currGene.setChanged(true);
            currGene.render();
        }
    }

    public float getChromWidth() {
        return this.chromWidth;
    }

    public void setChromWidth(float width) {
        this.chromWidth = width;
        this.axisLine = new PLine();
        this.axisLine.setStrokePaint((Paint)Color.BLACK);
        this.axisLine.addPoint(0, 0.0, 0.0);
        this.axisLine.addPoint(1, (double)this.chromWidth, 0.0);
        this.addChild((PNode)this.axisLine);
    }

    public int getChromosomeNumber() {
        return this.chromNum;
    }

    public String getExperiment() {
        return this.experiment;
    }

    @Override
    public int getType() {
        return this.type;
    }
}

