/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.tigr.microarray.mev.cluster.gui.ICGHCloneValueMenu;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class CGHViewerDataModel {
    public static final int CLONE_VALUES_DISCRETE_DETERMINATION = 0;
    public static final int CLONE_VALUES_CONTINUOUS = 1;
    public static final int BAD_CLONE = -10;
    public static final int NO_COPY_CHANGE = -11;
    protected Color COLOR_NULL = Color.darkGray;
    protected Color COLOR_AMP = Color.red;
    protected Color COLOR_AMP_2_COPY = Color.pink;
    protected Color COLOR_DEL = Color.green;
    protected Color COLOR_DEL_2_COPY = Color.yellow;
    protected Color COLOR_DEFAULT = Color.blue;
    protected Color COLOR_ERROR = Color.white;
    protected BufferedImage negColorImage;
    protected BufferedImage posColorImage;
    protected float maxRatioScale;
    protected float minRatioScale;
    protected int cloneValueType;
    IData data;

    public CGHViewerDataModel(IFramework framework) {
        this.data = framework.getData();
        this.negColorImage = framework.getDisplayMenu().getNegativeGradientImage();
        this.posColorImage = framework.getDisplayMenu().getPositiveGradientImage();
    }

    public Color getColor(float value) {
        if (Float.isNaN(value) || value == -10.0f) {
            return this.COLOR_NULL;
        }
        if (this.cloneValueType == 0) {
            return this.getDiscreteColor((int)value);
        }
        return this.getContinuousColor(value);
    }

    public Color getContinuousColor(float value) {
        float maximum = value < 0.0f ? this.minRatioScale : this.maxRatioScale;
        int colorIndex = (int)(255.0f * value / maximum);
        colorIndex = colorIndex > 255 ? 255 : colorIndex;
        colorIndex = colorIndex < 0 ? 0 : colorIndex;
        int rgb = value < 0.0f ? this.negColorImage.getRGB(255 - colorIndex, 0) : this.posColorImage.getRGB(colorIndex, 0);
        return new Color(rgb);
    }

    public Color getDiscreteColor(int copyNumber) {
        if (copyNumber == -10) {
            return this.COLOR_NULL;
        }
        if (copyNumber == -11) {
            return this.COLOR_DEFAULT;
        }
        if (copyNumber < 0) {
            if (copyNumber < -1) {
                return this.COLOR_DEL_2_COPY;
            }
            return this.COLOR_DEL;
        }
        if (copyNumber > 0) {
            if (copyNumber > 1) {
                return this.COLOR_AMP_2_COPY;
            }
            return this.COLOR_AMP;
        }
        return this.COLOR_ERROR;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public void setNegColorImage(BufferedImage negColorImage) {
        this.negColorImage = negColorImage;
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public void setPosColorImage(BufferedImage posColorImage) {
        this.posColorImage = posColorImage;
    }

    public float getMaxRatioScale() {
        return this.maxRatioScale;
    }

    public void setMaxRatioScale(float maxRatioScale) {
        this.maxRatioScale = maxRatioScale;
    }

    public float getMinRatioScale() {
        return this.minRatioScale;
    }

    public void setMinRatioScale(float minRatioScale) {
        this.minRatioScale = minRatioScale;
    }

    public int getCloneValueType() {
        return this.cloneValueType;
    }

    public void setCloneValueType(int cloneValueType) {
        this.cloneValueType = cloneValueType;
    }

    public void onCloneValuesChanged(ICGHCloneValueMenu menu) {
        int type = menu.getCloneValueType();
        this.cloneValueType = type == 0 || type == 2 || type == 3 ? 0 : 1;
    }

    public int getCGHSpecies() {
        return this.data.getCGHSpecies();
    }
}

