/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel;

import org.tigr.microarray.mev.cgh.CGHDataModel.CGHTableDataModel;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class CGHTableDataModelDyeSwap
extends CGHTableDataModel {
    public CGHTableDataModelDyeSwap(IFramework framework, int experimentIndex, int chromosomeIndex) {
        super(framework, experimentIndex, chromosomeIndex);
    }

    @Override
    public int getColumnCount() {
        int valueColumns = 0;
        switch (this.adaptor.cloneValueType) {
            case 1: {
                valueColumns = this.adaptor.experimentIndices.length * 2;
                break;
            }
            case 2: {
                valueColumns = this.adaptor.experimentIndices.length;
                break;
            }
            case 3: {
                valueColumns = this.adaptor.experimentIndices.length * 2;
                break;
            }
            case 0: {
                valueColumns = this.adaptor.experimentIndices.length * 2;
            }
        }
        return valueColumns + this.getNumAnnotationCols();
    }

    @Override
    public Object getDataValueAt(int row, int col) {
        int dataIndex = col - this.getNumAnnotationCols();
        switch (this.adaptor.cloneValueType) {
            case 1: {
                return this.getDyeSwapValue(dataIndex, row);
            }
            case 2: {
                float val = this.getLogAverageInvertedValue(dataIndex, row);
                if (Float.isInfinite(val)) {
                    return null;
                }
                return new Float(val);
            }
            case 3: {
                float val = this.getLogDyeSwapValue(dataIndex, row);
                if (Float.isInfinite(val)) {
                    return new Float(Float.NaN);
                }
                return new Float(val);
            }
            case 0: {
                return this.getCloneDistributionPScoreValue(dataIndex, row);
            }
        }
        return null;
    }

    private Object getDyeSwapValue(int index, int row) {
        int dyeSwapIndex = index % 2;
        int experimentIndex = index / 2;
        if (dyeSwapIndex == 0) {
            return new Float(this.data.getCY3(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(row)));
        }
        if (dyeSwapIndex == 1) {
            return new Float(this.data.getCY5(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(row)));
        }
        return null;
    }

    private float getLogDyeSwapValue(int index, int row) {
        int dyeSwapIndex = index % 2;
        int experimentIndex = index / 2;
        if (dyeSwapIndex == 0) {
            return this.data.getCY3(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(row));
        }
        if (dyeSwapIndex == 1) {
            return this.data.getCY5(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(row));
        }
        return Float.NaN;
    }

    private float getLogAverageInvertedValue(int index, int row) {
        try {
            float val = this.data.getLogAverageInvertedValue(this.adaptor.experimentIndices[index], this.adaptor.getCloneIndex(row));
            return val;
        }
        catch (Exception e) {
            return Float.NaN;
        }
    }

    private Object getCloneDistributionPScoreValue(int index, int row) {
        int dyeSwapIndex = index % 2;
        int experimentIndex = index / 2;
        if (dyeSwapIndex == 0) {
            return new Float(this.data.getPValueByLogCloneDistribution(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(row)));
        }
        if (dyeSwapIndex == 1) {
            return new Float(this.data.getPValueByLogCloneDistribution(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(row)));
        }
        return null;
    }

    @Override
    public String getColumnDataName(int labelIndex) {
        String label = "";
        int dyeSwapIndex = labelIndex % 2;
        int experimentIndex = labelIndex / 2;
        String sampleName = this.data.getSampleName(this.adaptor.experimentIndices[experimentIndex]);
        switch (this.adaptor.cloneValueType) {
            case 1: {
                if (dyeSwapIndex == 0) {
                    label = sampleName + " Cy3";
                    break;
                }
                if (dyeSwapIndex != 1) break;
                label = sampleName + " Cy5";
                break;
            }
            case 2: {
                label = sampleName;
                break;
            }
            case 3: {
                if (dyeSwapIndex == 0) {
                    label = sampleName + " Cy3";
                    break;
                }
                if (dyeSwapIndex != 1) break;
                label = sampleName + " Cy5";
                break;
            }
            case 0: {
                if (dyeSwapIndex == 0) {
                    label = sampleName + " Cy3";
                    break;
                }
                if (dyeSwapIndex != 1) break;
                label = sampleName + " Cy5";
            }
        }
        return label;
    }
}

