/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHBrowserModelAdaptor;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public abstract class CGHTableDataModel
extends AbstractTableModel
implements ChangeListener {
    IData data;
    CGHBrowserModelAdaptor adaptor;

    public CGHTableDataModel(IFramework framework) {
        this(framework, 0, 0);
    }

    public CGHTableDataModel(IFramework framework, int experimentIndex, int chromosomeIndex) {
        this.data = framework.getData();
    }

    @Override
    public abstract int getColumnCount();

    public int getNumAnnotationCols() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.getSeriesSize();
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            switch (col) {
                case 0: {
                    return this.data.getCloneAt(this.adaptor.getCloneIndex(row)).getName();
                }
                case 1: {
                    return new Integer(this.data.getCloneAt(this.adaptor.getCloneIndex(row)).getChromosome());
                }
                case 2: {
                    return new Integer(this.data.getCloneAt(this.adaptor.getCloneIndex(row)).getStart());
                }
                case 3: {
                    return new Integer(this.data.getCloneAt(this.adaptor.getCloneIndex(row)).getStop());
                }
            }
            return this.getDataValueAt(row, col);
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public abstract Object getDataValueAt(int var1, int var2);

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public abstract String getColumnDataName(int var1);

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Clone Name";
            }
            case 1: {
                return "Chromosome";
            }
            case 2: {
                return "Start";
            }
            case 3: {
                return "Stop";
            }
        }
        return this.getColumnDataName(col - this.getNumAnnotationCols());
    }

    public void addListDataListener(ListDataListener listDataListener) {
    }

    public void removeListDataListener(ListDataListener listDataListener) {
    }

    private int getSeriesSize() {
        return this.adaptor.getSeriesSize();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireTableStructureChanged();
    }

    public void setExperimentIndex(int experimentIndex) {
        this.adaptor.setExperimentIndex(experimentIndex);
    }

    public void setChromosomeIndex(int chromosomeIndex) {
        this.adaptor.setChromosomeIndex(chromosomeIndex);
    }

    public void setCloneValueType(int cloneValueType) {
        this.adaptor.setCloneValueType(cloneValueType);
    }

    public CGHBrowserModelAdaptor getAdaptor() {
        return this.adaptor;
    }

    public void setAdaptor(CGHBrowserModelAdaptor adaptor) {
        this.adaptor = adaptor;
    }
}

