/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel;

import java.awt.Color;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHViewerDataModel;
import org.tigr.microarray.mev.cgh.CGHDataModel.IPositionGraphDataModel;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cgh.CGHDataObj.FlankingRegion;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class CGHPositionGraphDataModel
extends CGHViewerDataModel
implements IPositionGraphDataModel {
    int chromosomeIndex;

    public CGHPositionGraphDataModel(IFramework framework, int chromosomeIndex) {
        super(framework);
        this.chromosomeIndex = chromosomeIndex;
    }

    @Override
    public Color getDataPointColor(int cloneIndex, int experimentIndex) {
        CGHClone clone = this.data.getCloneAt(cloneIndex, this.chromosomeIndex);
        float value = this.data.getValue(experimentIndex, cloneIndex, this.chromosomeIndex);
        if (value == -11.0f) {
            return this.COLOR_DEFAULT;
        }
        return this.getColor(value);
    }

    public Color getFlankingRegionColor(int expIndex, int flankingRegionIndex) {
        FlankingRegion fr = this.getFlankingRegionAt(expIndex, flankingRegionIndex);
        if (fr.getType() == 1) {
            if (fr.getSpecifier() == 2) {
                return this.COLOR_DEL;
            }
            if (fr.getSpecifier() == 3) {
                return this.COLOR_DEL_2_COPY;
            }
        } else if (fr.getType() == 0) {
            if (fr.getSpecifier() == 4) {
                return this.COLOR_AMP;
            }
            if (fr.getSpecifier() == 5) {
                return this.COLOR_AMP_2_COPY;
            }
        }
        return this.COLOR_ERROR;
    }

    @Override
    public FlankingRegion getFlankingRegionAt(int expIndex, int flankingRegionIndex) {
        return (FlankingRegion)((ISlideData)this.data.getFeaturesList().get(expIndex)).getFlankingRegions()[this.chromosomeIndex].get(flankingRegionIndex);
    }

    @Override
    public CGHClone getCloneAt(int index) {
        return this.data.getCloneAt(index, this.chromosomeIndex);
    }

    @Override
    public int getMaxClonePosition() {
        int maxCloneIndex = this.data.getChromosomeIndices()[this.chromosomeIndex][1];
        CGHClone clone = this.data.getCloneAt(maxCloneIndex);
        int maxPosition = clone.getStop();
        return maxPosition;
    }

    @Override
    public int getNumElements() {
        return this.data.getFeaturesSize(this.chromosomeIndex);
    }

    @Override
    public int getNumExperiments() {
        return this.data.getFeaturesCount();
    }

    @Override
    public int getNumFlankingRegions(int expIndex) {
        return this.data.getNumFlankingRegions(expIndex, this.chromosomeIndex);
    }

    @Override
    public int getStart(int index) {
        return this.data.getCloneAt(index, this.chromosomeIndex).getStart();
    }

    @Override
    public int getStop(int index) {
        return this.data.getCloneAt(index, this.chromosomeIndex).getStop();
    }

    @Override
    public String getExperimentName(int index) {
        return this.data.getSampleName(index);
    }

    @Override
    public int getChromosomeIndex() {
        return this.chromosomeIndex;
    }

    public void setChromosomeIndex(int chromosomeIndex) {
        this.chromosomeIndex = chromosomeIndex;
    }

    public int getExperimentIndexAt(int index) {
        int[] experimentIndices = this.data.getSamplesOrder();
        return experimentIndices[index];
    }
}

