/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel;

import org.tigr.microarray.mev.cgh.CGHDataModel.CGHChartDataModel;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class CGHChartDataModelNoDyeSwap
extends CGHChartDataModel {
    public CGHChartDataModelNoDyeSwap(IFramework framework, int experimentIndex, int chromosomeIndex) {
        super(framework, experimentIndex, chromosomeIndex);
    }

    @Override
    public int getNumSeries() {
        return this.adaptor.experimentIndices.length;
    }

    @Override
    public String[] getSeriesLabels() {
        int numSeries = this.getNumSeries();
        String[] seriesLabels = new String[numSeries];
        for (int labelIndex = 0; labelIndex < numSeries; ++labelIndex) {
            String sampleName;
            seriesLabels[labelIndex] = sampleName = this.data.getSampleName(this.adaptor.experimentIndices[labelIndex]);
        }
        return seriesLabels;
    }

    @Override
    public double[] getYSeries(int index) {
        double[] ySeries = new double[this.getSeriesSize()];
        for (int i = 0; i < ySeries.length; ++i) {
            int copyNumber;
            if (this.smoothUnconfirmed && ((copyNumber = this.data.getCopyNumberDetermination(this.adaptor.experimentIndices[index], this.adaptor.getCloneIndex(i))) == -10 || copyNumber == -11)) {
                ySeries[i] = 0.0;
                continue;
            }
            float val = this.getDataValue(this.adaptor.experimentIndices[index], this.adaptor.getCloneIndex(i), this.adaptor.getCloneValueType());
            if (Float.isNaN(val) || Float.isInfinite(val)) continue;
            ySeries[i] = val;
        }
        return ySeries;
    }

    private float getDataValue(int experimentIndex, int cloneIndex, int cloneValueType) {
        switch (cloneValueType) {
            case 4: {
                return this.data.getRatio(experimentIndex, cloneIndex, 1);
            }
            case 5: {
                return this.data.getRatio(experimentIndex, cloneIndex, 1);
            }
            case 0: {
                return this.data.getPValueByLogCloneDistribution(experimentIndex, cloneIndex);
            }
        }
        return Float.NaN;
    }
}

