/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel;

import org.tigr.microarray.mev.cgh.CGHDataModel.CGHChartDataModel;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class CGHChartDataModelDyeSwap
extends CGHChartDataModel {
    public CGHChartDataModelDyeSwap(IFramework framework, int experimentIndex, int chromosomeIndex) {
        super(framework, experimentIndex, chromosomeIndex);
    }

    @Override
    public int getNumSeries() {
        switch (this.adaptor.cloneValueType) {
            case 1: {
                return this.adaptor.experimentIndices.length * 2;
            }
            case 2: {
                return this.adaptor.experimentIndices.length;
            }
            case 3: {
                return this.adaptor.experimentIndices.length * 2;
            }
            case 0: {
                return this.adaptor.experimentIndices.length * 2;
            }
        }
        return 0;
    }

    @Override
    public String[] getSeriesLabels() {
        int numSeries = this.getNumSeries();
        String[] seriesLabels = new String[numSeries];
        for (int labelIndex = 0; labelIndex < numSeries; ++labelIndex) {
            String label = "";
            int dyeSwapIndex = labelIndex % 2;
            int experimentIndex = labelIndex / 2;
            String sampleName = this.data.getSampleName(this.adaptor.experimentIndices[experimentIndex]);
            switch (this.adaptor.cloneValueType) {
                case 1: {
                    if (dyeSwapIndex == 0) {
                        label = sampleName + " Cy3";
                        break;
                    }
                    if (dyeSwapIndex != 1) break;
                    label = sampleName + " Cy5";
                    break;
                }
                case 2: {
                    label = sampleName;
                    break;
                }
                case 3: {
                    if (dyeSwapIndex == 0) {
                        label = sampleName + " Cy3";
                        break;
                    }
                    if (dyeSwapIndex != 1) break;
                    label = sampleName + " Cy5";
                    break;
                }
                case 0: {
                    if (dyeSwapIndex == 0) {
                        label = sampleName + " Cy3";
                        break;
                    }
                    if (dyeSwapIndex != 1) break;
                    label = sampleName + " Cy5";
                }
            }
            seriesLabels[labelIndex] = label;
        }
        return seriesLabels;
    }

    @Override
    public double[] getYSeries(int index) {
        switch (this.adaptor.cloneValueType) {
            case 1: {
                return this.generateDyeSwapYSeries(index);
            }
            case 2: {
                return this.generateLogAverageInvertedYSeries(index);
            }
            case 3: {
                return this.generateLogDyeSwapYSeries(index);
            }
            case 0: {
                return this.generateCloneDistributionPScoreYSeries(index);
            }
        }
        return null;
    }

    private double[] generateDyeSwapYSeries(int index) {
        double[] ySeries = new double[this.getSeriesSize()];
        int dyeSwapIndex = index % 2;
        int experimentIndex = index / 2;
        for (int i = 0; i < ySeries.length; ++i) {
            int copyNumber;
            if (this.smoothUnconfirmed && ((copyNumber = this.data.getCopyNumberDetermination(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(i))) == -10 || copyNumber == -11)) {
                ySeries[i] = 1.0;
                continue;
            }
            if (dyeSwapIndex == 0) {
                ySeries[i] = this.data.getRatio(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(i), 0);
                continue;
            }
            if (dyeSwapIndex != 1) continue;
            ySeries[i] = this.data.getRatio(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(i), 1);
        }
        return ySeries;
    }

    private double[] generateLogDyeSwapYSeries(int index) {
        double[] ySeries = new double[this.getSeriesSize()];
        int dyeSwapIndex = index % 2;
        int experimentIndex = index / 2;
        float val = Float.NaN;
        for (int i = 0; i < ySeries.length; ++i) {
            int copyNumber;
            if (this.smoothUnconfirmed && ((copyNumber = this.data.getCopyNumberDetermination(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(i))) == -10 || copyNumber == -11)) {
                ySeries[i] = 0.0;
                continue;
            }
            if (dyeSwapIndex == 0) {
                val = this.data.getCY3(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(i));
            } else if (dyeSwapIndex == 1) {
                val = this.data.getCY5(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(i));
            }
            if (Float.isNaN(val) || Float.isInfinite(val)) continue;
            ySeries[i] = val;
        }
        return ySeries;
    }

    private double[] generateLogAverageInvertedYSeries(int index) {
        double[] ySeries = new double[this.getSeriesSize()];
        for (int i = 0; i < ySeries.length; ++i) {
            int copyNumber;
            if (this.smoothUnconfirmed && ((copyNumber = this.data.getCopyNumberDetermination(this.adaptor.experimentIndices[index], this.adaptor.getCloneIndex(i))) == -10 || copyNumber == -11)) {
                ySeries[i] = 0.0;
                continue;
            }
            float val = this.data.getLogAverageInvertedValue(this.adaptor.experimentIndices[index], this.adaptor.getCloneIndex(i));
            if (Float.isNaN(val) || Float.isInfinite(val)) continue;
            ySeries[i] = val;
        }
        return ySeries;
    }

    private double[] generateCloneDistributionPScoreYSeries(int index) {
        double[] ySeries = new double[this.getSeriesSize()];
        int dyeSwapIndex = index % 2;
        int experimentIndex = index / 2;
        for (int i = 0; i < ySeries.length; ++i) {
            int copyNumber;
            if (this.smoothUnconfirmed && ((copyNumber = this.data.getCopyNumberDetermination(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(i))) == -10 || copyNumber == -11)) {
                ySeries[i] = 0.5;
                continue;
            }
            if (dyeSwapIndex == 0) {
                ySeries[i] = this.data.getPValueByLogCloneDistribution(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(i));
                continue;
            }
            if (dyeSwapIndex != 1) continue;
            ySeries[i] = this.data.getPValueByLogCloneDistribution(this.adaptor.experimentIndices[experimentIndex], this.adaptor.getCloneIndex(i));
        }
        return ySeries;
    }
}

