/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cgh.CGHDataModel;

import com.klg.jclass.chart.ChartDataManageable;
import com.klg.jclass.chart.ChartDataManager;
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataSupport;
import com.klg.jclass.chart.LabelledChartDataModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cgh.CGHDataModel.CGHBrowserModelAdaptor;
import org.tigr.microarray.mev.cgh.CGHDataObj.CGHClone;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public abstract class CGHChartDataModel
extends ChartDataSupport
implements ChartDataModel,
LabelledChartDataModel,
ChartDataManageable,
ChangeListener {
    public static final int CHROM_LOCATION = 0;
    public static final int LINEAR_ORDER = 1;
    int xAxisPositionType = 0;
    boolean smoothUnconfirmed;
    IData data;
    CGHBrowserModelAdaptor adaptor;

    public CGHChartDataModel(IFramework framework) {
        this(framework, 0, 0);
    }

    public CGHChartDataModel(IFramework framework, int experimentIndex, int chromosomeIndex) {
        this.data = framework.getData();
    }

    public ChartDataManager getChartDataManager() {
        return this;
    }

    public String getDataSourceName() {
        return "";
    }

    public abstract int getNumSeries();

    public String[] getPointLabels() {
        String[] labels = new String[this.adaptor.getSeriesSize()];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = this.data.getCloneAt(this.adaptor.getCloneIndex(i)).getName();
        }
        return labels;
    }

    public abstract String[] getSeriesLabels();

    public double[] getXSeries(int index) {
        double[] xSeries = new double[this.getSeriesSize()];
        if (this.adaptor.chromosomeIndex == -1 && this.xAxisPositionType == 0) {
            return this.getXSeriesAllChromosomesChromLocation(xSeries);
        }
        for (int i = 0; i < xSeries.length; ++i) {
            if (this.xAxisPositionType == 0) {
                xSeries[i] = this.data.getCloneAt(this.adaptor.getCloneIndex(i)).getStart();
                continue;
            }
            if (this.xAxisPositionType != 1) continue;
            xSeries[i] = i;
        }
        return xSeries;
    }

    private double[] getXSeriesAllChromosomesChromLocation(double[] xSeries) {
        double total = 0.0;
        int curChromIndex = 0;
        for (int index = 0; index < xSeries.length; ++index) {
            int cloneIndex = this.adaptor.getCloneIndex(index);
            CGHClone clone = this.data.getCloneAt(cloneIndex);
            while (clone.getChromosomeIndex() > curChromIndex) {
                total += (double)this.data.getCloneAt(this.data.getNumDataPointsInChrom(curChromIndex) - 1, curChromIndex).getStart();
                ++curChromIndex;
            }
            xSeries[index] = (double)clone.getStart() + total;
        }
        return xSeries;
    }

    public abstract double[] getYSeries(int var1);

    public int getSeriesSize() {
        return this.adaptor.getSeriesSize();
    }

    public void smoothUnconfirmed(boolean smooth) {
        this.smoothUnconfirmed = smooth;
        this.fireChartDataEvent(12, -1, -1);
    }

    public void setXAxisPositions(int type) {
        this.xAxisPositionType = type;
        this.fireChartDataEvent(12, -1, -1);
    }

    public int getRelativeIndexOf(int absoluteIndex) {
        if (this.adaptor.chromosomeIndex == -1) {
            return absoluteIndex;
        }
        return this.data.getRelativeIndex(absoluteIndex, this.adaptor.chromosomeIndex);
    }

    public int getCloneIndex(CGHClone clone) {
        int absoluteCloneIndex = this.data.getClones().indexOf(clone);
        int relativeIndex = this.getRelativeIndexOf(absoluteCloneIndex);
        return this.adaptor.getIndexOf(relativeIndex);
    }

    public int getStartCloneIndex(CGHClone clone) {
        int cloneIndex;
        int absoluteCloneIndex = this.data.getClones().indexOf(clone);
        int relativeIndex = this.getRelativeIndexOf(absoluteCloneIndex);
        if ((cloneIndex = this.adaptor.getIndexOf(relativeIndex--)) == -1) {
            while ((cloneIndex = this.adaptor.getIndexOf(relativeIndex--)) == -1) {
                if (cloneIndex != 0) continue;
                return 0;
            }
            return cloneIndex + 1;
        }
        return cloneIndex;
    }

    public int getStopCloneIndex(CGHClone clone) {
        try {
            int absoluteCloneIndex = this.data.getClones().indexOf(clone);
            int relativeIndex = this.getRelativeIndexOf(absoluteCloneIndex);
            int cloneIndex = this.adaptor.getIndexOf(relativeIndex++);
            if (cloneIndex >= this.getSeriesSize() - 1) {
                return this.getSeriesSize() - 1;
            }
            if (cloneIndex == -1) {
                while ((cloneIndex = this.adaptor.getIndexOf(relativeIndex++)) == -1) {
                    if (cloneIndex < this.getSeriesSize() - 1) continue;
                    return this.getSeriesSize() - 1;
                }
                return cloneIndex - 1;
            }
            return cloneIndex;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Chart Model getStopCloneIndex out of bounds... returning last index");
            return this.getSeriesSize() - 1;
        }
    }

    public CGHClone getCloneByPosition(int position) {
        for (int i = 0; i < this.data.getNumDataPointsInChrom(this.adaptor.chromosomeIndex); ++i) {
            int startIndex = this.data.getCloneAt(i, this.adaptor.chromosomeIndex).getStart();
            int stopIndex = this.data.getCloneAt(i, this.adaptor.chromosomeIndex).getStop();
            if (startIndex != position && stopIndex != position) continue;
            return this.data.getCloneAt(i, this.adaptor.chromosomeIndex);
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChartDataEvent(12, -1, -1);
    }

    public void setExperimentIndex(int experimentIndex) {
        this.adaptor.setExperimentIndex(experimentIndex);
    }

    public void setChromosomeIndex(int chromosomeIndex) {
        this.adaptor.setChromosomeIndex(chromosomeIndex);
    }

    public void setCloneValueType(int cloneValueType) {
        this.adaptor.setCloneValueType(cloneValueType);
    }

    public CGHBrowserModelAdaptor getAdaptor() {
        return this.adaptor;
    }

    public void setAdaptor(CGHBrowserModelAdaptor adaptor) {
        this.adaptor = adaptor;
    }
}

